/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.ui.internal.runnables.dialogs;

import java.text.DecimalFormat;
import java.text.ParseException;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.database.controller.QuantitationSignalEntryEdit;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.ui.internal.runnables.dialogs.AbstractEntryEditDialog;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.msd.model.core.quantitation.IQuantitationSignalMSD;
import org.eclipse.chemclipse.msd.model.core.quantitation.QuantitationSignalMSD;
import org.eclipse.chemclipse.support.text.ValueFormat;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class QuantitationSignalEntryEditDialog
extends AbstractEntryEditDialog {
    private static final Logger logger = Logger.getLogger(QuantitationSignalEntryEditDialog.class);
    private static final String KEY_ION = "Ion";
    private static final String KEY_RELATIVE_RESPONSE = "Relative Response";
    private static final String KEY_UNCERTAINTY = "Uncertainty";
    private static final String KEY_USE = "Use";
    private QuantitationSignalEntryEdit quantitationSignalEntryEdit;
    private DecimalFormat decimalFormat;

    public QuantitationSignalEntryEditDialog(Shell parentShell, QuantitationSignalEntryEdit quantitationSignalEntryEdit, String title) {
        super(parentShell, title, "Create/Edit a quantitation signal entry.");
        this.quantitationSignalEntryEdit = quantitationSignalEntryEdit;
        this.decimalFormat = ValueFormat.getDecimalFormatEnglish();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            try {
                double ion = this.decimalFormat.parse(this.getWidgetInput(KEY_ION)).doubleValue();
                float relativeResponse = this.decimalFormat.parse(this.getWidgetInput(KEY_RELATIVE_RESPONSE)).floatValue();
                double uncertainty = this.decimalFormat.parse(this.getWidgetInput(KEY_UNCERTAINTY)).doubleValue();
                boolean use = Boolean.parseBoolean(this.getWidgetInput(KEY_USE));
                QuantitationSignalMSD quantitationSignalMSD = new QuantitationSignalMSD(ion, relativeResponse, uncertainty, use);
                this.quantitationSignalEntryEdit.setQuantitationSignalMSD((IQuantitationSignalMSD)quantitationSignalMSD);
            }
            catch (ParseException e) {
                this.setErrorMessage("A value can't be parsed.");
                logger.warn((Object)e);
            }
        }
        super.buttonPressed(buttonId);
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridData layoutData = new GridData(1796);
        layoutData.widthHint = this.convertHorizontalDLUsToPixels(300);
        String ion = "";
        String relativeResponse = "";
        String uncertainty = "";
        boolean use = true;
        IQuantitationSignalMSD quantitationSignalMSD = this.quantitationSignalEntryEdit.getQuantitationSignalMSD();
        if (quantitationSignalMSD != null) {
            ion = this.decimalFormat.format(quantitationSignalMSD.getIon());
            relativeResponse = this.decimalFormat.format(quantitationSignalMSD.getRelativeResponse());
            uncertainty = this.decimalFormat.format(quantitationSignalMSD.getUncertainty());
            use = quantitationSignalMSD.isUse();
        }
        this.createTextInput(composite, layoutData, KEY_ION, "TIC = 0", ion, true);
        this.createTextInput(composite, layoutData, KEY_RELATIVE_RESPONSE, "Max = TIC (100.0)", relativeResponse, true);
        this.createTextInput(composite, layoutData, KEY_UNCERTAINTY, "", uncertainty, true);
        this.createCheckInput(composite, layoutData, KEY_USE, "", use);
        this.validateInput();
        return composite;
    }

    @Override
    protected boolean validateInput() {
        boolean isValid = super.validateInput();
        if (isValid) {
            try {
                double value = this.decimalFormat.parse(this.getWidgetInput(KEY_ION)).doubleValue();
                if (value < 0.0) {
                    this.setErrorMessage("Select a ion >= 0 (TIC = 0).");
                    return false;
                }
            }
            catch (ParseException parseException) {
                this.setErrorMessage("The ion is not valid.");
                return false;
            }
            try {
                float value = this.decimalFormat.parse(this.getWidgetInput(KEY_RELATIVE_RESPONSE)).floatValue();
                if (value <= 0.0f || value > 100.0f) {
                    this.setErrorMessage("Select a relative response >= 0 and <= 100.0.");
                    return false;
                }
            }
            catch (ParseException parseException) {
                this.setErrorMessage("The relative response is not valid.");
                return false;
            }
            try {
                double value = this.decimalFormat.parse(this.getWidgetInput(KEY_UNCERTAINTY)).doubleValue();
                if (value < 0.0) {
                    this.setErrorMessage("Select a uncertainty value >= 0.");
                    return false;
                }
            }
            catch (ParseException parseException) {
                this.setErrorMessage("The uncertainty value is not valid.");
                return false;
            }
        }
        return isValid;
    }
}

