/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.converter.supplier.chemclipse.internal.io;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotWriteableException;
import org.eclipse.chemclipse.converter.io.AbstractChromatogramWriter;
import org.eclipse.chemclipse.model.baseline.IBaselineModel;
import org.eclipse.chemclipse.model.core.IIntegrationEntry;
import org.eclipse.chemclipse.model.identifier.IComparisonResult;
import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;
import org.eclipse.chemclipse.model.identifier.ILibraryInformation;
import org.eclipse.chemclipse.model.quantitation.IQuantitationEntry;
import org.eclipse.chemclipse.model.targets.IPeakTarget;
import org.eclipse.chemclipse.msd.converter.io.IChromatogramMSDWriter;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.IChromatogramPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IIntegrationEntryMSD;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IIonTransition;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IPeakMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IPeakModelMSD;
import org.eclipse.chemclipse.msd.model.core.IRegularMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IVendorMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.identifier.chromatogram.IChromatogramTargetMSD;
import org.eclipse.chemclipse.msd.model.core.quantitation.IQuantitationEntryMSD;
import org.eclipse.chemclipse.support.history.IEditHistory;
import org.eclipse.chemclipse.support.history.IEditInformation;
import org.eclipse.chemclipse.xxd.converter.supplier.chemclipse.preferences.PreferenceSupplier;
import org.eclipse.core.runtime.IProgressMonitor;

public class ChromatogramWriter_0903
extends AbstractChromatogramWriter
implements IChromatogramMSDWriter {
    public void writeChromatogram(File file, IChromatogramMSD chromatogram, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotWriteableException, IOException {
        monitor.subTask("Export Chromatogram");
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(fileOutputStream));
        zipOutputStream.setLevel(PreferenceSupplier.getCompressionLevel());
        zipOutputStream.setMethod(8);
        this.writeVersion(zipOutputStream, monitor);
        this.writeOverviewFolder(zipOutputStream, chromatogram, monitor);
        this.writeChromatogramFolder(zipOutputStream, chromatogram, monitor);
        zipOutputStream.flush();
        zipOutputStream.close();
    }

    private void writeVersion(ZipOutputStream zipOutputStream, IProgressMonitor monitor) throws IOException {
        ZipEntry zipEntry = new ZipEntry("VERSION");
        zipOutputStream.putNextEntry(zipEntry);
        DataOutputStream dataOutputStream = new DataOutputStream(zipOutputStream);
        String version = "0.9.0.3";
        dataOutputStream.writeInt(version.length());
        dataOutputStream.writeChars(version);
        dataOutputStream.flush();
        zipOutputStream.closeEntry();
    }

    private void writeOverviewFolder(ZipOutputStream zipOutputStream, IChromatogramMSD chromatogram, IProgressMonitor monitor) throws IOException {
        ZipEntry zipEntry = new ZipEntry("OVERVIEW/");
        zipOutputStream.putNextEntry(zipEntry);
        zipOutputStream.closeEntry();
        zipEntry = new ZipEntry("OVERVIEW/TIC");
        zipOutputStream.putNextEntry(zipEntry);
        DataOutputStream dataOutputStream = new DataOutputStream(zipOutputStream);
        int scans = chromatogram.getNumberOfScans();
        dataOutputStream.writeInt(scans);
        int scan = 1;
        while (scan <= scans) {
            monitor.subTask("Export Scan: " + scan);
            dataOutputStream.writeInt(chromatogram.getScan(scan).getRetentionTime());
            dataOutputStream.writeFloat(chromatogram.getScan(scan).getTotalSignal());
            ++scan;
        }
        dataOutputStream.flush();
        zipOutputStream.closeEntry();
    }

    private void writeChromatogramFolder(ZipOutputStream zipOutputStream, IChromatogramMSD chromatogram, IProgressMonitor monitor) throws IOException {
        ZipEntry zipEntry = new ZipEntry("CHROMATOGRAM/");
        zipOutputStream.putNextEntry(zipEntry);
        zipOutputStream.closeEntry();
        this.writeChromatogramScans(zipOutputStream, chromatogram, monitor);
        this.writeChromatogramBaseline(zipOutputStream, chromatogram, monitor);
        this.writeChromatogramPeaks(zipOutputStream, chromatogram, monitor);
        this.writeChromatogramArea(zipOutputStream, chromatogram, monitor);
        this.writeChromatogramIdentification(zipOutputStream, chromatogram, monitor);
        this.writeChromatogramHistory(zipOutputStream, chromatogram, monitor);
        this.writeChromatogramMiscellaneous(zipOutputStream, chromatogram, monitor);
    }

    private void writeChromatogramScans(ZipOutputStream zipOutputStream, IChromatogramMSD chromatogram, IProgressMonitor monitor) throws IOException {
        ZipEntry zipEntry = new ZipEntry("CHROMATOGRAM/SCANS");
        zipOutputStream.putNextEntry(zipEntry);
        DataOutputStream dataOutputStream = new DataOutputStream(zipOutputStream);
        int scans = chromatogram.getNumberOfScans();
        dataOutputStream.writeInt(scans);
        int scan = 1;
        while (scan <= scans) {
            monitor.subTask("Export Scan: " + scan);
            IVendorMassSpectrum massSpectrum = chromatogram.getSupplierScan(scan);
            this.writeMassSpectrum(dataOutputStream, (IRegularMassSpectrum)massSpectrum);
            ++scan;
        }
        dataOutputStream.flush();
        zipOutputStream.closeEntry();
    }

    private void writeChromatogramBaseline(ZipOutputStream zipOutputStream, IChromatogramMSD chromatogram, IProgressMonitor monitor) throws IOException {
        ZipEntry zipEntry = new ZipEntry("CHROMATOGRAM/BASELINE");
        zipOutputStream.putNextEntry(zipEntry);
        DataOutputStream dataOutputStream = new DataOutputStream(zipOutputStream);
        int scans = chromatogram.getNumberOfScans();
        dataOutputStream.writeInt(scans);
        IBaselineModel baselineModel = chromatogram.getBaselineModel();
        int scan = 1;
        while (scan <= scans) {
            monitor.subTask("Export Basline: " + scan);
            int retentionTime = chromatogram.getSupplierScan(scan).getRetentionTime();
            float backgroundAbundance = baselineModel.getBackgroundAbundance(retentionTime);
            dataOutputStream.writeInt(retentionTime);
            dataOutputStream.writeFloat(backgroundAbundance);
            ++scan;
        }
        dataOutputStream.flush();
        zipOutputStream.closeEntry();
    }

    private void writeChromatogramPeaks(ZipOutputStream zipOutputStream, IChromatogramMSD chromatogram, IProgressMonitor monitor) throws IOException {
        ZipEntry zipEntry = new ZipEntry("CHROMATOGRAM/PEAKS");
        zipOutputStream.putNextEntry(zipEntry);
        DataOutputStream dataOutputStream = new DataOutputStream(zipOutputStream);
        List peaks = chromatogram.getPeaks();
        dataOutputStream.writeInt(peaks.size());
        int counter = 1;
        for (IChromatogramPeakMSD peak : peaks) {
            monitor.subTask("Export Peak: " + counter++);
            this.writePeak(dataOutputStream, (IPeakMSD)peak);
        }
        dataOutputStream.flush();
        zipOutputStream.closeEntry();
    }

    private void writeChromatogramArea(ZipOutputStream zipOutputStream, IChromatogramMSD chromatogram, IProgressMonitor monitor) throws IOException {
        ZipEntry zipEntry = new ZipEntry("CHROMATOGRAM/AREA");
        zipOutputStream.putNextEntry(zipEntry);
        DataOutputStream dataOutputStream = new DataOutputStream(zipOutputStream);
        List chromatogramIntegrationEntries = chromatogram.getChromatogramIntegrationEntries();
        this.writeString(dataOutputStream, chromatogram.getChromatogramIntegratorDescription());
        this.writeIntegrationEntries(dataOutputStream, chromatogramIntegrationEntries);
        List backgroundIntegrationEntries = chromatogram.getBackgroundIntegrationEntries();
        this.writeString(dataOutputStream, chromatogram.getBackgroundIntegratorDescription());
        this.writeIntegrationEntries(dataOutputStream, backgroundIntegrationEntries);
        dataOutputStream.flush();
        zipOutputStream.closeEntry();
    }

    private void writeChromatogramIdentification(ZipOutputStream zipOutputStream, IChromatogramMSD chromatogram, IProgressMonitor monitor) throws IOException {
        ZipEntry zipEntry = new ZipEntry("CHROMATOGRAM/IDENTIFICATION");
        zipOutputStream.putNextEntry(zipEntry);
        DataOutputStream dataOutputStream = new DataOutputStream(zipOutputStream);
        List chromatogramTargets = chromatogram.getTargets();
        dataOutputStream.writeInt(chromatogramTargets.size());
        for (IChromatogramTargetMSD chromatogramTarget : chromatogramTargets) {
            if (!(chromatogramTarget instanceof IIdentificationTarget)) continue;
            IChromatogramTargetMSD identificationEntry = chromatogramTarget;
            this.writeIdentificationEntry(dataOutputStream, (IIdentificationTarget)identificationEntry);
        }
        dataOutputStream.flush();
        zipOutputStream.closeEntry();
    }

    private void writeChromatogramHistory(ZipOutputStream zipOutputStream, IChromatogramMSD chromatogram, IProgressMonitor monitor) throws IOException {
        ZipEntry zipEntry = new ZipEntry("CHROMATOGRAM/HISTORY");
        zipOutputStream.putNextEntry(zipEntry);
        DataOutputStream dataOutputStream = new DataOutputStream(zipOutputStream);
        IEditHistory editHistory = chromatogram.getEditHistory();
        dataOutputStream.writeInt(editHistory.getHistoryList().size());
        for (IEditInformation editInformation : editHistory.getHistoryList()) {
            dataOutputStream.writeLong(editInformation.getDate().getTime());
            this.writeString(dataOutputStream, editInformation.getDescription());
        }
        dataOutputStream.flush();
        zipOutputStream.closeEntry();
    }

    private void writeChromatogramMiscellaneous(ZipOutputStream zipOutputStream, IChromatogramMSD chromatogram, IProgressMonitor monitor) throws IOException {
        ZipEntry zipEntry = new ZipEntry("CHROMATOGRAM/MISC");
        zipOutputStream.putNextEntry(zipEntry);
        DataOutputStream dataOutputStream = new DataOutputStream(zipOutputStream);
        dataOutputStream.writeLong(chromatogram.getDate().getTime());
        this.writeString(dataOutputStream, chromatogram.getMiscInfo());
        this.writeString(dataOutputStream, chromatogram.getOperator());
        dataOutputStream.flush();
        zipOutputStream.closeEntry();
    }

    private void writeMassSpectrum(DataOutputStream dataOutputStream, IRegularMassSpectrum massSpectrum) throws IOException {
        dataOutputStream.writeShort(massSpectrum.getMassSpectrometer());
        dataOutputStream.writeShort(massSpectrum.getMassSpectrumType());
        dataOutputStream.writeDouble(massSpectrum.getPrecursorIon());
        dataOutputStream.writeInt(massSpectrum.getRetentionTime());
        dataOutputStream.writeFloat(massSpectrum.getRetentionIndex());
        List ions = massSpectrum.getIons();
        this.writeMassSpectrumIons(dataOutputStream, ions);
    }

    private void writeMassSpectrumIons(DataOutputStream dataOutputStream, List<IIon> ions) throws IOException {
        dataOutputStream.writeInt(ions.size());
        for (IIon ion : ions) {
            dataOutputStream.writeDouble(ion.getIon());
            dataOutputStream.writeFloat(ion.getAbundance());
            IIonTransition ionTransition = ion.getIonTransition();
            if (ionTransition == null) {
                dataOutputStream.writeInt(0);
                continue;
            }
            dataOutputStream.writeInt(1);
            dataOutputStream.writeDouble(ionTransition.getQ1StartIon());
            dataOutputStream.writeDouble(ionTransition.getQ1StopIon());
            dataOutputStream.writeDouble(ionTransition.getQ3StartIon());
            dataOutputStream.writeDouble(ionTransition.getQ3StopIon());
            dataOutputStream.writeDouble(ionTransition.getCollisionEnergy());
            dataOutputStream.writeDouble(ionTransition.getQ1Resolution());
            dataOutputStream.writeDouble(ionTransition.getQ3Resolution());
            dataOutputStream.writeInt(ionTransition.getTransitionGroup());
        }
    }

    private void writePeak(DataOutputStream dataOutputStream, IPeakMSD peak) throws IOException {
        IPeakModelMSD peakModel = peak.getPeakModel();
        this.writeString(dataOutputStream, peak.getDetectorDescription());
        this.writeString(dataOutputStream, peak.getIntegratorDescription());
        this.writeString(dataOutputStream, peak.getModelDescription());
        this.writeString(dataOutputStream, peak.getPeakType().toString());
        dataOutputStream.writeInt(peak.getSuggestedNumberOfComponents());
        dataOutputStream.writeFloat(peakModel.getBackgroundAbundance(peakModel.getStartRetentionTime()));
        dataOutputStream.writeFloat(peakModel.getBackgroundAbundance(peakModel.getStopRetentionTime()));
        IPeakMassSpectrum massSpectrum = peakModel.getPeakMassSpectrum();
        this.writeMassSpectrum(dataOutputStream, (IRegularMassSpectrum)massSpectrum);
        List retentionTimes = peakModel.getRetentionTimes();
        dataOutputStream.writeInt(retentionTimes.size());
        Iterator iterator = retentionTimes.iterator();
        while (iterator.hasNext()) {
            int retentionTime = (Integer)iterator.next();
            dataOutputStream.writeInt(retentionTime);
            dataOutputStream.writeFloat(peakModel.getPeakAbundance(retentionTime));
        }
        List integrationEntries = peak.getIntegrationEntries();
        this.writeIntegrationEntries(dataOutputStream, integrationEntries);
        List peakTargets = peak.getTargets();
        dataOutputStream.writeInt(peakTargets.size());
        for (IPeakTarget peakTarget : peakTargets) {
            if (!(peakTarget instanceof IIdentificationTarget)) continue;
            IPeakTarget identificationEntry = peakTarget;
            this.writeIdentificationEntry(dataOutputStream, (IIdentificationTarget)identificationEntry);
        }
        List quantitationEntries = peak.getQuantitationEntries();
        dataOutputStream.writeInt(quantitationEntries.size());
        for (IQuantitationEntry quantitationEntry : quantitationEntries) {
            this.writeString(dataOutputStream, quantitationEntry.getName());
            this.writeString(dataOutputStream, quantitationEntry.getChemicalClass());
            dataOutputStream.writeDouble(quantitationEntry.getConcentration());
            this.writeString(dataOutputStream, quantitationEntry.getConcentrationUnit());
            dataOutputStream.writeDouble(quantitationEntry.getArea());
            this.writeString(dataOutputStream, quantitationEntry.getCalibrationMethod());
            dataOutputStream.writeBoolean(quantitationEntry.getUsedCrossZero());
            this.writeString(dataOutputStream, quantitationEntry.getDescription());
            if (quantitationEntry instanceof IQuantitationEntryMSD) {
                dataOutputStream.writeBoolean(true);
                IQuantitationEntryMSD quantitationEntryMSD = (IQuantitationEntryMSD)quantitationEntry;
                dataOutputStream.writeDouble(quantitationEntryMSD.getIon());
                continue;
            }
            dataOutputStream.writeBoolean(false);
        }
    }

    private void writeIntegrationEntries(DataOutputStream dataOutputStream, List<? extends IIntegrationEntry> integrationEntries) throws IOException {
        dataOutputStream.writeInt(integrationEntries.size());
        for (IIntegrationEntry iIntegrationEntry : integrationEntries) {
            if (!(iIntegrationEntry instanceof IIntegrationEntryMSD)) continue;
            IIntegrationEntryMSD integrationEntryMSD = (IIntegrationEntryMSD)iIntegrationEntry;
            dataOutputStream.writeDouble(integrationEntryMSD.getIon());
            dataOutputStream.writeDouble(integrationEntryMSD.getIntegratedArea());
        }
    }

    private void writeIdentificationEntry(DataOutputStream dataOutputStream, IIdentificationTarget identificationEntry) throws IOException {
        ILibraryInformation libraryInformation = identificationEntry.getLibraryInformation();
        IComparisonResult comparisonResult = identificationEntry.getComparisonResult();
        this.writeString(dataOutputStream, identificationEntry.getIdentifier());
        this.writeString(dataOutputStream, libraryInformation.getCasNumber());
        this.writeString(dataOutputStream, libraryInformation.getComments());
        this.writeString(dataOutputStream, libraryInformation.getMiscellaneous());
        this.writeString(dataOutputStream, libraryInformation.getName());
        Set synonyms = libraryInformation.getSynonyms();
        int numberOfSynonyms = synonyms.size();
        dataOutputStream.writeInt(numberOfSynonyms);
        for (String synonym : synonyms) {
            this.writeString(dataOutputStream, synonym);
        }
        this.writeString(dataOutputStream, libraryInformation.getFormula());
        dataOutputStream.writeDouble(libraryInformation.getMolWeight());
        dataOutputStream.writeFloat(comparisonResult.getMatchFactor());
        dataOutputStream.writeFloat(comparisonResult.getReverseMatchFactor());
        dataOutputStream.writeFloat(comparisonResult.getProbability());
    }

    private void writeString(DataOutputStream dataOutputStream, String value) throws IOException {
        dataOutputStream.writeInt(value.length());
        dataOutputStream.writeChars(value);
    }
}

