/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.visualization.internal.xygraph.toolbar;

import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.nebula.visualization.internal.xygraph.toolbar.DoubleInputText;
import org.eclipse.nebula.visualization.xygraph.figures.Axis;
import org.eclipse.nebula.visualization.xygraph.figures.IXYGraph;
import org.eclipse.nebula.visualization.xygraph.figures.XYGraph;
import org.eclipse.nebula.visualization.xygraph.linearscale.Range;
import org.eclipse.nebula.visualization.xygraph.util.XYGraphMediaFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Text;

public class AxisConfigPage {
    private IXYGraph xyGraph;
    private Axis axis;
    private Text titleText;
    private Label scaleFontLabel;
    private Font scaleFont;
    private Label titleFontLabel;
    private Font titleFont;
    private ColorSelector axisColorSelector;
    private Button primaryButton;
    private Button logButton;
    private Button autoScaleButton;
    private Label maxOrAutoScaleLabel;
    private DoubleInputText maxOrAutoScaleThrText;
    private Label minLabel;
    private DoubleInputText minText;
    private Button dateEnabledButton;
    private Button autoFormat;
    private Label formatLabel;
    private Text formatText;
    private Button showGridButton;
    private Button dashGridLineButton;
    private ColorSelector gridColorSelector;
    private Composite composite;

    public AxisConfigPage(IXYGraph xyGraph, Axis axis) {
        this((XYGraph)xyGraph, axis);
    }

    @Deprecated
    public AxisConfigPage(XYGraph xyGraph, Axis axis) {
        this.xyGraph = xyGraph;
        this.axis = axis;
        this.scaleFont = axis.getFont();
        this.titleFont = axis.getTitleFont();
    }

    public void createPage(final Composite composite) {
        this.composite = composite;
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)new GridLayout(3, false));
        GridData labelGd = new GridData(4, 0x1000000, false, false, 1, 1);
        Label titleLabel = new Label(composite, 0);
        titleLabel.setText("Title: ");
        titleLabel.setLayoutData((Object)labelGd);
        this.titleText = new Text(composite, 2052);
        GridData gd = new GridData(4, 0x1000000, true, false, 2, 1);
        this.titleText.setLayoutData((Object)gd);
        this.titleFontLabel = new Label(composite, 0);
        labelGd = new GridData(4, 0x1000000, false, false, 2, 1);
        this.titleFontLabel.setLayoutData((Object)labelGd);
        Button titleFontButton = new Button(composite, 8);
        titleFontButton.setText("Change...");
        gd = new GridData(1, 0x1000000, false, false, 1, 1);
        titleFontButton.setLayoutData((Object)gd);
        titleFontButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FontData fontData;
                FontDialog fontDialog = new FontDialog(composite.getShell());
                if (AxisConfigPage.this.titleFont != null) {
                    fontDialog.setFontList(AxisConfigPage.this.titleFont.getFontData());
                }
                if ((fontData = fontDialog.open()) != null) {
                    AxisConfigPage.this.titleFont = XYGraphMediaFactory.getInstance().getFont(fontData);
                    AxisConfigPage.this.titleFontLabel.setFont(AxisConfigPage.this.titleFont);
                    AxisConfigPage.this.titleFontLabel.setText("Title Font: " + fontData.getName());
                    composite.getShell().layout(true, true);
                }
            }
        });
        this.scaleFontLabel = new Label(composite, 0);
        labelGd = new GridData(4, 0x1000000, false, false, 2, 1);
        this.scaleFontLabel.setLayoutData((Object)labelGd);
        Button scaleFontButton = new Button(composite, 8);
        scaleFontButton.setText("Change...");
        gd = new GridData(1, 0x1000000, false, false, 1, 1);
        scaleFontButton.setLayoutData((Object)gd);
        scaleFontButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FontData fontData;
                FontDialog fontDialog = new FontDialog(composite.getShell());
                if (AxisConfigPage.this.scaleFont != null) {
                    fontDialog.setFontList(AxisConfigPage.this.scaleFont.getFontData());
                }
                if ((fontData = fontDialog.open()) != null) {
                    AxisConfigPage.this.scaleFont = XYGraphMediaFactory.getInstance().getFont(fontData);
                    AxisConfigPage.this.scaleFontLabel.setFont(AxisConfigPage.this.scaleFont);
                    AxisConfigPage.this.scaleFontLabel.setText("Scale Font: " + fontData.getName());
                    composite.getShell().layout(true, true);
                }
            }
        });
        Label colorLabel = new Label(composite, 0);
        colorLabel.setText("Axis Color:");
        labelGd = new GridData(4, 0x1000000, false, false, 2, 1);
        colorLabel.setLayoutData((Object)labelGd);
        this.axisColorSelector = new ColorSelector(composite);
        gd = new GridData(1, 0x1000000, false, false, 1, 1);
        this.axisColorSelector.getButton().setLayoutData((Object)gd);
        this.axisColorSelector.addListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                AxisConfigPage.this.scaleFontLabel.setForeground(XYGraphMediaFactory.getInstance().getColor(AxisConfigPage.this.axisColorSelector.getColorValue()));
                AxisConfigPage.this.titleFontLabel.setForeground(XYGraphMediaFactory.getInstance().getColor(AxisConfigPage.this.axisColorSelector.getColorValue()));
            }
        });
        this.primaryButton = new Button(composite, 32);
        this.configCheckButton(this.primaryButton, "On Primary Side(Bottom/Left)");
        this.logButton = new Button(composite, 32);
        this.configCheckButton(this.logButton, "Log");
        this.autoScaleButton = new Button(composite, 32);
        this.configCheckButton(this.autoScaleButton, "Auto Scale Enabled");
        this.maxOrAutoScaleLabel = new Label(composite, 0);
        labelGd = new GridData(1, 0x1000000, false, false, 1, 1);
        this.maxOrAutoScaleLabel.setLayoutData((Object)labelGd);
        this.maxOrAutoScaleThrText = new DoubleInputText(composite, 2052);
        gd = new GridData(4, 1, true, false, 2, 1);
        this.maxOrAutoScaleThrText.getText().setLayoutData((Object)gd);
        this.minLabel = new Label(composite, 0);
        this.minLabel.setText("Minimum: ");
        labelGd = new GridData(4, 0x1000000, false, false, 1, 1);
        this.minLabel.setLayoutData((Object)labelGd);
        this.minText = new DoubleInputText(composite, 2052);
        gd = new GridData(4, 1, true, false, 2, 1);
        this.minText.getText().setLayoutData((Object)gd);
        this.autoScaleButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (AxisConfigPage.this.autoScaleButton.getSelection()) {
                    AxisConfigPage.this.maxOrAutoScaleLabel.setText("Auto Scale Threshold(%)");
                    AxisConfigPage.this.maxOrAutoScaleThrText.setRange(new Range(0.0, 100.0));
                    AxisConfigPage.this.maxOrAutoScaleThrText.getText().setText(String.valueOf(AxisConfigPage.this.axis.getAutoScaleThreshold()));
                    AxisConfigPage.this.minLabel.setVisible(false);
                    AxisConfigPage.this.minText.getText().setVisible(false);
                } else {
                    AxisConfigPage.this.maxOrAutoScaleLabel.setText("Maximum");
                    AxisConfigPage.this.maxOrAutoScaleThrText.setRange(null);
                    AxisConfigPage.this.maxOrAutoScaleThrText.getText().setText(String.valueOf(AxisConfigPage.this.axis.getRange().getUpper()));
                    AxisConfigPage.this.minLabel.setVisible(true);
                    AxisConfigPage.this.minText.getText().setVisible(true);
                }
                composite.getShell().layout(true, true);
            }
        });
        this.dateEnabledButton = new Button(composite, 32);
        this.configCheckButton(this.dateEnabledButton, "Time Format Enabled");
        this.autoFormat = new Button(composite, 32);
        this.configCheckButton(this.autoFormat, "Auto Format");
        this.formatLabel = new Label(composite, 0);
        labelGd = new GridData(4, 0x1000000, false, false, 1, 1);
        this.formatLabel.setLayoutData((Object)labelGd);
        this.formatText = new Text(composite, 2050);
        gd = new GridData(4, 4, true, true, 2, 2);
        gd.minimumHeight = 40;
        this.formatText.setLayoutData((Object)gd);
        this.dateEnabledButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean saveDateEnabled = AxisConfigPage.this.axis.isDateEnabled();
                boolean saveAutoFormat = AxisConfigPage.this.axis.isAutoFormat();
                AxisConfigPage.this.axis.setDateEnabled(AxisConfigPage.this.dateEnabledButton.getSelection());
                AxisConfigPage.this.axis.setAutoFormat(true);
                AxisConfigPage.this.formatLabel.setText(AxisConfigPage.this.dateEnabledButton.getSelection() ? "Time Format: " : "Numeric Format: ");
                AxisConfigPage.this.formatText.setText(AxisConfigPage.this.axis.getFormatPattern());
                AxisConfigPage.this.axis.setDateEnabled(saveDateEnabled);
                AxisConfigPage.this.axis.setAutoFormat(saveAutoFormat);
                composite.getShell().layout(true, true);
            }
        });
        this.autoFormat.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AxisConfigPage.this.formatText.setEnabled(!AxisConfigPage.this.autoFormat.getSelection());
                if (AxisConfigPage.this.autoFormat.getSelection()) {
                    boolean saveDateEnabled = AxisConfigPage.this.axis.isDateEnabled();
                    boolean saveAutoFormat = AxisConfigPage.this.axis.isAutoFormat();
                    AxisConfigPage.this.axis.setDateEnabled(AxisConfigPage.this.dateEnabledButton.getSelection());
                    AxisConfigPage.this.axis.setAutoFormat(AxisConfigPage.this.autoFormat.getSelection());
                    AxisConfigPage.this.formatText.setText(AxisConfigPage.this.axis.getFormatPattern());
                    AxisConfigPage.this.axis.setDateEnabled(saveDateEnabled);
                    AxisConfigPage.this.axis.setAutoFormat(saveAutoFormat);
                }
            }
        });
        this.showGridButton = new Button(composite, 32);
        this.configCheckButton(this.showGridButton, "Show Grid Line");
        this.dashGridLineButton = new Button(composite, 32);
        this.configCheckButton(this.dashGridLineButton, "Dash Grid Line");
        Label gridColorLabel = new Label(composite, 0);
        gridColorLabel.setText("Grid Color");
        labelGd = new GridData(4, 0x1000000, false, false, 1, 1);
        gridColorLabel.setLayoutData((Object)labelGd);
        this.gridColorSelector = new ColorSelector(composite);
        gd = new GridData(1, 0x1000000, false, false, 1, 1);
        this.gridColorSelector.getButton().setLayoutData((Object)gd);
        this.initialize();
    }

    private void configCheckButton(Button button, String text) {
        button.setText(text);
        button.setLayoutData((Object)new GridData(1, 1, false, false, 3, 2));
    }

    public Composite getComposite() {
        return this.composite;
    }

    public void applyChanges() {
        this.axis.setTitle(this.titleText.getText());
        this.axis.setFont(this.scaleFont);
        this.axis.setTitleFont(this.titleFont);
        this.axis.setForegroundColor(XYGraphMediaFactory.getInstance().getColor(this.axisColorSelector.getColorValue()));
        this.axis.setPrimarySide(this.primaryButton.getSelection());
        this.axis.setLogScale(this.logButton.getSelection());
        this.axis.setAutoScale(this.autoScaleButton.getSelection());
        if (this.autoScaleButton.getSelection()) {
            this.axis.setAutoScaleThreshold(this.maxOrAutoScaleThrText.getDoubleValue());
        } else {
            this.axis.setRange(this.minText.getDoubleValue(), this.maxOrAutoScaleThrText.getDoubleValue());
        }
        this.axis.setDateEnabled(this.dateEnabledButton.getSelection());
        this.axis.setAutoFormat(this.autoFormat.getSelection());
        if (!this.autoFormat.getSelection()) {
            String saveFormat = this.axis.getFormatPattern();
            this.axis.setFormatPattern(this.formatText.getText());
            try {
                this.axis.format(0);
            }
            catch (Exception e) {
                this.axis.setFormatPattern(saveFormat);
                MessageBox mb = new MessageBox(Display.getCurrent().getActiveShell(), 33);
                mb.setMessage("Failed to set format due to incorrect format pattern: " + e.getMessage());
                mb.setText("Format pattern error!");
                mb.open();
            }
        }
        this.axis.setShowMajorGrid(this.showGridButton.getSelection());
        this.axis.setDashGridLine(this.dashGridLineButton.getSelection());
        this.axis.setMajorGridColor(XYGraphMediaFactory.getInstance().getColor(this.gridColorSelector.getColorValue()));
    }

    private void initialize() {
        this.titleText.setText(this.axis.getTitle());
        this.scaleFontLabel.setForeground(this.axis.getForegroundColor());
        this.scaleFontLabel.setFont(this.scaleFont);
        this.scaleFontLabel.setText("Scale Font: " + this.scaleFont.getFontData()[0].getName());
        this.titleFontLabel.setForeground(this.axis.getForegroundColor());
        this.titleFontLabel.setFont(this.titleFont);
        this.titleFontLabel.setText("Title Font: " + this.titleFont.getFontData()[0].getName());
        this.axisColorSelector.setColorValue(this.axis.getForegroundColor().getRGB());
        this.primaryButton.setSelection(this.axis.isOnPrimarySide());
        if (this.axis == this.xyGraph.getPrimaryXAxis() || this.axis == this.xyGraph.getPrimaryYAxis()) {
            this.primaryButton.setEnabled(false);
        }
        this.logButton.setSelection(this.axis.isLogScaleEnabled());
        this.autoScaleButton.setSelection(this.axis.isAutoScale());
        if (this.autoScaleButton.getSelection()) {
            this.maxOrAutoScaleLabel.setText("Auto Scale Threshold(%)");
            this.maxOrAutoScaleThrText.setRange(new Range(0.0, 100.0));
            this.maxOrAutoScaleThrText.getText().setText(String.valueOf(this.axis.getAutoScaleThreshold()));
            this.minLabel.setVisible(false);
            this.minText.getText().setVisible(false);
        } else {
            this.maxOrAutoScaleLabel.setText("Maximum");
            this.maxOrAutoScaleThrText.setRange(null);
            this.maxOrAutoScaleThrText.getText().setText(String.valueOf(this.axis.getRange().getUpper()));
            this.minLabel.setVisible(true);
            this.minText.getText().setVisible(true);
        }
        this.minText.getText().setText(String.valueOf(this.axis.getRange().getLower()));
        this.dateEnabledButton.setSelection(this.axis.isDateEnabled());
        this.autoFormat.setSelection(this.axis.isAutoFormat());
        this.formatLabel.setText(this.dateEnabledButton.getSelection() ? "Time Format: " : "Numeric Format: ");
        this.formatText.setText(this.axis.getFormatPattern());
        this.formatText.setEnabled(!this.autoFormat.getSelection());
        this.showGridButton.setSelection(this.axis.isShowMajorGrid());
        this.dashGridLineButton.setSelection(this.axis.isDashGridLine());
        this.gridColorSelector.setColorValue(this.axis.getMajorGridColor().getRGB());
    }
}

