/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.identifier.chromatogram;

import org.eclipse.chemclipse.chromatogram.msd.identifier.chromatogram.ChromatogramIdentifierSupplier;
import org.eclipse.chemclipse.chromatogram.msd.identifier.chromatogram.ChromatogramIdentifierSupport;
import org.eclipse.chemclipse.chromatogram.msd.identifier.chromatogram.IChromatogramIdentifier;
import org.eclipse.chemclipse.chromatogram.msd.identifier.chromatogram.IChromatogramIdentifierSupport;
import org.eclipse.chemclipse.chromatogram.msd.identifier.processing.ChromatogramIdentifierProcessingInfo;
import org.eclipse.chemclipse.chromatogram.msd.identifier.processing.IChromatogramIdentifierProcessingInfo;
import org.eclipse.chemclipse.chromatogram.msd.identifier.settings.IChromatogramIdentifierSettings;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.processing.core.IProcessingMessage;
import org.eclipse.chemclipse.processing.core.MessageType;
import org.eclipse.chemclipse.processing.core.ProcessingMessage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;

public class ChromatogramIdentifier {
    private static final Logger logger = Logger.getLogger(ChromatogramIdentifier.class);
    private static final String EXTENSION_POINT = "org.eclipse.chemclipse.chromatogram.msd.identifier.chromatogramIdentifier";
    private static final String NO_IDENTIFIER_AVAILABLE = "There is no suitable chromatogram identifier available";

    private ChromatogramIdentifier() {
    }

    public static IChromatogramIdentifierProcessingInfo identify(IChromatogramSelectionMSD chromatogramSelection, IChromatogramIdentifierSettings identifierSettings, String identifierId, IProgressMonitor monitor) {
        IChromatogramIdentifier chromatogramIdentifier = ChromatogramIdentifier.getChromatogramIdentifier(identifierId);
        IChromatogramIdentifierProcessingInfo processingInfo = chromatogramIdentifier != null ? chromatogramIdentifier.identify(chromatogramSelection, identifierSettings, monitor) : ChromatogramIdentifier.getNoIdentifierAvailableProcessingInfo();
        return processingInfo;
    }

    public static IChromatogramIdentifierProcessingInfo identify(IChromatogramSelectionMSD chromatogramSelection, String identifierId, IProgressMonitor monitor) {
        IChromatogramIdentifier chromatogramIdentifier = ChromatogramIdentifier.getChromatogramIdentifier(identifierId);
        IChromatogramIdentifierProcessingInfo processingInfo = chromatogramIdentifier != null ? chromatogramIdentifier.identify(chromatogramSelection, monitor) : ChromatogramIdentifier.getNoIdentifierAvailableProcessingInfo();
        return processingInfo;
    }

    public static IChromatogramIdentifierSupport getChromatogramIdentifierSupport() {
        IConfigurationElement[] extensions;
        ChromatogramIdentifierSupport identifierSupport = new ChromatogramIdentifierSupport();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = extensions = registry.getConfigurationElementsFor(EXTENSION_POINT);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            ChromatogramIdentifierSupplier supplier = new ChromatogramIdentifierSupplier();
            supplier.setId(element.getAttribute("id"));
            supplier.setDescription(element.getAttribute("description"));
            supplier.setIdentifierName(element.getAttribute("identifierName"));
            identifierSupport.add(supplier);
            ++n2;
        }
        return identifierSupport;
    }

    private static IChromatogramIdentifier getChromatogramIdentifier(String identifierId) {
        IConfigurationElement element = ChromatogramIdentifier.getConfigurationElement(identifierId);
        IChromatogramIdentifier instance = null;
        if (element != null) {
            try {
                instance = (IChromatogramIdentifier)element.createExecutableExtension("identifier");
            }
            catch (CoreException e) {
                logger.warn((Object)e);
            }
        }
        return instance;
    }

    private static IConfigurationElement getConfigurationElement(String filterId) {
        IConfigurationElement[] elements;
        if ("".equals(filterId)) {
            return null;
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor(EXTENSION_POINT);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getAttribute("id").equals(filterId)) {
                return element;
            }
            ++n2;
        }
        return null;
    }

    private static IChromatogramIdentifierProcessingInfo getNoIdentifierAvailableProcessingInfo() {
        ChromatogramIdentifierProcessingInfo processingInfo = new ChromatogramIdentifierProcessingInfo();
        ProcessingMessage processingMessage = new ProcessingMessage(MessageType.ERROR, "Chromatogram Identifier", NO_IDENTIFIER_AVAILABLE);
        processingInfo.addMessage((IProcessingMessage)processingMessage);
        return processingInfo;
    }
}

