/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.msd.ui.views;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.chemclipse.msd.model.core.IChromatogramPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.swt.ui.components.peak.ExtendedPeakUI;
import org.eclipse.chemclipse.swt.ui.support.AxisTitlesMassScale;
import org.eclipse.chemclipse.swt.ui.support.IAxisTitles;
import org.eclipse.chemclipse.ux.extension.msd.ui.views.AbstractPeakMSDSelectionView;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class PeakViewMSD
extends AbstractPeakMSDSelectionView {
    @Inject
    private Composite parent;
    private ExtendedPeakUI extendedPeakUI;
    private IEventBroker eventBroker;
    private EventHandler eventHandler;

    @Inject
    public PeakViewMSD(EPartService partService, MPart part, IEventBroker eventBroker) {
        super(part, partService, eventBroker);
        this.eventBroker = eventBroker;
        this.subscribe();
    }

    @PostConstruct
    private void createControl() {
        this.parent.setLayout((Layout)new FillLayout());
        this.extendedPeakUI = new ExtendedPeakUI(this.parent, 0, (IAxisTitles)new AxisTitlesMassScale());
        this.extendedPeakUI.setIncludeBackground(true);
    }

    @PreDestroy
    private void preDestroy() {
        this.unsubscribe();
    }

    @Override
    public void unsubscribe() {
        super.unsubscribe();
    }

    @Focus
    public void setFocus() {
        this.extendedPeakUI.setFocus();
        this.update(this.getPeak(), false);
    }

    @Override
    public void update(IPeakMSD peak, boolean forceReload) {
        if (this.isPartVisible() && peak != null) {
            this.extendedPeakUI.update(peak, forceReload);
        }
    }

    private void subscribe() {
        if (this.eventBroker != null) {
            this.eventHandler = new EventHandler(){

                public void handleEvent(Event event) {
                    IChromatogramSelectionMSD chromatogramSelection = (IChromatogramSelectionMSD)event.getProperty("ChromatogramSelection");
                    boolean forceReload = (Boolean)event.getProperty("ForceReload");
                    if (chromatogramSelection != null) {
                        IChromatogramPeakMSD peak = chromatogramSelection.getSelectedPeak();
                        PeakViewMSD.this.setPeak((IPeakMSD)peak);
                        PeakViewMSD.this.update((IPeakMSD)peak, forceReload);
                    }
                }
            };
            this.eventBroker.subscribe("chromatogram/msd/update/chromatogramselection", this.eventHandler);
        }
    }
}

