/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.msd.ui.views;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.swt.ui.components.massspectrum.MassSpectrumCycleNumberIonsListUI;
import org.eclipse.chemclipse.support.ui.swt.ExtendedTableViewer;
import org.eclipse.chemclipse.ux.extension.msd.ui.views.AbstractChromatogramSelectionMSDView;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;

public class MassSpectrumCycleNumberIonsListView
extends AbstractChromatogramSelectionMSDView {
    private static final String POPUP_MENU_ID = "org.eclipse.chemclipse.chromatogram.msd.ui.perspective.views.massSpectrumCycleNumberIonsListView.popup";
    @Inject
    private Composite parent;
    private MassSpectrumCycleNumberIonsListUI massSpectrumCycleNumberIonsListUI;

    @Inject
    public MassSpectrumCycleNumberIonsListView(EPartService partService, MPart part, IEventBroker eventBroker) {
        super(part, partService, eventBroker);
    }

    @PostConstruct
    private void createControl() {
        this.parent.setLayout((Layout)new FillLayout());
        this.massSpectrumCycleNumberIonsListUI = new MassSpectrumCycleNumberIonsListUI(this.parent, 0);
        final ExtendedTableViewer tableViewer = this.massSpectrumCycleNumberIonsListUI.getTableViewer();
        tableViewer.getTable().addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 99 && e.stateMask == 262144) {
                    tableViewer.copyToClipboard(MassSpectrumCycleNumberIonsListView.this.massSpectrumCycleNumberIonsListUI.getTitles());
                }
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        this.initContextMenu();
    }

    @PreDestroy
    private void preDestroy() {
        this.unsubscribe();
    }

    @Focus
    public void setFocus() {
        this.massSpectrumCycleNumberIonsListUI.getTableViewer().getControl().setFocus();
        this.update(this.getChromatogramSelection(), false);
    }

    @Override
    public void update(IChromatogramSelectionMSD chromatogramSelection, boolean forceReload) {
        if (this.doUpdate((IChromatogramSelection)chromatogramSelection)) {
            this.massSpectrumCycleNumberIonsListUI.update(chromatogramSelection, forceReload);
        }
    }

    private void initContextMenu() {
        MenuManager menuManager = new MenuManager("#PopUpMenu", POPUP_MENU_ID);
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Action action = new Action(){

                    public void run() {
                        super.run();
                        MassSpectrumCycleNumberIonsListView.this.massSpectrumCycleNumberIonsListUI.getTableViewer().copyToClipboard(MassSpectrumCycleNumberIonsListView.this.massSpectrumCycleNumberIonsListUI.getTitles());
                    }
                };
                action.setText("Copy selection to clipboard");
                manager.add((IAction)action);
            }
        });
        ExtendedTableViewer tableViewer = this.massSpectrumCycleNumberIonsListUI.getTableViewer();
        Menu menu = menuManager.createContextMenu((Control)tableViewer.getTable());
        tableViewer.getTable().setMenu(menu);
    }
}

