/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.msd.ui.handlers;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Named;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.IChromatogramPeakMSD;
import org.eclipse.chemclipse.msd.model.core.selection.ChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class DeleteNonQuantifiedPeaksHandler
implements EventHandler {
    private static IChromatogramSelectionMSD chromatogramSelection;

    @Execute
    public void execute(UISynchronize uiSynchronize, @Named(value="activeShell") Shell shell) {
        IChromatogramMSD chromatogram;
        if (chromatogramSelection != null && (chromatogram = chromatogramSelection.getChromatogramMSD()) != null) {
            MessageBox messageBox = new MessageBox(shell, 456);
            messageBox.setText("Delete Non Quantified Peaks");
            messageBox.setMessage("Do you really want to delete all non quantified peaks?");
            int decision = messageBox.open();
            if (64 == decision) {
                this.deleteNonQuantifiedPeaks(chromatogram);
                if (chromatogramSelection instanceof ChromatogramSelectionMSD) {
                    ((ChromatogramSelectionMSD)chromatogramSelection).update(true);
                }
            }
        }
    }

    public void handleEvent(Event event) {
        if (event.getTopic().equals("chromatogram/msd/update/chromatogramselection")) {
            chromatogramSelection = (IChromatogramSelectionMSD)event.getProperty("ChromatogramSelection");
        }
    }

    private void deleteNonQuantifiedPeaks(IChromatogramMSD chromatogram) {
        List peaks = chromatogram.getPeaks();
        ArrayList<IChromatogramPeakMSD> peaksToDelete = new ArrayList<IChromatogramPeakMSD>();
        for (IChromatogramPeakMSD chromatogramPeak : peaks) {
            if (chromatogramPeak.getQuantitationEntries().size() != 0) continue;
            peaksToDelete.add(chromatogramPeak);
        }
        for (IChromatogramPeakMSD peak : peaksToDelete) {
            chromatogram.removePeak(peak);
        }
    }
}

