/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.converter.supplier.svg.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotWriteableException;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.msd.converter.io.AbstractChromatogramMSDWriter;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.core.runtime.IProgressMonitor;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public class ChromatogramWriter
extends AbstractChromatogramMSDWriter {
    private static final int SCALE_INTENSITY = 1000;

    public void writeChromatogram(File file, IChromatogramMSD chromatogram, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotWriteableException, IOException {
        DOMImplementation domImplementation = GenericDOMImplementation.getDOMImplementation();
        String namespaceSVG = "http://www.w3.org/2000/svg";
        Document document = domImplementation.createDocument(namespaceSVG, "svg", null);
        SVGGraphics2D svgGraphics2D = new SVGGraphics2D(document);
        int x1 = 0;
        int y1 = 0;
        int x2 = 0;
        int y2 = 0;
        float maxSignal = chromatogram.getMaxSignal();
        for (IScan scan : chromatogram.getScans()) {
            x2 = (int)((double)scan.getRetentionTime() / 1000.0);
            y2 = 1000 - (int)(1000.0f / maxSignal * scan.getTotalSignal());
            svgGraphics2D.drawLine(x1, y1, x2, y2);
            x1 = x2;
            y1 = y2;
        }
        svgGraphics2D.stream((Writer)new FileWriter(file));
    }
}

