/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.generic;

import java.util.Random;
import org.ejml.data.RealMatrix64F;

public class GenericMatrixOps {
    public static boolean isEquivalent(RealMatrix64F a, RealMatrix64F b, double tol) {
        if (a.getNumRows() != b.getNumRows() || a.getNumCols() != b.getNumCols()) {
            return false;
        }
        int i = 0;
        while (i < a.getNumRows()) {
            int j = 0;
            while (j < a.getNumCols()) {
                double diff = Math.abs(a.get(i, j) - b.get(i, j));
                if (diff > tol) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public static boolean isIdentity(RealMatrix64F a, double tol) {
        int i = 0;
        while (i < a.getNumRows()) {
            int j = 0;
            while (j < a.getNumCols()) {
                if (i == j ? Math.abs(a.get(i, j) - 1.0) > tol : Math.abs(a.get(i, j)) > tol) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public static boolean isEquivalentTriangle(boolean upper, RealMatrix64F a, RealMatrix64F b, double tol) {
        if (a.getNumRows() != b.getNumRows() || a.getNumCols() != b.getNumCols()) {
            return false;
        }
        if (upper) {
            int i = 0;
            while (i < a.getNumRows()) {
                int j = i;
                while (j < a.getNumCols()) {
                    double diff = Math.abs(a.get(i, j) - b.get(i, j));
                    if (diff > tol) {
                        return false;
                    }
                    ++j;
                }
                ++i;
            }
        } else {
            int j = 0;
            while (j < a.getNumCols()) {
                int i = j;
                while (i < a.getNumRows()) {
                    double diff = Math.abs(a.get(i, j) - b.get(i, j));
                    if (diff > tol) {
                        return false;
                    }
                    ++i;
                }
                ++j;
            }
        }
        return true;
    }

    public static void copy(RealMatrix64F from, RealMatrix64F to) {
        int numCols = from.getNumCols();
        int numRows = from.getNumRows();
        int i = 0;
        while (i < numRows) {
            int j = 0;
            while (j < numCols) {
                to.set(i, j, from.get(i, j));
                ++j;
            }
            ++i;
        }
    }

    public static void setRandom(RealMatrix64F a, double min, double max, Random rand) {
        int i = 0;
        while (i < a.getNumRows()) {
            int j = 0;
            while (j < a.getNumCols()) {
                double val = rand.nextDouble() * (max - min) + min;
                a.set(i, j, val);
                ++j;
            }
            ++i;
        }
    }
}

