/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.decompose.qr;

import org.ejml.alg.dense.decompose.qr.QrHelperFunctions_CD64;
import org.ejml.data.CDenseMatrix64F;
import org.ejml.interfaces.decomposition.QRDecomposition;
import org.ejml.ops.CCommonOps;

public class QRDecompositionHouseholder_CD64
implements QRDecomposition<CDenseMatrix64F> {
    protected CDenseMatrix64F QR;
    protected double[] u;
    protected double[] v;
    protected int numCols;
    protected int numRows;
    protected int minLength;
    protected double[] dataQR;
    protected double[] gammas;
    protected double realGamma;
    protected double realTau;
    protected double imagTau;
    protected boolean error;

    public void setExpectedMaxSize(int numRows, int numCols) {
        this.error = false;
        this.numCols = numCols;
        this.numRows = numRows;
        this.minLength = Math.min(numRows, numCols);
        int maxLength = Math.max(numRows, numCols);
        if (this.QR == null) {
            this.QR = new CDenseMatrix64F(numRows, numCols);
            this.u = new double[maxLength * 2];
            this.v = new double[maxLength * 2];
            this.gammas = new double[this.minLength];
        } else {
            this.QR.reshape(numRows, numCols);
        }
        this.dataQR = this.QR.data;
        if (this.u.length < maxLength * 2) {
            this.u = new double[maxLength * 2];
            this.v = new double[maxLength * 2];
        }
        if (this.gammas.length < this.minLength) {
            this.gammas = new double[this.minLength];
        }
    }

    public CDenseMatrix64F getQR() {
        return this.QR;
    }

    @Override
    public CDenseMatrix64F getQ(CDenseMatrix64F Q, boolean compact) {
        if (compact) {
            if (Q == null) {
                Q = CCommonOps.identity(this.numRows, this.minLength);
            } else {
                if (Q.numRows != this.numRows || Q.numCols != this.minLength) {
                    throw new IllegalArgumentException("Unexpected matrix dimension.");
                }
                CCommonOps.setIdentity(Q);
            }
        } else if (Q == null) {
            Q = CCommonOps.identity(this.numRows);
        } else {
            if (Q.numRows != this.numRows || Q.numCols != this.numRows) {
                throw new IllegalArgumentException("Unexpected matrix dimension.");
            }
            CCommonOps.setIdentity(Q);
        }
        int j = this.minLength - 1;
        while (j >= 0) {
            this.u[2 * j] = 1.0;
            this.u[2 * j + 1] = 0.0;
            int i = j + 1;
            while (i < this.numRows) {
                int indexQR = this.QR.getIndex(i, j);
                this.u[i * 2] = this.QR.data[indexQR];
                this.u[i * 2 + 1] = this.QR.data[indexQR + 1];
                ++i;
            }
            QrHelperFunctions_CD64.rank1UpdateMultR(Q, this.u, 0, this.gammas[j], j, j, this.numRows, this.v);
            --j;
        }
        return Q;
    }

    @Override
    public CDenseMatrix64F getR(CDenseMatrix64F R, boolean compact) {
        int i;
        if (R == null) {
            R = compact ? new CDenseMatrix64F(this.minLength, this.numCols) : new CDenseMatrix64F(this.numRows, this.numCols);
        } else {
            if (compact ? R.numCols != this.numCols || R.numRows != this.minLength : R.numCols != this.numCols || R.numRows != this.numRows) {
                throw new IllegalArgumentException("Unexpected dimensions");
            }
            i = 0;
            while (i < R.numRows) {
                int min = Math.min(i, R.numCols);
                int j = 0;
                while (j < min) {
                    R.set(i, j, 0.0, 0.0);
                    ++j;
                }
                ++i;
            }
        }
        i = 0;
        while (i < this.minLength) {
            int j = i;
            while (j < this.numCols) {
                int indexQR = this.QR.getIndex(i, j);
                double realQR = this.QR.data[indexQR];
                double imagQR = this.QR.data[indexQR + 1];
                R.set(i, j, realQR, imagQR);
                ++j;
            }
            ++i;
        }
        return R;
    }

    @Override
    public boolean decompose(CDenseMatrix64F A) {
        this.commonSetup(A);
        int j = 0;
        while (j < this.minLength) {
            this.householder(j);
            this.updateA(j);
            ++j;
        }
        return !this.error;
    }

    @Override
    public boolean inputModified() {
        return false;
    }

    protected void householder(int j) {
        int indexQR = 2 * (j + j * this.numCols);
        int indexU = 2 * j;
        double max = 0.0;
        int i = j;
        while (i < this.numRows) {
            int n = indexU++;
            double d = this.dataQR[indexQR];
            this.u[n] = d;
            double realD = d;
            double d2 = this.u[indexU++] = this.dataQR[indexQR + 1];
            double imagD = d2;
            double magD = realD * realD + imagD * imagD;
            if (max < magD) {
                max = magD;
            }
            indexQR += this.numCols * 2;
            ++i;
        }
        if ((max = Math.sqrt(max)) == 0.0) {
            this.realGamma = 0.0;
            this.error = true;
        } else {
            double bottom;
            double top;
            double nx = 0.0;
            indexU = 2 * j;
            int i2 = j;
            while (i2 < this.numRows) {
                int n = indexU++;
                double d = this.u[n] / max;
                this.u[n] = d;
                double realD = d;
                int n2 = indexU++;
                double d3 = this.u[n2] / max;
                this.u[n2] = d3;
                double imagD = d3;
                nx += realD * realD + imagD * imagD;
                ++i2;
            }
            nx = Math.sqrt(nx);
            double real_x0 = this.u[2 * j];
            double imag_x0 = this.u[2 * j + 1];
            double mag_x0 = Math.sqrt(real_x0 * real_x0 + imag_x0 * imag_x0);
            if (mag_x0 == 0.0) {
                this.realTau = nx;
                this.imagTau = 0.0;
            } else {
                this.realTau = real_x0 / mag_x0 * nx;
                this.imagTau = imag_x0 / mag_x0 * nx;
            }
            if (real_x0 * this.realTau < 0.0) {
                this.realTau = -this.realTau;
                this.imagTau = -this.imagTau;
                top = nx * nx - nx * mag_x0;
                bottom = mag_x0 * mag_x0 - 2.0 * nx * mag_x0 + nx * nx;
            } else {
                top = nx * nx + nx * mag_x0;
                bottom = mag_x0 * mag_x0 + 2.0 * nx * mag_x0 + nx * nx;
            }
            this.realGamma = bottom / top;
            double real_u_0 = real_x0 + this.realTau;
            double imag_u_0 = imag_x0 + this.imagTau;
            double norm_u_0 = real_u_0 * real_u_0 + imag_u_0 * imag_u_0;
            indexU = (j + 1) * 2;
            int i3 = j + 1;
            while (i3 < this.numRows) {
                double realU = this.u[indexU];
                double imagU = this.u[indexU + 1];
                this.u[indexU++] = (realU * real_u_0 + imagU * imag_u_0) / norm_u_0;
                this.u[indexU++] = (imagU * real_u_0 - realU * imag_u_0) / norm_u_0;
                ++i3;
            }
            this.u[2 * j] = 1.0;
            this.u[2 * j + 1] = 0.0;
            this.realTau *= max;
            this.imagTau *= max;
        }
        this.gammas[j] = this.realGamma;
    }

    protected void updateA(int w) {
        int stride = this.numCols * 2;
        double realU = this.u[w * 2];
        double imagU = -this.u[w * 2 + 1];
        int indexQR = w * stride + (w + 1) * 2;
        int i = w + 1;
        while (i < this.numCols) {
            double realQR = this.dataQR[indexQR++];
            double imagQR = this.dataQR[indexQR++];
            this.v[i * 2] = realU * realQR - imagU * imagQR;
            this.v[i * 2 + 1] = realU * imagQR + imagU * realQR;
            ++i;
        }
        int k = w + 1;
        while (k < this.numRows) {
            realU = this.u[k * 2];
            imagU = -this.u[k * 2 + 1];
            indexQR = k * stride + (w + 1) * 2;
            int i2 = w + 1;
            while (i2 < this.numCols) {
                double realQR = this.dataQR[indexQR++];
                double imagQR = this.dataQR[indexQR++];
                int n = i2 * 2;
                this.v[n] = this.v[n] + (realU * realQR - imagU * imagQR);
                int n2 = i2 * 2 + 1;
                this.v[n2] = this.v[n2] + (realU * imagQR + imagU * realQR);
                ++i2;
            }
            ++k;
        }
        i = w + 1;
        while (i < this.numCols) {
            int n = i * 2;
            this.v[n] = this.v[n] * this.realGamma;
            int n3 = i * 2 + 1;
            this.v[n3] = this.v[n3] * this.realGamma;
            ++i;
        }
        i = w;
        while (i < this.numRows) {
            double realI = this.u[i * 2];
            double imagI = this.u[i * 2 + 1];
            indexQR = i * stride + (w + 1) * 2;
            int j = w + 1;
            while (j < this.numCols) {
                double realJ = this.v[j * 2];
                double imagJ = this.v[j * 2 + 1];
                int n = indexQR++;
                this.dataQR[n] = this.dataQR[n] - (realI * realJ - imagI * imagJ);
                int n4 = indexQR++;
                this.dataQR[n4] = this.dataQR[n4] - (realI * imagJ + imagI * realJ);
                ++j;
            }
            ++i;
        }
        if (w < this.numCols) {
            this.dataQR[2 * w + w * stride] = -this.realTau;
            this.dataQR[2 * w + w * stride + 1] = -this.imagTau;
        }
        i = w + 1;
        while (i < this.numRows) {
            this.dataQR[2 * w + i * stride] = this.u[i * 2];
            this.dataQR[2 * w + i * stride + 1] = this.u[i * 2 + 1];
            ++i;
        }
    }

    protected void commonSetup(CDenseMatrix64F A) {
        this.setExpectedMaxSize(A.numRows, A.numCols);
        this.QR.set(A);
    }

    public double[] getGammas() {
        return this.gammas;
    }
}

