/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.integrator.ui.swt;

import org.eclipse.chemclipse.chromatogram.xxd.integrator.result.IPeakIntegrationResults;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.ui.internal.provider.PeakIntegrationResultsContentProvider;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.ui.internal.provider.PeakIntegrationResultsLabelProvider;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.ui.internal.provider.PeakIntegrationResultsTableComparator;
import org.eclipse.chemclipse.support.ui.swt.ExtendedTableViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;

public class PeakIntegrationResultsUI
extends Composite {
    public static final String POPUP_MENU_ID = "org.eclipse.chemclipse.chromatogram.xxd.integrator.ui.swt.peakIntegrationResultsListUI.popup";
    private ExtendedTableViewer tableViewer;
    private PeakIntegrationResultsTableComparator integrationResultTableComparator;
    private String[] titles = new String[]{"Start RT (minutes)", "Stop RT", "Integrated Area", "ion (TIC = 0)"};
    private int[] bounds = new int[]{150, 100, 100, 100};

    public PeakIntegrationResultsUI(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    public void update(IPeakIntegrationResults peakIntegrationResults) {
        this.tableViewer.setInput((Object)peakIntegrationResults);
    }

    private void initialize() {
        this.setLayout((Layout)new FillLayout());
        Composite composite = new Composite((Composite)this, 4);
        GridLayout layout = new GridLayout();
        layout.makeColumnsEqualWidth = true;
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        this.tableViewer = new ExtendedTableViewer(composite, 66306);
        this.tableViewer.createColumns(this.titles, this.bounds);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.tableViewer.getTable().setLayoutData((Object)gridData);
        this.tableViewer.setContentProvider((IContentProvider)new PeakIntegrationResultsContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new PeakIntegrationResultsLabelProvider());
        this.tableViewer.getTable().addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 99 && e.stateMask == 262144) {
                    PeakIntegrationResultsUI.this.tableViewer.copyToClipboard(PeakIntegrationResultsUI.this.titles);
                }
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        this.integrationResultTableComparator = new PeakIntegrationResultsTableComparator();
        this.tableViewer.setComparator((ViewerComparator)this.integrationResultTableComparator);
        this.initContextMenu();
    }

    private void initContextMenu() {
        MenuManager menuManager = new MenuManager("#PopUpMenu", POPUP_MENU_ID);
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Action action = new Action(){

                    public void run() {
                        super.run();
                        PeakIntegrationResultsUI.this.tableViewer.copyToClipboard(PeakIntegrationResultsUI.this.titles);
                    }
                };
                action.setText("Copy selection to clipboard");
                manager.add((IAction)action);
            }
        });
        Menu menu = menuManager.createContextMenu((Control)this.tableViewer.getTable());
        this.tableViewer.getTable().setMenu(menu);
    }
}

