/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.converter.supplier.massbank.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;
import org.eclipse.chemclipse.converter.exceptions.FileIsEmptyException;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotReadableException;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.identifier.ILibraryInformation;
import org.eclipse.chemclipse.msd.converter.io.AbstractMassSpectraReader;
import org.eclipse.chemclipse.msd.converter.io.IMassSpectraReader;
import org.eclipse.chemclipse.msd.converter.supplier.massbank.model.VendorLibraryMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IMassSpectra;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.implementation.Ion;
import org.eclipse.chemclipse.msd.model.implementation.MassSpectra;
import org.eclipse.core.runtime.IProgressMonitor;

public class MassBankReader
extends AbstractMassSpectraReader
implements IMassSpectraReader {
    private static final Logger logger = Logger.getLogger(MassBankReader.class);

    public IMassSpectra read(File file, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotReadableException, FileIsEmptyException, IOException {
        MassSpectra massSpectra = new MassSpectra();
        IScanMSD massSpectrum = this.readMassSpectrum(file, monitor);
        massSpectra.addMassSpectrum(massSpectrum);
        return massSpectra;
    }

    private IScanMSD readMassSpectrum(File file, IProgressMonitor monitor) throws IOException {
        String line;
        VendorLibraryMassSpectrum massSpectrum = new VendorLibraryMassSpectrum();
        Map<String, String> infoMap = massSpectrum.getInfoMap();
        FileReader fileReader = new FileReader(file);
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        boolean readPeakData = false;
        while ((line = bufferedReader.readLine()) != null) {
            String[] values;
            if (line.startsWith("PK$")) {
                readPeakData = true;
            }
            if (readPeakData) {
                if (line.startsWith("PK$")) continue;
                if (line.startsWith("//")) {
                    readPeakData = false;
                    continue;
                }
                values = line.trim().split(" ");
                if (values.length != 3) continue;
                try {
                    double mz = Double.parseDouble(values[0]);
                    float abundance = Float.parseFloat(values[1]);
                    Ion ion = new Ion(mz, abundance);
                    massSpectrum.addIon((IIon)ion);
                }
                catch (Exception e) {
                    logger.warn((Object)e);
                }
                continue;
            }
            values = line.split(": ");
            if (values.length != 2) continue;
            infoMap.put(values[0].trim(), values[1].trim());
        }
        ILibraryInformation libraryInformation = massSpectrum.getLibraryInformation();
        libraryInformation.setComments(infoMap.get("COMMENT"));
        libraryInformation.setFormula(infoMap.get("CH$SMILES"));
        libraryInformation.setName(infoMap.get("CH$NAME"));
        bufferedReader.close();
        return massSpectrum;
    }
}

