/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.support.ui.internal.provider;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class ProjectContentProvider
implements ITreeContentProvider {
    private static final Logger logger = Logger.getLogger(ProjectContentProvider.class);

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object[] getChildren(Object parentElement) {
        Object[] objects = null;
        if (parentElement instanceof IContainer) {
            IContainer container = (IContainer)parentElement;
            List<IFolder> folders = this.getFolders(container);
            return folders.toArray();
        }
        return objects;
    }

    public Object getParent(Object element) {
        if (element instanceof IContainer) {
            return ((IContainer)element).getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        boolean hasChildren = false;
        if (element instanceof IContainer) {
            IContainer container = (IContainer)element;
            List<IFolder> folders = this.getFolders(container);
            hasChildren = folders.size() > 0;
        }
        return hasChildren;
    }

    private List<IFolder> getFolders(IContainer container) {
        ArrayList<IFolder> folders = new ArrayList<IFolder>();
        try {
            IResource[] resources;
            IResource[] iResourceArray = resources = container.members();
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                if (resource instanceof IFolder) {
                    folders.add((IFolder)resource);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            logger.warn((Object)e);
        }
        return folders;
    }
}

