/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.ui.wizards;

import java.util.List;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.impl.RetentionIndexExtractor;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.model.IRetentionIndexEntry;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.ui.swt.ExtendedRetentionIndexTableViewerUI;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.ui.swt.RetentionIndexTableViewerUI;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.ui.wizards.IRetentionIndexWizardElements;
import org.eclipse.chemclipse.csd.model.core.IChromatogramCSD;
import org.eclipse.chemclipse.csd.model.core.IChromatogramPeakCSD;
import org.eclipse.chemclipse.csd.model.core.selection.IChromatogramSelectionCSD;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.support.ui.wizards.AbstractExtendedWizardPage;
import org.eclipse.chemclipse.swt.ui.components.chromatogram.SelectedPeakChromatogramUI;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class PageCalibrationTableCSD
extends AbstractExtendedWizardPage {
    private IRetentionIndexWizardElements wizardElements;
    private Button checkBoxValidateRetentionIndices;
    private SelectedPeakChromatogramUI selectedPeakChromatogramUI;
    private ExtendedRetentionIndexTableViewerUI extendedRetentionIndexTableViewerUI;

    public PageCalibrationTableCSD(IRetentionIndexWizardElements wizardElements) {
        super(PageCalibrationTableCSD.class.getName());
        this.setTitle("Calibration Table");
        this.setDescription("Please verify the calibration table.");
        this.wizardElements = wizardElements;
    }

    public boolean canFinish() {
        return this.wizardElements.isRetentionIndexDataValidated();
    }

    public void setDefaultValues() {
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            IChromatogramSelectionCSD chromatogramSelectionCSD = this.wizardElements.getChromatogramSelectionCSD();
            if (chromatogramSelectionCSD != null && chromatogramSelectionCSD.getChromatogramCSD() != null) {
                IChromatogramCSD chromatogramCSD = chromatogramSelectionCSD.getChromatogramCSD();
                this.selectedPeakChromatogramUI.updateSelection((IChromatogramSelection)chromatogramSelectionCSD, true);
                RetentionIndexExtractor retentionIndexExtractor = new RetentionIndexExtractor();
                List extractedRetentionIndexEntries = retentionIndexExtractor.extract((IChromatogram)chromatogramCSD);
                this.wizardElements.setExtractedRetentionIndexEntries(extractedRetentionIndexEntries);
                this.extendedRetentionIndexTableViewerUI.setInput(extractedRetentionIndexEntries);
            }
            this.validateSelection();
        }
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.createCheckBoxField(composite);
        this.createChromatogramField(composite);
        this.createTableField(composite);
        this.validateSelection();
        this.setControl((Control)composite);
    }

    private void createCheckBoxField(Composite composite) {
        this.checkBoxValidateRetentionIndices = new Button(composite, 32);
        this.checkBoxValidateRetentionIndices.setText("Retention indices are valid.");
        this.checkBoxValidateRetentionIndices.setSelection(false);
        this.checkBoxValidateRetentionIndices.setLayoutData((Object)new GridData(768));
        this.checkBoxValidateRetentionIndices.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PageCalibrationTableCSD.this.wizardElements.setRetentionIndexDataIsValidated(PageCalibrationTableCSD.this.checkBoxValidateRetentionIndices.getSelection());
                PageCalibrationTableCSD.this.validateSelection();
            }
        });
    }

    private void createChromatogramField(Composite composite) {
        Composite parent = new Composite(composite, 0);
        parent.setLayoutData((Object)new GridData(1808));
        parent.setLayout((Layout)new FillLayout());
        this.selectedPeakChromatogramUI = new SelectedPeakChromatogramUI(parent, 2048);
    }

    private void createTableField(Composite composite) {
        this.extendedRetentionIndexTableViewerUI = new ExtendedRetentionIndexTableViewerUI(composite, 0);
        this.extendedRetentionIndexTableViewerUI.setLayoutData(new GridData(1808));
        final RetentionIndexTableViewerUI retentionIndexTableViewerUI = this.extendedRetentionIndexTableViewerUI.getRetentionIndexTableViewerUI();
        retentionIndexTableViewerUI.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index;
                Table table = retentionIndexTableViewerUI.getTable();
                TableItem tableItem = table.getItem(index = table.getSelectionIndex());
                Object object = tableItem.getData();
                if (object instanceof IRetentionIndexEntry) {
                    IChromatogramCSD chromatogramCSD;
                    IChromatogramPeakCSD selectedPeak;
                    IRetentionIndexEntry retentionIndexEntry = (IRetentionIndexEntry)object;
                    int retentionTime = retentionIndexEntry.getRetentionTime();
                    IChromatogramSelectionCSD chromatogramSelectionCSD = PageCalibrationTableCSD.this.wizardElements.getChromatogramSelectionCSD();
                    if (chromatogramSelectionCSD != null && chromatogramSelectionCSD.getChromatogramCSD() != null && (selectedPeak = PageCalibrationTableCSD.this.getSelectedPeak(chromatogramCSD = chromatogramSelectionCSD.getChromatogramCSD(), retentionTime)) != null) {
                        chromatogramSelectionCSD.setSelectedPeak(selectedPeak);
                        PageCalibrationTableCSD.this.selectedPeakChromatogramUI.updateSelection((IChromatogramSelection)chromatogramSelectionCSD, true);
                    }
                }
            }
        });
    }

    private IChromatogramPeakCSD getSelectedPeak(IChromatogramCSD chromatogramCSD, int retentionTime) {
        for (IChromatogramPeakCSD peak : chromatogramCSD.getPeaks()) {
            if (peak.getPeakModel().getRetentionTimeAtPeakMaximum() != retentionTime) continue;
            return peak;
        }
        return null;
    }

    private void validateSelection() {
        String message = null;
        if (!this.checkBoxValidateRetentionIndices.getSelection()) {
            message = "Please verify the data and activate the check box.";
        }
        this.updateStatus(message);
    }
}

