/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.identifier.supplier.file.ui.handlers;

import java.lang.reflect.InvocationTargetException;
import javax.inject.Named;
import org.eclipse.chemclipse.chromatogram.msd.identifier.supplier.file.ui.handlers.IdentifyAllPeaksHandler;
import org.eclipse.chemclipse.chromatogram.msd.identifier.supplier.file.ui.runnables.MassSpectrumIdentifierRunnable;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.progress.core.InfoType;
import org.eclipse.chemclipse.progress.core.StatusLineLogger;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class IdentifySelectedMassSpectrumHandler
implements EventHandler {
    private static final Logger logger = Logger.getLogger(IdentifyAllPeaksHandler.class);
    private static IChromatogramSelectionMSD chromatogramSelection;

    @Execute
    public void execute(@Named(value="e4ActivePart") MPart part) {
        if (chromatogramSelection != null) {
            StatusLineLogger.setInfo((InfoType)InfoType.MESSAGE, (String)"Start the mass spectrum identification.");
            ProgressMonitorDialog monitor = new ProgressMonitorDialog(Display.getCurrent().getActiveShell());
            try {
                monitor.run(true, true, (IRunnableWithProgress)new MassSpectrumIdentifierRunnable(chromatogramSelection));
            }
            catch (InvocationTargetException e) {
                logger.warn((Object)e);
            }
            catch (InterruptedException e) {
                logger.warn((Object)e);
            }
            StatusLineLogger.setInfo((InfoType)InfoType.MESSAGE, (String)"Done: Mass spectrum identified");
        }
    }

    public void handleEvent(Event event) {
        if (event.getTopic().equals("chromatogram/msd/update/chromatogramselection")) {
            chromatogramSelection = (IChromatogramSelectionMSD)event.getProperty("ChromatogramSelection");
        }
    }
}

