/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.csd.ui.views;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.chemclipse.csd.model.core.IChromatogramPeakCSD;
import org.eclipse.chemclipse.csd.model.core.IPeakCSD;
import org.eclipse.chemclipse.csd.model.core.selection.IChromatogramSelectionCSD;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.swt.ui.components.peaks.PeakInternalStandardsEditListUI;
import org.eclipse.chemclipse.ux.extension.csd.ui.views.AbstractPeakCSDSelectionView;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class PeakInternalStandardListView
extends AbstractPeakCSDSelectionView {
    @Inject
    private Composite parent;
    private PeakInternalStandardsEditListUI peakInternalStandardsEditListUI;
    private IEventBroker eventBroker;
    private EventHandler eventHandler;

    @Inject
    public PeakInternalStandardListView(EPartService partService, MPart part, IEventBroker eventBroker) {
        super(part, partService, eventBroker);
        this.eventBroker = eventBroker;
        this.subscribe();
    }

    @PostConstruct
    private void createControl() {
        this.parent.setLayout((Layout)new FillLayout());
        this.peakInternalStandardsEditListUI = new PeakInternalStandardsEditListUI(this.parent, 0);
    }

    @PreDestroy
    private void preDestroy() {
        this.unsubscribe();
    }

    @Focus
    public void setFocus() {
        this.peakInternalStandardsEditListUI.setFocus();
        this.update(this.getPeak(), false);
    }

    @Override
    public void update(IPeakCSD peak, boolean forceReload) {
        if (this.isPartVisible() && peak != null) {
            this.peakInternalStandardsEditListUI.update((IPeak)peak, forceReload);
        }
    }

    private void subscribe() {
        if (this.eventBroker != null) {
            this.eventHandler = new EventHandler(){

                public void handleEvent(Event event) {
                    IChromatogramSelectionCSD chromatogramSelection = (IChromatogramSelectionCSD)event.getProperty("ChromatogramSelection");
                    boolean forceReload = (Boolean)event.getProperty("ForceReload");
                    if (chromatogramSelection != null) {
                        IChromatogramPeakCSD peak = chromatogramSelection.getSelectedPeak();
                        PeakInternalStandardListView.this.setPeak((IPeakCSD)peak);
                        PeakInternalStandardListView.this.update((IPeakCSD)peak, forceReload);
                    }
                }
            };
            this.eventBroker.subscribe("chromatogram/csd/update/chromatogramselection", this.eventHandler);
        }
    }
}

