/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.integrator.supplier.peakmax.internal.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.chemclipse.chromatogram.msd.integrator.supplier.peakmax.internal.core.IPeakMaxPeakIntegrator;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.settings.IBaselineSupport;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.settings.IIntegrationSettings;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.settings.peaks.IPeakIntegrationSettings;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.settings.peaks.ISettingStatus;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.exceptions.ValueMustNotBeNullException;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.result.IPeakIntegrationResult;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.result.IPeakIntegrationResults;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.result.PeakIntegrationResult;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.result.PeakIntegrationResults;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.msd.model.core.IChromatogramPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IIntegrationEntryMSD;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IPeakMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IPeakModelMSD;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.core.support.IMarkedIons;
import org.eclipse.chemclipse.msd.model.core.support.IonPercentages;
import org.eclipse.chemclipse.msd.model.implementation.IntegrationEntryMSD;
import org.eclipse.core.runtime.IProgressMonitor;

public class PeakMaxPeakIntegrator
implements IPeakMaxPeakIntegrator {
    @Override
    public IPeakIntegrationResult integrate(IPeakMSD peak, IPeakIntegrationSettings peakIntegrationSettings, IProgressMonitor monitor) throws ValueMustNotBeNullException {
        this.validatePeak(peak);
        this.validateSettings((IIntegrationSettings)peakIntegrationSettings);
        PeakIntegrationResult result = null;
        IBaselineSupport baselineSupport = peakIntegrationSettings.getBaselineSupport();
        List<IIntegrationEntryMSD> integrationEntries = this.calculateIntegratedArea(peak, baselineSupport, peakIntegrationSettings.getSelectedIons());
        this.addPeakAreaAndDescription(peak, peakIntegrationSettings, integrationEntries);
        ISettingStatus settingStatus = peakIntegrationSettings.getSettingStatus((IPeak)peak);
        if (settingStatus.report()) {
            double integratedArea = this.calculateIntegratedArea(integrationEntries);
            result = this.getPeakIntegrationResult(peak, integratedArea, peakIntegrationSettings);
        }
        return result;
    }

    @Override
    public IPeakIntegrationResults integrate(List<IPeakMSD> peaks, IPeakIntegrationSettings peakIntegrationSettings, IProgressMonitor monitor) throws ValueMustNotBeNullException {
        this.validatePeakList(peaks);
        this.validateSettings((IIntegrationSettings)peakIntegrationSettings);
        IPeakIntegrationResult peakIntegrationSumResult = null;
        PeakIntegrationResults peakIntegrationResults = new PeakIntegrationResults();
        int peakNumber = 1;
        for (IPeakMSD peak : peaks) {
            IPeakIntegrationResult peakIntegrationResult;
            monitor.subTask("Integrate Peak " + peakNumber++);
            try {
                peakIntegrationResult = this.integrate(peak, peakIntegrationSettings, monitor);
            }
            catch (ValueMustNotBeNullException valueMustNotBeNullException) {
                continue;
            }
            ISettingStatus settingStatus = peakIntegrationSettings.getSettingStatus((IPeak)peak);
            if (!settingStatus.report()) continue;
            if (settingStatus.sumOn()) {
                if (peakIntegrationSumResult == null) {
                    peakIntegrationSumResult = peakIntegrationResult;
                    this.resetIntegrationSumResultValues(peakIntegrationSumResult);
                    continue;
                }
                peakIntegrationSumResult.setStopRetentionTime(peakIntegrationResult.getStopRetentionTime());
                double integratedArea = peakIntegrationSumResult.getIntegratedArea() + peakIntegrationResult.getIntegratedArea();
                peakIntegrationSumResult.setIntegratedArea(integratedArea);
                continue;
            }
            if (peakIntegrationSumResult != null) {
                peakIntegrationResults.add(peakIntegrationSumResult);
                peakIntegrationSumResult = null;
            }
            peakIntegrationResults.add(peakIntegrationResult);
        }
        if (peakIntegrationSumResult != null) {
            peakIntegrationResults.add(peakIntegrationSumResult);
            peakIntegrationSumResult = null;
        }
        return peakIntegrationResults;
    }

    private void validatePeakList(List<IPeakMSD> peaks) throws ValueMustNotBeNullException {
        if (peaks == null) {
            throw new ValueMustNotBeNullException("The peak list must not be null.");
        }
    }

    private void validatePeak(IPeakMSD peak) throws ValueMustNotBeNullException {
        if (peak == null) {
            throw new ValueMustNotBeNullException("The peak instance must not be null.");
        }
        if (peak.getPeakModel() == null) {
            throw new ValueMustNotBeNullException("The peak model must not be null.");
        }
    }

    private void validateSettings(IIntegrationSettings integrationSettings) throws ValueMustNotBeNullException {
        if (integrationSettings == null) {
            throw new ValueMustNotBeNullException("The integration settings must not be null.");
        }
    }

    private void addPeakAreaAndDescription(IPeakMSD peak, IPeakIntegrationSettings peakIntegrationSettings, List<IIntegrationEntryMSD> integrationEntries) {
        IMarkedIons selectedIons = peakIntegrationSettings.getSelectedIons();
        Set selectedIonsNominal = selectedIons.getIonsNominal();
        StringBuilder builder = new StringBuilder();
        if (selectedIonsNominal.size() > 0 && !selectedIonsNominal.contains(0.0)) {
            builder.append("PeakMax Integrator");
            builder.append(":");
            builder.append(" ");
            builder.append("XIC =");
            ArrayList<Integer> integratedIons = new ArrayList<Integer>(this.getIntegratedIons(selectedIons));
            Collections.sort(integratedIons);
            for (Integer ion : integratedIons) {
                builder.append(" ");
                builder.append(ion);
            }
        } else {
            builder.append("PeakMax Integrator");
            builder.append(":");
            builder.append(" ");
            builder.append("TIC");
        }
        String integratorDescription = builder.toString();
        peak.setIntegratedArea(integrationEntries, integratorDescription);
    }

    private List<IIntegrationEntryMSD> calculateIntegratedArea(IPeakMSD peak, IBaselineSupport baselineSupport, IMarkedIons selectedIons) {
        ArrayList<IIntegrationEntryMSD> integrationEntries = new ArrayList<IIntegrationEntryMSD>();
        IPeakModelMSD peakModel = peak.getPeakModel();
        IPeakMassSpectrum massSpectrum = peakModel.getPeakMassSpectrum();
        double integratedAreaTIC = this.calculateTICPeakArea(peak, baselineSupport);
        Set selectedIonsNominal = selectedIons.getIonsNominal();
        if (selectedIonsNominal.size() > 0 && !selectedIonsNominal.contains(0.0)) {
            IonPercentages ionPercentages = new IonPercentages((IScanMSD)massSpectrum);
            for (Integer ion : selectedIonsNominal) {
                float correctionFactor = ionPercentages.getPercentage(ion.intValue()) / 100.0f;
                double integratedArea = integratedAreaTIC * (double)correctionFactor;
                IntegrationEntryMSD integrationEntry = new IntegrationEntryMSD((double)ion.intValue(), integratedArea);
                integrationEntries.add((IIntegrationEntryMSD)integrationEntry);
            }
        } else {
            IntegrationEntryMSD integrationEntry = new IntegrationEntryMSD(0.0, integratedAreaTIC);
            integrationEntries.add((IIntegrationEntryMSD)integrationEntry);
        }
        return integrationEntries;
    }

    private double calculateTICPeakArea(IPeakMSD peak, IBaselineSupport baselineSupport) {
        double integratedArea = 0.0;
        IPeakModelMSD peakModel = peak.getPeakModel();
        integratedArea = peakModel.getPeakMassSpectrum().getTotalSignal();
        if (integratedArea < 1.0) {
            integratedArea = 0.0;
        }
        return integratedArea;
    }

    private PeakIntegrationResult getPeakIntegrationResult(IPeakMSD peak, double integratedArea, IPeakIntegrationSettings peakIntegrationSettings) {
        IMarkedIons selectedIons = peakIntegrationSettings.getSelectedIons();
        Set<Integer> integratedIons = this.getIntegratedIons(selectedIons);
        PeakIntegrationResult result = new PeakIntegrationResult();
        result.setIntegratedArea(integratedArea);
        result.setIntegratorType("PeakMax Integrator");
        result.setPeakType(peak.getPeakType().toString());
        if (peak instanceof IChromatogramPeakMSD) {
            IChromatogramPeakMSD chromatogramPeak = (IChromatogramPeakMSD)peak;
            result.setPurity(chromatogramPeak.getPurity());
            result.setSN(chromatogramPeak.getSignalToNoiseRatio());
        }
        result.setStartRetentionTime(peak.getPeakModel().getStartRetentionTime());
        result.setStopRetentionTime(peak.getPeakModel().getStopRetentionTime());
        result.setTailing(peak.getPeakModel().getTailing());
        result.setWidth(peak.getPeakModel().getWidthByInflectionPoints());
        result.addIntegratedIons(integratedIons);
        return result;
    }

    private double calculateIntegratedArea(List<IIntegrationEntryMSD> integrationEntries) {
        double result = 0.0;
        for (IIntegrationEntryMSD integrationEntry : integrationEntries) {
            result += integrationEntry.getIntegratedArea();
        }
        return result;
    }

    private void resetIntegrationSumResultValues(IPeakIntegrationResult peakIntegrationSumResult) {
        peakIntegrationSumResult.setPeakType("Summed integrated area");
        peakIntegrationSumResult.setPurity(0.0f);
        peakIntegrationSumResult.setSN(0.0f);
        peakIntegrationSumResult.setTailing(0.0f);
        peakIntegrationSumResult.setWidth(0);
    }

    private Set<Integer> getIntegratedIons(IMarkedIons selectedIons) {
        HashSet<Integer> result = selectedIons == null ? new HashSet<Integer>() : selectedIons.getIonsNominal();
        return result;
    }
}

