/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.filter.supplier.backfolding.core;

import org.eclipse.chemclipse.chromatogram.filter.processing.ChromatogramFilterProcessingInfo;
import org.eclipse.chemclipse.chromatogram.filter.processing.IChromatogramFilterProcessingInfo;
import org.eclipse.chemclipse.chromatogram.filter.result.ChromatogramFilterResult;
import org.eclipse.chemclipse.chromatogram.filter.result.IChromatogramFilterResult;
import org.eclipse.chemclipse.chromatogram.filter.result.ResultStatus;
import org.eclipse.chemclipse.chromatogram.filter.settings.IChromatogramFilterSettings;
import org.eclipse.chemclipse.chromatogram.msd.filter.core.chromatogram.AbstractChromatogramFilterMSD;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.backfolding.detector.BackfoldingShifter;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.backfolding.exceptions.FilterException;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.backfolding.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.backfolding.settings.IBackfoldingSettings;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.backfolding.settings.ISupplierFilterSettings;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.core.IVendorMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.model.xic.IExtractedIonSignals;
import org.eclipse.core.runtime.IProgressMonitor;

public class ChromatogramFilter
extends AbstractChromatogramFilterMSD {
    private IBackfoldingSettings backfoldingSettings = null;

    public IChromatogramFilterProcessingInfo applyFilter(IChromatogramSelectionMSD chromatogramSelection, IChromatogramFilterSettings chromatogramFilterSettings, IProgressMonitor monitor) {
        ChromatogramFilterResult chromatogramFilterResult;
        ChromatogramFilterProcessingInfo processingInfo = new ChromatogramFilterProcessingInfo();
        processingInfo.addMessages(this.validate(chromatogramSelection, chromatogramFilterSettings));
        if (processingInfo.hasErrorMessages()) {
            return processingInfo;
        }
        this.setFilterSettings(chromatogramFilterSettings);
        try {
            this.applyBackfoldingFilter(chromatogramSelection, monitor);
            chromatogramFilterResult = new ChromatogramFilterResult(ResultStatus.OK, "The chromatogram selection has been successfully backfolded.");
        }
        catch (FilterException e) {
            chromatogramFilterResult = new ChromatogramFilterResult(ResultStatus.EXCEPTION, e.getMessage());
        }
        processingInfo.setChromatogramFilterResult((IChromatogramFilterResult)chromatogramFilterResult);
        return processingInfo;
    }

    public IChromatogramFilterProcessingInfo applyFilter(IChromatogramSelectionMSD chromatogramSelection, IProgressMonitor monitor) {
        IChromatogramFilterSettings chromatogramFilterSettings = PreferenceSupplier.getChromatogramFilterSettings();
        return this.applyFilter(chromatogramSelection, chromatogramFilterSettings, monitor);
    }

    private void setFilterSettings(IChromatogramFilterSettings chromatogramFilterSettings) {
        if (chromatogramFilterSettings instanceof ISupplierFilterSettings) {
            ISupplierFilterSettings settings = (ISupplierFilterSettings)chromatogramFilterSettings;
            this.backfoldingSettings = settings.getBackfoldingSettings();
        }
    }

    private void applyBackfoldingFilter(IChromatogramSelectionMSD chromatogramSelection, IProgressMonitor monitor) throws FilterException {
        IChromatogramMSD chromatogram = chromatogramSelection.getChromatogramMSD();
        BackfoldingShifter backfoldingShifter = new BackfoldingShifter();
        IExtractedIonSignals extractedIonSignals = backfoldingShifter.shiftIons(chromatogramSelection, this.backfoldingSettings, monitor);
        int startScan = extractedIonSignals.getStartScan();
        int stopScan = extractedIonSignals.getStopScan();
        int scan = startScan;
        while (scan <= stopScan) {
            IScanMSD massSpectrum = extractedIonSignals.getScan(scan);
            IVendorMassSpectrum supplierMassSpectrum = chromatogram.getSupplierScan(scan);
            supplierMassSpectrum.removeAllIons();
            for (IIon ion : massSpectrum.getIons()) {
                supplierMassSpectrum.addIon(ion);
            }
            ++scan;
        }
    }
}

