/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.classifier.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.msd.classifier.core.IChromatogramClassifierSupplier;
import org.eclipse.chemclipse.chromatogram.msd.classifier.core.IChromatogramClassifierSupport;
import org.eclipse.chemclipse.chromatogram.msd.classifier.exceptions.NoChromatogramClassifierSupplierAvailableException;

public class ChromatogramClassifierSupport
implements IChromatogramClassifierSupport {
    private List<IChromatogramClassifierSupplier> suppliers = new ArrayList<IChromatogramClassifierSupplier>();

    protected void add(IChromatogramClassifierSupplier supplier) {
        this.suppliers.add(supplier);
    }

    @Override
    public List<String> getAvailableClassifierIds() throws NoChromatogramClassifierSupplierAvailableException {
        this.areChromatogramClassifiersStored();
        ArrayList<String> availableClassifiers = new ArrayList<String>();
        for (IChromatogramClassifierSupplier supplier : this.suppliers) {
            availableClassifiers.add(supplier.getId());
        }
        return availableClassifiers;
    }

    @Override
    public String getClassifierId(int index) throws NoChromatogramClassifierSupplierAvailableException {
        this.areChromatogramClassifiersStored();
        if (index < 0 || index > this.suppliers.size() - 1) {
            throw new NoChromatogramClassifierSupplierAvailableException("There is no chromatogram classifier available with the following id: " + index + ".");
        }
        IChromatogramClassifierSupplier supplier = this.suppliers.get(index);
        return supplier.getId();
    }

    @Override
    public String[] getClassifierNames() throws NoChromatogramClassifierSupplierAvailableException {
        this.areChromatogramClassifiersStored();
        ArrayList<String> classifierNames = new ArrayList<String>();
        for (IChromatogramClassifierSupplier supplier : this.suppliers) {
            classifierNames.add(supplier.getClassifierName());
        }
        return classifierNames.toArray(new String[classifierNames.size()]);
    }

    @Override
    public IChromatogramClassifierSupplier getClassifierSupplier(String classifierId) throws NoChromatogramClassifierSupplierAvailableException {
        IChromatogramClassifierSupplier classifierSupplier = null;
        this.areChromatogramClassifiersStored();
        if (classifierId == null || classifierId.equals("")) {
            throw new NoChromatogramClassifierSupplierAvailableException("There is no chromatogram classifier supplier available with the following id: " + classifierId + ".");
        }
        for (IChromatogramClassifierSupplier supplier : this.suppliers) {
            if (!supplier.getId().equals(classifierId)) continue;
            classifierSupplier = supplier;
            break;
        }
        if (classifierSupplier == null) {
            throw new NoChromatogramClassifierSupplierAvailableException("There is no chromatogram classifier supplier available with the following id: " + classifierId + ".");
        }
        return classifierSupplier;
    }

    private void areChromatogramClassifiersStored() throws NoChromatogramClassifierSupplierAvailableException {
        if (this.suppliers.size() < 1) {
            throw new NoChromatogramClassifierSupplierAvailableException();
        }
    }
}

