/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.converter.ui.adapter;

import java.text.DecimalFormat;
import java.util.ArrayList;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.support.text.ValueFormat;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public abstract class ChromatogramPropertySource
implements IPropertySource {
    private static final String CATEGORY = "File";
    private static final String RECORDS = "Records";
    private static final String NAME = "name";
    private static final String SIZE = "size";
    private static final String FILE = "file";
    private static final String OPERATOR = "operator";
    private static final String DATE = "date";
    private static final String SCAN_DELAY = "scanDelay";
    private static final String SCAN_INTERVAL = "scanInterval";
    private static final String NUMBER_OF_SCANS = "numberOfScans";
    private static final String STOP_RETENTION_TIME = "stopRetentionTime";
    private static final String START_RETENTION_TIME = "startRetentionTime";
    private final IChromatogramMSD chromatogram;

    public ChromatogramPropertySource(IChromatogramMSD chromatogram) {
        this.chromatogram = chromatogram;
    }

    public Object getEditableValue() {
        return this;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        ArrayList<TextPropertyDescriptor> list = new ArrayList<TextPropertyDescriptor>();
        TextPropertyDescriptor textPropertyDescriptor = new TextPropertyDescriptor((Object)START_RETENTION_TIME, "Start Retention Time (Minutes)");
        textPropertyDescriptor.setCategory(RECORDS);
        list.add(textPropertyDescriptor);
        textPropertyDescriptor = new TextPropertyDescriptor((Object)STOP_RETENTION_TIME, "Stop Retention Time (Minutes)");
        textPropertyDescriptor.setCategory(RECORDS);
        list.add(textPropertyDescriptor);
        textPropertyDescriptor = new TextPropertyDescriptor((Object)NUMBER_OF_SCANS, "Scans");
        textPropertyDescriptor.setCategory(RECORDS);
        list.add(textPropertyDescriptor);
        textPropertyDescriptor = new TextPropertyDescriptor((Object)SCAN_DELAY, "Scan Delay (Milliseconds)");
        textPropertyDescriptor.setCategory(RECORDS);
        list.add(textPropertyDescriptor);
        textPropertyDescriptor = new TextPropertyDescriptor((Object)SCAN_INTERVAL, "Scan Interval (Milliseconds)");
        textPropertyDescriptor.setCategory(RECORDS);
        list.add(textPropertyDescriptor);
        textPropertyDescriptor = new TextPropertyDescriptor((Object)DATE, "Date");
        textPropertyDescriptor.setCategory(RECORDS);
        list.add(textPropertyDescriptor);
        textPropertyDescriptor = new TextPropertyDescriptor((Object)OPERATOR, "Operator");
        textPropertyDescriptor.setCategory(RECORDS);
        list.add(textPropertyDescriptor);
        textPropertyDescriptor = new TextPropertyDescriptor((Object)FILE, CATEGORY);
        textPropertyDescriptor.setCategory(CATEGORY);
        list.add(textPropertyDescriptor);
        textPropertyDescriptor = new TextPropertyDescriptor((Object)SIZE, "Size (MB)");
        textPropertyDescriptor.setCategory(CATEGORY);
        list.add(textPropertyDescriptor);
        textPropertyDescriptor = new TextPropertyDescriptor((Object)NAME, "Name");
        textPropertyDescriptor.setCategory(CATEGORY);
        list.add(textPropertyDescriptor);
        return list.toArray(new IPropertyDescriptor[list.size()]);
    }

    public Object getPropertyValue(Object id) {
        if (START_RETENTION_TIME.equals(id)) {
            return this.getFormattedValue(this.chromatogram.getStartRetentionTime(), 60000.0, "0.00");
        }
        if (STOP_RETENTION_TIME.equals(id)) {
            return this.getFormattedValue(this.chromatogram.getStopRetentionTime(), 60000.0, "0.00");
        }
        if (NUMBER_OF_SCANS.equals(id)) {
            return Integer.valueOf(this.chromatogram.getNumberOfScans()).toString();
        }
        if (SCAN_DELAY.equals(id)) {
            return Integer.valueOf(this.chromatogram.getScanDelay()).toString();
        }
        if (SCAN_INTERVAL.equals(id)) {
            return Integer.valueOf(this.chromatogram.getScanInterval()).toString();
        }
        if (DATE.equals(id)) {
            return this.chromatogram.getDate().toString();
        }
        if (OPERATOR.equals(id)) {
            return this.chromatogram.getOperator();
        }
        if (FILE.equals(id)) {
            return this.chromatogram.getFile().toString();
        }
        if (SIZE.equals(id)) {
            return this.getFormattedValue(this.chromatogram.getFile().length(), 1000000.0, "0.00");
        }
        if (NAME.equals(id)) {
            return this.chromatogram.getName();
        }
        return null;
    }

    public String getFormattedValue(double value, double denominator, String pattern) {
        if (denominator != 0.0) {
            value /= denominator;
        }
        if (pattern == null || pattern == "") {
            pattern = "#.00";
        }
        DecimalFormat formatter = ValueFormat.getDecimalFormatEnglish((String)pattern);
        return formatter.format(value);
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }
}

