/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.swt.ui.converter;

import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.baseline.IBaselineModel;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IChromatogramOverview;
import org.eclipse.chemclipse.model.exceptions.ChromatogramIsNullException;
import org.eclipse.chemclipse.model.signals.ITotalScanSignal;
import org.eclipse.chemclipse.model.signals.ITotalScanSignals;
import org.eclipse.chemclipse.model.signals.TotalScanSignalExtractor;
import org.eclipse.chemclipse.swt.ui.support.PlotSeries;

public class Converter {
    private static final Logger logger = Logger.getLogger(Converter.class);

    private Converter() {
    }

    public static PlotSeries convertChromatogram(IChromatogramOverview chromatogramOverview) {
        PlotSeries chromatogramSeries = null;
        if (chromatogramOverview != null) {
            try {
                TotalScanSignalExtractor totalIonSignalExtractor = new TotalScanSignalExtractor(chromatogramOverview);
                ITotalScanSignals signals = totalIonSignalExtractor.getTotalScanSignals();
                int scans = signals.size();
                double[] xSeries = new double[scans];
                double[] ySeries = new double[scans];
                int x = 0;
                int y = 0;
                for (ITotalScanSignal signal : signals.getTotalScanSignals()) {
                    xSeries[x++] = signal.getRetentionTime();
                    ySeries[y++] = signal.getTotalSignal();
                }
                chromatogramSeries = new PlotSeries(xSeries, ySeries);
            }
            catch (ChromatogramIsNullException e) {
                logger.warn((Object)e);
            }
        }
        return chromatogramSeries;
    }

    public static PlotSeries convertBaseline(IChromatogram chromatogram) {
        PlotSeries baselineSeries = null;
        if (chromatogram != null) {
            IBaselineModel baselineModel = chromatogram.getBaselineModel();
            try {
                TotalScanSignalExtractor totalIonSignalExtractor = new TotalScanSignalExtractor(chromatogram);
                ITotalScanSignals signals = totalIonSignalExtractor.getTotalScanSignals();
                int scans = signals.size();
                double[] xSeries = new double[scans];
                double[] ySeries = new double[scans];
                int x = 0;
                int y = 0;
                for (ITotalScanSignal signal : signals.getTotalScanSignals()) {
                    int retentionTime = signal.getRetentionTime();
                    xSeries[x++] = retentionTime;
                    ySeries[y++] = baselineModel.getBackgroundAbundance(retentionTime);
                }
                baselineSeries = new PlotSeries(xSeries, ySeries);
            }
            catch (ChromatogramIsNullException e) {
                logger.warn((Object)e);
            }
        }
        return baselineSeries;
    }
}

