/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.csd.swt.ui.components.chromatogram;

import java.util.Collections;
import java.util.List;
import org.eclipse.chemclipse.csd.model.core.IChromatogramCSD;
import org.eclipse.chemclipse.csd.model.core.IChromatogramPeakCSD;
import org.eclipse.chemclipse.csd.model.core.IPeakCSD;
import org.eclipse.chemclipse.csd.model.core.IScanCSD;
import org.eclipse.chemclipse.csd.model.core.selection.IChromatogramSelectionCSD;
import org.eclipse.chemclipse.csd.swt.ui.components.chromatogram.AbstractEditorChromatogramUI;
import org.eclipse.chemclipse.csd.swt.ui.converter.SeriesConverterCSD;
import org.eclipse.chemclipse.model.comparator.ChromatogramPeakComparator;
import org.eclipse.chemclipse.model.comparator.SortOrder;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.selection.ChromatogramSelectionSupport;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.model.selection.MoveDirection;
import org.eclipse.chemclipse.swt.ui.converter.SeriesConverter;
import org.eclipse.chemclipse.swt.ui.exceptions.NoIdentifiedScansAvailableException;
import org.eclipse.chemclipse.swt.ui.exceptions.NoPeaksAvailableException;
import org.eclipse.chemclipse.swt.ui.marker.MouseMoveMarker;
import org.eclipse.chemclipse.swt.ui.marker.SelectedPositionMarker;
import org.eclipse.chemclipse.swt.ui.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.swt.ui.series.ISeries;
import org.eclipse.chemclipse.swt.ui.series.Series;
import org.eclipse.chemclipse.swt.ui.support.Colors;
import org.eclipse.chemclipse.swt.ui.support.IOffset;
import org.eclipse.chemclipse.swt.ui.support.Offset;
import org.eclipse.chemclipse.swt.ui.support.Sign;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.swtchart.ICustomPaintListener;
import org.swtchart.ILineSeries;
import org.swtchart.IPlotArea;
import org.swtchart.ISeries;
import org.swtchart.LineStyle;

public class EditorChromatogramUI
extends AbstractEditorChromatogramUI {
    private MouseMoveMarker mouseMoveMarker;
    private SelectedPositionMarker selectedPositionMarker;
    private ChromatogramPeakComparator chromatogramPeakComparator;

    public EditorChromatogramUI(Composite parent, int style) {
        super(parent, style);
        boolean yMinimumToZero = PreferenceSupplier.showBackgroundInChromatogramEditor();
        this.setYMinimumToZero(yMinimumToZero);
        this.chromatogramPeakComparator = new ChromatogramPeakComparator(SortOrder.ASC);
    }

    public void setViewSeries() {
        IChromatogramSelection storedChromatogramSelection = this.getChromatogramSelection();
        if (storedChromatogramSelection instanceof IChromatogramSelectionCSD) {
            ILineSeries scatterSeries;
            IChromatogramSelectionCSD chromatogramSelection = (IChromatogramSelectionCSD)storedChromatogramSelection;
            ISeries series = SeriesConverter.convertChromatogram((IChromatogramSelection)chromatogramSelection, (Sign)Sign.POSITIVE, (boolean)false);
            this.addSeries(series);
            ILineSeries lineSeries = (ILineSeries)this.getSeriesSet().createSeries(ISeries.SeriesType.LINE, series.getId());
            lineSeries.setXSeries(series.getXSeries());
            lineSeries.setYSeries(series.getYSeries());
            lineSeries.enableArea(true);
            lineSeries.setSymbolType(ILineSeries.PlotSymbolType.NONE);
            Color chromatogramColor = PreferenceSupplier.getChromatogramColor();
            if (chromatogramColor == null) {
                chromatogramColor = Colors.RED;
            }
            lineSeries.setLineColor(chromatogramColor);
            IScanCSD selectedScan = chromatogramSelection.getSelectedScan();
            if (selectedScan != null) {
                series = this.getSelectedScanSeries((IScan)selectedScan);
                ILineSeries selectedScanSeries = (ILineSeries)this.getSeriesSet().createSeries(ISeries.SeriesType.LINE, series.getId());
                selectedScanSeries.setXSeries(series.getXSeries());
                selectedScanSeries.setYSeries(series.getYSeries());
                selectedScanSeries.setLineStyle(LineStyle.NONE);
                selectedScanSeries.setSymbolType(ILineSeries.PlotSymbolType.CROSS);
                selectedScanSeries.setSymbolSize(5);
                selectedScanSeries.setSymbolColor(Colors.DARK_RED);
            }
            try {
                series = SeriesConverterCSD.convertPeakMaxPositions(chromatogramSelection, (IOffset)new Offset(0.0, 0.0), Sign.POSITIVE, true);
                scatterSeries = (ILineSeries)this.getSeriesSet().createSeries(ISeries.SeriesType.LINE, series.getId());
                scatterSeries.setXSeries(series.getXSeries());
                scatterSeries.setYSeries(series.getYSeries());
                scatterSeries.setLineStyle(LineStyle.NONE);
                scatterSeries.setSymbolType(ILineSeries.PlotSymbolType.INVERTED_TRIANGLE);
                scatterSeries.setSymbolSize(5);
                scatterSeries.setLineColor(Colors.GRAY);
                scatterSeries.setSymbolColor(Colors.DARK_GRAY);
            }
            catch (NoPeaksAvailableException noPeaksAvailableException) {}
            try {
                series = SeriesConverterCSD.convertPeakMaxPositions(chromatogramSelection, (IOffset)new Offset(0.0, 0.0), Sign.POSITIVE, false);
                scatterSeries = (ILineSeries)this.getSeriesSet().createSeries(ISeries.SeriesType.LINE, series.getId());
                scatterSeries.setXSeries(series.getXSeries());
                scatterSeries.setYSeries(series.getYSeries());
                scatterSeries.setLineStyle(LineStyle.NONE);
                scatterSeries.setSymbolType(ILineSeries.PlotSymbolType.INVERTED_TRIANGLE);
                scatterSeries.setSymbolSize(5);
                scatterSeries.setLineColor(Colors.GRAY);
                scatterSeries.setSymbolColor(Colors.GRAY);
            }
            catch (NoPeaksAvailableException noPeaksAvailableException) {}
            IChromatogramPeakCSD peak = chromatogramSelection.getSelectedPeak();
            if (peak != null && PreferenceSupplier.showSelectedPeakInEditor()) {
                series = SeriesConverterCSD.convertSelectedPeak((IPeakCSD)peak, true, Sign.POSITIVE);
                ILineSeries peakSeries = (ILineSeries)this.getSeriesSet().createSeries(ISeries.SeriesType.LINE, series.getId());
                peakSeries.setXSeries(series.getXSeries());
                peakSeries.setYSeries(series.getYSeries());
                peakSeries.enableArea(true);
                if (PreferenceSupplier.showScansOfSelectedPeak()) {
                    peakSeries.setSymbolType(ILineSeries.PlotSymbolType.CIRCLE);
                    peakSeries.setSymbolColor(Colors.DARK_RED);
                    int size = PreferenceSupplier.sizeOfPeakScanMarker();
                    peakSeries.setSymbolSize(size);
                } else {
                    peakSeries.setSymbolType(ILineSeries.PlotSymbolType.NONE);
                }
                peakSeries.setLineColor(Colors.DARK_RED);
                series = SeriesConverterCSD.convertSelectedPeakBackground((IPeakCSD)peak, Sign.POSITIVE);
                ILineSeries backgroundSeries = (ILineSeries)this.getSeriesSet().createSeries(ISeries.SeriesType.LINE, series.getId());
                backgroundSeries.setXSeries(series.getXSeries());
                backgroundSeries.setYSeries(series.getYSeries());
                backgroundSeries.enableArea(true);
                backgroundSeries.setSymbolType(ILineSeries.PlotSymbolType.NONE);
                backgroundSeries.setLineColor(Colors.BLACK);
            }
            try {
                series = SeriesConverterCSD.convertIdentifiedScans(chromatogramSelection, (IOffset)new Offset(0.0, 0.0), Sign.POSITIVE);
                scatterSeries = (ILineSeries)this.getSeriesSet().createSeries(ISeries.SeriesType.LINE, series.getId());
                scatterSeries.setXSeries(series.getXSeries());
                scatterSeries.setYSeries(series.getYSeries());
                scatterSeries.setLineStyle(LineStyle.NONE);
                scatterSeries.setSymbolType(ILineSeries.PlotSymbolType.CIRCLE);
                scatterSeries.setSymbolSize(3);
                scatterSeries.setLineColor(Colors.GRAY);
                scatterSeries.setSymbolColor(Colors.DARK_GRAY);
            }
            catch (NoIdentifiedScansAvailableException noIdentifiedScansAvailableException) {}
        }
    }

    private ISeries getSelectedScanSeries(IScan selectedScan) {
        double[] xSeries = new double[]{selectedScan.getRetentionTime()};
        int totalSignal = (int)selectedScan.getTotalSignal();
        double[] ySeries = new double[]{totalSignal};
        return new Series(xSeries, ySeries, "Selected Scan");
    }

    protected void initialize() {
        super.initialize();
        IPlotArea plotArea = (IPlotArea)this.getPlotArea();
        this.mouseMoveMarker = new MouseMoveMarker();
        plotArea.addCustomPaintListener((ICustomPaintListener)this.mouseMoveMarker);
        if (PreferenceSupplier.showChromatogramPositionMarkerBox()) {
            Color foregroundColor = PreferenceSupplier.getPositionMarkerForegroundColor();
            Color backgroundColor = PreferenceSupplier.getPositionMarkerBackgroundColor();
            this.selectedPositionMarker = new SelectedPositionMarker(foregroundColor, backgroundColor);
            plotArea.addCustomPaintListener((ICustomPaintListener)this.selectedPositionMarker);
            this.getPlotArea().addMouseMoveListener(new MouseMoveListener(){

                public void mouseMove(MouseEvent e) {
                    EditorChromatogramUI.this.mouseMoveMarker.setXPosition(e.x);
                    double abundance = EditorChromatogramUI.this.getSelectedAbundance(e.y);
                    int retentionTimeInMilliseconds = EditorChromatogramUI.this.getSelectedRetentionTimeAsMilliseconds(e.x);
                    EditorChromatogramUI.this.selectedPositionMarker.setActualPosition(retentionTimeInMilliseconds, abundance);
                    EditorChromatogramUI.this.getPlotArea().redraw();
                }
            });
        }
    }

    public void mouseDoubleClick(MouseEvent e) {
        if (e.button == 1) {
            if (e.stateMask == 262144) {
                this.handlePeakSelection(e.x);
            } else {
                this.handleScanSelection(e.x);
            }
        }
    }

    public void mouseScrolled(MouseEvent e) {
        this.handleMouseWheelSelection(e);
    }

    public void keyPressed(KeyEvent e) {
        int keyCode = e.keyCode;
        int stateMask = e.stateMask;
        if (stateMask == 262144) {
            if (keyCode == 0x1000004 || keyCode == 0x1000003) {
                this.handleControlScanSelection(keyCode);
            } else {
                super.keyPressed(e);
            }
        } else if (keyCode == 0x1000004 || keyCode == 0x1000003 || keyCode == 0x1000001 || keyCode == 0x1000002) {
            this.handleArrowMoveWindowSelection(keyCode);
        }
    }

    private void handlePeakSelection(int x) {
        IChromatogramSelection storedChromatogramSelection = this.getChromatogramSelection();
        if (storedChromatogramSelection instanceof IChromatogramSelectionCSD) {
            IChromatogramSelectionCSD chromatogramSelection = (IChromatogramSelectionCSD)storedChromatogramSelection;
            int retentionTime = this.getRetentionTime(x);
            IChromatogramPeakCSD selectedPeak = chromatogramSelection.getChromatogramCSD().getPeak(retentionTime);
            if (selectedPeak != null) {
                chromatogramSelection.setSelectedPeak(selectedPeak, true);
                if (PreferenceSupplier.isMoveRetentionTimeOnPeakSelection()) {
                    this.adjustChromatogramSelection(selectedPeak, chromatogramSelection);
                }
                chromatogramSelection.update(true);
            }
        }
    }

    private void adjustChromatogramSelection(IChromatogramPeakCSD selectedPeak, IChromatogramSelectionCSD chromatogramSelection) {
        IChromatogramCSD chromatogramCSD = chromatogramSelection.getChromatogramCSD();
        List peaks = chromatogramCSD.getPeaks();
        List peaksSelection = chromatogramCSD.getPeaks(chromatogramSelection);
        Collections.sort(peaks, this.chromatogramPeakComparator);
        Collections.sort(peaksSelection, this.chromatogramPeakComparator);
        if (!((IChromatogramPeakCSD)peaks.get(0)).equals(selectedPeak) && !((IChromatogramPeakCSD)peaks.get(peaks.size() - 1)).equals(selectedPeak)) {
            if (((IChromatogramPeakCSD)peaksSelection.get(0)).equals(selectedPeak)) {
                ChromatogramSelectionSupport.moveRetentionTimeWindow((IChromatogramSelection)chromatogramSelection, (MoveDirection)MoveDirection.LEFT, (int)5);
            } else if (((IChromatogramPeakCSD)peaksSelection.get(peaksSelection.size() - 1)).equals(selectedPeak)) {
                ChromatogramSelectionSupport.moveRetentionTimeWindow((IChromatogramSelection)chromatogramSelection, (MoveDirection)MoveDirection.RIGHT, (int)5);
            }
        }
    }
}

