/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.decompose.qr;

import org.ejml.alg.dense.decompose.qr.QrHelperFunctions_CD64;
import org.ejml.data.CDenseMatrix64F;
import org.ejml.data.Complex64F;
import org.ejml.interfaces.decomposition.QRDecomposition;
import org.ejml.ops.CCommonOps;

public class QRDecompositionHouseholderColumn_CD64
implements QRDecomposition<CDenseMatrix64F> {
    protected double[][] dataQR;
    protected double[] v;
    protected int numCols;
    protected int numRows;
    protected int minLength;
    protected double[] gammas;
    protected double gamma;
    protected Complex64F tau = new Complex64F();
    protected boolean error;

    public void setExpectedMaxSize(int numRows, int numCols) {
        this.numCols = numCols;
        this.numRows = numRows;
        this.minLength = Math.min(numCols, numRows);
        int maxLength = Math.max(numCols, numRows);
        if (this.dataQR == null || this.dataQR.length < numCols || this.dataQR[0].length < numRows * 2) {
            this.dataQR = new double[numCols][numRows * 2];
            this.v = new double[maxLength * 2];
            this.gammas = new double[this.minLength];
        }
        if (this.v.length < maxLength * 2) {
            this.v = new double[maxLength * 2];
        }
        if (this.gammas.length < this.minLength) {
            this.gammas = new double[this.minLength];
        }
    }

    public double[][] getQR() {
        return this.dataQR;
    }

    @Override
    public CDenseMatrix64F getQ(CDenseMatrix64F Q, boolean compact) {
        if (compact) {
            if (Q == null) {
                Q = CCommonOps.identity(this.numRows, this.minLength);
            } else {
                if (Q.numRows != this.numRows || Q.numCols != this.minLength) {
                    throw new IllegalArgumentException("Unexpected matrix dimension.");
                }
                CCommonOps.setIdentity(Q);
            }
        } else if (Q == null) {
            Q = CCommonOps.identity(this.numRows);
        } else {
            if (Q.numRows != this.numRows || Q.numCols != this.numRows) {
                throw new IllegalArgumentException("Unexpected matrix dimension.");
            }
            CCommonOps.setIdentity(Q);
        }
        int j = this.minLength - 1;
        while (j >= 0) {
            double[] u = this.dataQR[j];
            double vvReal = u[j * 2];
            double vvImag = u[j * 2 + 1];
            u[j * 2] = 1.0;
            u[j * 2 + 1] = 0.0;
            double gammaReal = this.gammas[j];
            QrHelperFunctions_CD64.rank1UpdateMultR(Q, u, 0, gammaReal, j, j, this.numRows, this.v);
            u[j * 2] = vvReal;
            u[j * 2 + 1] = vvImag;
            --j;
        }
        return Q;
    }

    @Override
    public CDenseMatrix64F getR(CDenseMatrix64F R, boolean compact) {
        if (R == null) {
            R = compact ? new CDenseMatrix64F(this.minLength, this.numCols) : new CDenseMatrix64F(this.numRows, this.numCols);
        } else {
            if (compact) {
                if (R.numCols != this.numCols || R.numRows != this.minLength) {
                    throw new IllegalArgumentException("Unexpected dimensions: found( " + R.numRows + " " + R.numCols + " ) expected( " + this.minLength + " " + this.numCols + " )");
                }
            } else if (R.numCols != this.numCols || R.numRows != this.numRows) {
                throw new IllegalArgumentException("Unexpected dimensions");
            }
            int i = 0;
            while (i < R.numRows) {
                int min = Math.min(i, R.numCols);
                int j = 0;
                while (j < min) {
                    R.set(i, j, 0.0, 0.0);
                    ++j;
                }
                ++i;
            }
        }
        int j = 0;
        while (j < this.numCols) {
            double[] colR = this.dataQR[j];
            int l = Math.min(j, this.numRows - 1);
            int i = 0;
            while (i <= l) {
                R.set(i, j, colR[i * 2], colR[i * 2 + 1]);
                ++i;
            }
            ++j;
        }
        return R;
    }

    @Override
    public boolean decompose(CDenseMatrix64F A) {
        this.setExpectedMaxSize(A.numRows, A.numCols);
        this.convertToColumnMajor(A);
        this.error = false;
        int j = 0;
        while (j < this.minLength) {
            this.householder(j);
            this.updateA(j);
            ++j;
        }
        return !this.error;
    }

    @Override
    public boolean inputModified() {
        return false;
    }

    protected void convertToColumnMajor(CDenseMatrix64F A) {
        int x = 0;
        while (x < this.numCols) {
            double[] colQ = this.dataQR[x];
            int indexCol = 0;
            int y = 0;
            while (y < this.numRows) {
                int index = (y * this.numCols + x) * 2;
                colQ[indexCol++] = A.data[index];
                colQ[indexCol++] = A.data[index + 1];
                ++y;
            }
            ++x;
        }
    }

    protected void householder(int j) {
        double[] u = this.dataQR[j];
        double max = QrHelperFunctions_CD64.findMax(u, j, this.numRows - j);
        if (max == 0.0) {
            this.gamma = 0.0;
            this.error = true;
        } else {
            this.gamma = QrHelperFunctions_CD64.computeTauGammaAndDivide(j, this.numRows, u, max, this.tau);
            double real_u_0 = u[j * 2] + this.tau.real;
            double imag_u_0 = u[j * 2 + 1] + this.tau.imaginary;
            QrHelperFunctions_CD64.divideElements(j + 1, this.numRows, u, 0, real_u_0, imag_u_0);
            this.tau.real *= max;
            this.tau.imaginary *= max;
            u[j * 2] = -this.tau.real;
            u[j * 2 + 1] = -this.tau.imaginary;
        }
        this.gammas[j] = this.gamma;
    }

    protected void updateA(int w) {
        double[] u = this.dataQR[w];
        int j = w + 1;
        while (j < this.numCols) {
            double imagU;
            double realU;
            double[] colQ = this.dataQR[j];
            double realSum = colQ[w * 2];
            double imagSum = colQ[w * 2 + 1];
            int k = w + 1;
            while (k < this.numRows) {
                realU = u[k * 2];
                imagU = -u[k * 2 + 1];
                double realQ = colQ[k * 2];
                double imagQ = colQ[k * 2 + 1];
                realSum += realU * realQ - imagU * imagQ;
                imagSum += imagU * realQ + realU * imagQ;
                ++k;
            }
            int n = w * 2;
            colQ[n] = colQ[n] - (realSum *= this.gamma);
            int n2 = w * 2 + 1;
            colQ[n2] = colQ[n2] - (imagSum *= this.gamma);
            int i = w + 1;
            while (i < this.numRows) {
                realU = u[i * 2];
                imagU = u[i * 2 + 1];
                int n3 = i * 2;
                colQ[n3] = colQ[n3] - (realU * realSum - imagU * imagSum);
                int n4 = i * 2 + 1;
                colQ[n4] = colQ[n4] - (imagU * realSum + realU * imagSum);
                ++i;
            }
            ++j;
        }
    }

    public double[] getGammas() {
        return this.gammas;
    }
}

