/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.report.core;

import java.io.File;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.chemclipse.chromatogram.xxd.report.chromatogram.IChromatogramReportGenerator;
import org.eclipse.chemclipse.chromatogram.xxd.report.core.ChromatogramReportSupplier;
import org.eclipse.chemclipse.chromatogram.xxd.report.core.ChromatogramReportSupport;
import org.eclipse.chemclipse.chromatogram.xxd.report.processing.ChromatogramReportProcessingInfo;
import org.eclipse.chemclipse.chromatogram.xxd.report.processing.IChromatogramReportProcessingInfo;
import org.eclipse.chemclipse.chromatogram.xxd.report.settings.IChromatogramReportSettings;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;

public class ChromatogramReports {
    private static final Logger logger = Logger.getLogger(ChromatogramReports.class);
    private static final String EXTENSION_POINT = "org.eclipse.chemclipse.chromatogram.xxd.report.chromatogramReportSupplier";
    public static final String ID = "id";
    public static final String DESCRIPTION = "description";
    public static final String FILTER_NAME = "reportName";
    public static final String FILE_EXTENSION = "fileExtension";
    public static final String FILE_NAME = "fileName";
    public static final String REPORT_GENERATOR = "reportGenerator";

    private ChromatogramReports() {
    }

    public static IChromatogramReportProcessingInfo generate(File file, boolean append, IChromatogram chromatogram, IChromatogramReportSettings chromatogramReportSettings, String reportSupplierId, IProgressMonitor monitor) {
        IChromatogramReportGenerator reportGenerator = ChromatogramReports.getChromatogramReportGenerator(reportSupplierId);
        IChromatogramReportProcessingInfo processingInfo = reportGenerator != null ? reportGenerator.generate(file, append, chromatogram, chromatogramReportSettings, monitor) : ChromatogramReports.getNoChromatogramReportAvailableProcessingInfo(file);
        return processingInfo;
    }

    public static IChromatogramReportProcessingInfo generate(File file, boolean append, IChromatogram chromatogram, String reportSupplierId, IProgressMonitor monitor) {
        IChromatogramReportGenerator reportGenerator = ChromatogramReports.getChromatogramReportGenerator(reportSupplierId);
        IChromatogramReportProcessingInfo processingInfo = reportGenerator != null ? reportGenerator.generate(file, append, chromatogram, monitor) : ChromatogramReports.getNoChromatogramReportAvailableProcessingInfo(file);
        return processingInfo;
    }

    public static IChromatogramReportProcessingInfo generate(File file, boolean append, List<IChromatogram> chromatograms, IChromatogramReportSettings chromatogramReportSettings, String reportSupplierId, IProgressMonitor monitor) {
        IChromatogramReportGenerator reportGenerator = ChromatogramReports.getChromatogramReportGenerator(reportSupplierId);
        IChromatogramReportProcessingInfo processingInfo = reportGenerator != null ? reportGenerator.generate(file, append, chromatograms, chromatogramReportSettings, monitor) : ChromatogramReports.getNoChromatogramReportAvailableProcessingInfo(file);
        return processingInfo;
    }

    public static IChromatogramReportProcessingInfo generate(File file, boolean append, List<IChromatogram> chromatograms, String reportSupplierId, IProgressMonitor monitor) {
        IChromatogramReportGenerator reportGenerator = ChromatogramReports.getChromatogramReportGenerator(reportSupplierId);
        IChromatogramReportProcessingInfo processingInfo = reportGenerator != null ? reportGenerator.generate(file, append, chromatograms, monitor) : ChromatogramReports.getNoChromatogramReportAvailableProcessingInfo(file);
        return processingInfo;
    }

    public static ChromatogramReportSupport getChromatogramReportSupplierSupport() {
        IConfigurationElement[] extensions;
        ChromatogramReportSupport chromatogramReportSupport = new ChromatogramReportSupport();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = extensions = registry.getConfigurationElementsFor(EXTENSION_POINT);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            ChromatogramReportSupplier supplier = new ChromatogramReportSupplier();
            supplier.setFileExtension(element.getAttribute(FILE_EXTENSION));
            supplier.setFileName(element.getAttribute(FILE_NAME));
            if (ChromatogramReports.isValid(supplier.getFileExtension()) && ChromatogramReports.isValid(supplier.getFileName())) {
                supplier.setId(element.getAttribute(ID));
                supplier.setDescription(element.getAttribute(DESCRIPTION));
                supplier.setFileExtension(element.getAttribute(FILE_EXTENSION));
                supplier.setFileName(element.getAttribute(FILE_NAME));
                supplier.setFilterName(element.getAttribute(FILTER_NAME));
                chromatogramReportSupport.add(supplier);
            }
            ++n2;
        }
        return chromatogramReportSupport;
    }

    private static IChromatogramReportGenerator getChromatogramReportGenerator(String reportGeneratorId) {
        IConfigurationElement element = ChromatogramReports.getConfigurationElement(reportGeneratorId);
        IChromatogramReportGenerator instance = null;
        if (element != null) {
            try {
                instance = (IChromatogramReportGenerator)element.createExecutableExtension(REPORT_GENERATOR);
            }
            catch (CoreException e) {
                logger.warn((Object)e);
            }
        }
        return instance;
    }

    private static IConfigurationElement getConfigurationElement(String reportGeneratorId) {
        IConfigurationElement[] elements;
        if ("".equals(reportGeneratorId)) {
            return null;
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor(EXTENSION_POINT);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getAttribute(ID).equals(reportGeneratorId)) {
                return element;
            }
            ++n2;
        }
        return null;
    }

    private static IChromatogramReportProcessingInfo getNoChromatogramReportAvailableProcessingInfo(File file) {
        ChromatogramReportProcessingInfo processingInfo = new ChromatogramReportProcessingInfo();
        processingInfo.addErrorMessage("Chromatogram Report Generator", "There is no suitable chromatogram report generator available for: " + file.getAbsolutePath());
        return processingInfo;
    }

    public static boolean isValid(String input) {
        if (input == null) {
            return false;
        }
        String regex = "[\\\\/:*?\"<>|]";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(input);
        return !matcher.find();
    }
}

