/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.filter.supplier.subtract.preferences;

import java.util.Map;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.exceptions.AbundanceLimitExceededException;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.model.core.support.IMarkedIons;
import org.eclipse.chemclipse.msd.model.core.support.MarkedIons;
import org.eclipse.chemclipse.msd.model.exceptions.IonLimitExceededException;
import org.eclipse.chemclipse.msd.model.implementation.CombinedMassSpectrum;
import org.eclipse.chemclipse.msd.model.implementation.Ion;
import org.eclipse.chemclipse.msd.model.support.CombinedMassSpectrumCalculator;
import org.eclipse.chemclipse.msd.model.support.ICombinedMassSpectrumCalculator;

public class FilterSupport {
    private static final Logger logger = Logger.getLogger(FilterSupport.class);
    public static final float NORMALIZATION_FACTOR = 1000.0f;

    public static IScanMSD getCombinedMassSpectrum(IChromatogramSelectionMSD chromatogramSelection, IMarkedIons excludedIons, boolean useNormalize) {
        if (chromatogramSelection == null || chromatogramSelection.getChromatogram() == null) {
            return null;
        }
        excludedIons = FilterSupport.validateExcludedIons(excludedIons);
        IChromatogramMSD chromatogram = chromatogramSelection.getChromatogramMSD();
        int startScan = chromatogram.getScanNumber(chromatogramSelection.getStartRetentionTime());
        int stopScan = chromatogram.getScanNumber(chromatogramSelection.getStopRetentionTime());
        CombinedMassSpectrumCalculator massSpectrumCalculator = new CombinedMassSpectrumCalculator();
        int scan = startScan;
        while (scan <= stopScan) {
            massSpectrumCalculator.addIons(chromatogram.getSupplierScan(scan).getIons(), excludedIons);
            ++scan;
        }
        return FilterSupport.getMassSpectrum((ICombinedMassSpectrumCalculator)massSpectrumCalculator, useNormalize);
    }

    public static IScanMSD getCombinedMassSpectrum(IScanMSD massSpectrum1, IScanMSD massSpectrum2, IMarkedIons excludedIons, boolean useNormalize) {
        if (massSpectrum1 == null && massSpectrum2 == null) {
            return null;
        }
        excludedIons = FilterSupport.validateExcludedIons(excludedIons);
        CombinedMassSpectrumCalculator massSpectrumCalculator = new CombinedMassSpectrumCalculator();
        if (massSpectrum1 == null) {
            FilterSupport.addIonsToCalculator(massSpectrum2, excludedIons, (ICombinedMassSpectrumCalculator)massSpectrumCalculator, useNormalize);
        } else if (massSpectrum2 == null) {
            FilterSupport.addIonsToCalculator(massSpectrum1, excludedIons, (ICombinedMassSpectrumCalculator)massSpectrumCalculator, useNormalize);
        } else {
            FilterSupport.addIonsToCalculator(massSpectrum1, excludedIons, (ICombinedMassSpectrumCalculator)massSpectrumCalculator, useNormalize);
            FilterSupport.addIonsToCalculator(massSpectrum2, excludedIons, (ICombinedMassSpectrumCalculator)massSpectrumCalculator, useNormalize);
        }
        return FilterSupport.getMassSpectrum((ICombinedMassSpectrumCalculator)massSpectrumCalculator, useNormalize);
    }

    private static void addIonsToCalculator(IScanMSD massSpectrum, IMarkedIons excludedIons, ICombinedMassSpectrumCalculator massSpectrumCalculator, boolean useNormalize) {
        IScanMSD massSpectrumCalculated = FilterSupport.getCalculatedMassSpectrum(massSpectrum, excludedIons, useNormalize);
        massSpectrumCalculator.addIons(massSpectrumCalculated.getIons(), excludedIons);
    }

    public static IScanMSD getCalculatedMassSpectrum(IScanMSD massSpectrum, IMarkedIons excludedIons, boolean useNormalize) {
        if (massSpectrum == null) {
            return null;
        }
        excludedIons = FilterSupport.validateExcludedIons(excludedIons);
        CombinedMassSpectrumCalculator massSpectrumCalculator = new CombinedMassSpectrumCalculator();
        massSpectrumCalculator.addIons(massSpectrum.getIons(), excludedIons);
        return FilterSupport.getMassSpectrum((ICombinedMassSpectrumCalculator)massSpectrumCalculator, useNormalize);
    }

    private static IMarkedIons validateExcludedIons(IMarkedIons excludedIons) {
        if (excludedIons == null) {
            excludedIons = new MarkedIons();
        }
        return excludedIons;
    }

    private static IScanMSD getMassSpectrum(ICombinedMassSpectrumCalculator massSpectrumCalculator, boolean useNormalize) {
        if (useNormalize) {
            massSpectrumCalculator.normalize(1000.0f);
        }
        Map ions = massSpectrumCalculator.getValues();
        return FilterSupport.getMassSpectrum(ions);
    }

    private static IScanMSD getMassSpectrum(Map<Integer, Double> ions) {
        CombinedMassSpectrum combinedMassSpectrum = new CombinedMassSpectrum();
        for (Integer ion : ions.keySet()) {
            float abundance = ions.get(ion).floatValue();
            if (!(abundance > 0.0f)) continue;
            try {
                Ion combinedIon = new Ion((double)ion.intValue(), abundance);
                combinedMassSpectrum.addIon((IIon)combinedIon);
            }
            catch (AbundanceLimitExceededException e) {
                logger.warn((Object)e);
            }
            catch (IonLimitExceededException e) {
                logger.warn((Object)e);
            }
        }
        return combinedMassSpectrum;
    }
}

