/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.msd.ui.views;

import java.util.Collection;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.IMassSpectra;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.core.IVendorMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.model.implementation.MassSpectra;
import org.eclipse.chemclipse.msd.swt.ui.components.massspectrum.MassSpectraStackUI;
import org.eclipse.chemclipse.ux.extension.msd.ui.editors.ChromatogramEditorMSD;
import org.eclipse.chemclipse.ux.extension.ui.views.AbstractChromatogramSelectionView;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class EditorMassSpectrumStackView
extends AbstractChromatogramSelectionView {
    @Inject
    private Composite parent;
    private EPartService partService;
    private MassSpectraStackUI massSpectraStackUI;
    private IMassSpectra massSpectra;

    @Inject
    public EditorMassSpectrumStackView(MPart part, EPartService partService, IEventBroker eventBroker) {
        super(part, partService, eventBroker);
        this.partService = partService;
        this.massSpectra = new MassSpectra();
    }

    @PostConstruct
    private void createControl() {
        this.parent.setLayout((Layout)new FillLayout());
        this.massSpectraStackUI = new MassSpectraStackUI(this.parent, 0);
    }

    @Focus
    public void setFocus() {
        this.massSpectraStackUI.update(this.massSpectra, false);
        this.massSpectraStackUI.setFocus();
    }

    public IMassSpectra getMassSpectra(IChromatogramSelectionMSD masterChromatogramSelection) {
        IVendorMassSpectrum masterScanMSD = masterChromatogramSelection.getSelectedScan();
        int masterRetentionTime = masterScanMSD.getRetentionTime();
        MassSpectra massSpectra = new MassSpectra();
        massSpectra.addMassSpectrum((IScanMSD)masterScanMSD);
        Collection parts = this.partService.getParts();
        for (MPart part : parts) {
            int scanNumber;
            IScan selection;
            ChromatogramEditorMSD editor;
            IChromatogramSelectionMSD chromatogramSelectionMSD;
            IChromatogramMSD chromatogramMSD;
            Object object;
            if (!part.getElementId().equals("org.eclipse.chemclipse.ux.extension.msd.ui.part.chromatogramEditor") || (object = part.getObject()) == null) continue;
            IScanMSD scan = null;
            if (object instanceof ChromatogramEditorMSD && (chromatogramMSD = (chromatogramSelectionMSD = (editor = (ChromatogramEditorMSD)object).getChromatogramSelection()).getChromatogramMSD()) != null && (selection = chromatogramMSD.getScan(scanNumber = chromatogramMSD.getScanNumber(masterRetentionTime))) instanceof IScanMSD) {
                scan = (IScanMSD)selection;
            }
            if (scan == null || scan == masterScanMSD) continue;
            massSpectra.addMassSpectrum(scan);
        }
        return massSpectra;
    }

    @PreDestroy
    private void preDestroy() {
        this.unsubscribe();
    }

    public void update(IChromatogramSelection chromatogramSelection, boolean forceReload) {
        if (chromatogramSelection != null && chromatogramSelection instanceof IChromatogramSelectionMSD) {
            this.massSpectra = this.getMassSpectra((IChromatogramSelectionMSD)chromatogramSelection);
            this.massSpectraStackUI.update(this.massSpectra, forceReload);
        } else {
            this.massSpectraStackUI.update((IMassSpectra)new MassSpectra(), forceReload);
        }
    }
}

