/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.refactoring.descriptors.ExtractClassDescriptor;
import org.eclipse.jdt.internal.corext.refactoring.structure.ExtractClassRefactoring;
import org.eclipse.jdt.internal.corext.util.JavaConventionsUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jdt.internal.ui.util.TableLayoutComposite;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusEntry;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class ExtractClassWizard
extends RefactoringWizard {
    private ExtractClassDescriptor fDescriptor;

    public ExtractClassWizard(ExtractClassDescriptor descriptor, Refactoring refactoring) {
        super(refactoring, 4);
        this.fDescriptor = descriptor;
        this.setDefaultPageTitle(RefactoringMessages.ExtractClassWizard_page_title);
    }

    protected void addUserInputPages() {
        this.addPage((IWizardPage)new ExtractClassUserInputWizardPage());
    }

    public ExtractClassRefactoring.ExtractClassDescriptorVerification getVerification() {
        ExtractClassRefactoring.ExtractClassDescriptorVerification adapter = (ExtractClassRefactoring.ExtractClassDescriptorVerification)this.getRefactoring().getAdapter(ExtractClassRefactoring.ExtractClassDescriptorVerification.class);
        return adapter;
    }

    private class ExtractClassUserInputWizardPage
    extends UserInputWizardPage {
        private static final String CREATE_GETTER_SETTER = "CREATE_GETTER_SETTER";
        private static final String CREATE_TOP_LEVEL_SETTING = "CREATE_TOPLEVEL";
        private ControlDecoration fClassNameDecoration;
        private ControlDecoration fParameterNameDecoration;

        public ExtractClassUserInputWizardPage() {
            super("ExtractClass");
            this.setTitle(RefactoringMessages.ExtractClassWizard_page_title);
        }

        public void createControl(Composite parent) {
            this.initializeDialogUnits((Control)parent);
            Composite result = new Composite(parent, 0);
            result.setLayout((Layout)new GridLayout(2, false));
            this.createClassNameInput(result);
            this.createLocationInput(result);
            this.createTable(result);
            this.createGetterSetterInput(result);
            this.createParameterNameInput(result);
            this.setControl((Control)result);
            this.validateRefactoring();
        }

        private void createLocationInput(Composite parent) {
            Label l = new Label(parent, 0);
            l.setText(RefactoringMessages.ExtractClassWizard_label_destination);
            Composite composite = new Composite(parent, 0);
            GridLayout gridLayout = new GridLayout(2, false);
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            composite.setLayout((Layout)gridLayout);
            GridData gridData = new GridData(768);
            gridData.horizontalIndent = FieldDecorationRegistry.getDefault().getMaximumDecorationWidth();
            composite.setLayoutData((Object)gridData);
            final Button topLvlRadio = new Button(composite, 16);
            topLvlRadio.setText(RefactoringMessages.ExtractClassWizard_radio_top_level);
            topLvlRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    boolean fAsTopLevel = topLvlRadio.getSelection();
                    ExtractClassWizard.this.fDescriptor.setCreateTopLevel(fAsTopLevel);
                    ExtractClassUserInputWizardPage.this.validateRefactoring();
                }
            });
            Button nestedRadio = new Button(composite, 16);
            nestedRadio.setText(Messages.format(RefactoringMessages.ExtractClassWizard_radio_nested, JavaElementLabels.getElementLabel((IJavaElement)ExtractClassWizard.this.fDescriptor.getType(), JavaElementLabels.ALL_DEFAULT)));
            boolean createAsTopLevel = this.getBooleanSetting(CREATE_TOP_LEVEL_SETTING, ExtractClassWizard.this.fDescriptor.isCreateTopLevel());
            ExtractClassWizard.this.fDescriptor.setCreateTopLevel(createAsTopLevel);
            topLvlRadio.setSelection(createAsTopLevel);
            nestedRadio.setSelection(!createAsTopLevel);
        }

        private void createGetterSetterInput(Composite result) {
            final Button button = new Button(result, 32);
            button.setText(RefactoringMessages.ExtractClassWizard_checkbox_create_gettersetter);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ExtractClassWizard.this.fDescriptor.setCreateGetterSetter(button.getSelection());
                    ExtractClassUserInputWizardPage.this.validateRefactoring();
                }
            });
            button.setSelection(this.getBooleanSetting(CREATE_GETTER_SETTER, ExtractClassWizard.this.fDescriptor.isCreateGetterSetter()));
            ExtractClassWizard.this.fDescriptor.setCreateGetterSetter(button.getSelection());
            GridData gridData = new GridData();
            gridData.horizontalSpan = 2;
            button.setLayoutData((Object)gridData);
        }

        private void createClassNameInput(Composite result) {
            Label label = new Label(result, 16384);
            label.setText(RefactoringMessages.ExtractClassWizard_label_class_name);
            final Text text = new Text(result, 2052);
            this.fClassNameDecoration = new ControlDecoration((Control)text, 16512);
            text.setText(ExtractClassWizard.this.fDescriptor.getClassName());
            text.selectAll();
            text.setFocus();
            text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ExtractClassWizard.this.fDescriptor.setClassName(text.getText());
                    ExtractClassUserInputWizardPage.this.validateRefactoring();
                }
            });
            GridData gridData = new GridData(768);
            gridData.horizontalIndent = FieldDecorationRegistry.getDefault().getMaximumDecorationWidth();
            text.setLayoutData((Object)gridData);
        }

        protected void updateDecoration(ControlDecoration decoration, RefactoringStatus status) {
            RefactoringStatusEntry highestSeverity = status.getEntryWithHighestSeverity();
            if (highestSeverity != null) {
                Image newImage = null;
                FieldDecorationRegistry registry = FieldDecorationRegistry.getDefault();
                switch (highestSeverity.getSeverity()) {
                    case 1: {
                        newImage = registry.getFieldDecoration("DEC_INFORMATION").getImage();
                        break;
                    }
                    case 2: {
                        newImage = registry.getFieldDecoration("DEC_WARNING").getImage();
                        break;
                    }
                    case 3: 
                    case 4: {
                        newImage = registry.getFieldDecoration("DEC_ERROR").getImage();
                    }
                }
                decoration.setDescriptionText(highestSeverity.getMessage());
                decoration.setImage(newImage);
                decoration.show();
            } else {
                decoration.setDescriptionText(null);
                decoration.hide();
            }
        }

        private void createParameterNameInput(Composite group) {
            Label l = new Label(group, 0);
            l.setText(RefactoringMessages.ExtractClassWizard_field_name);
            final Text text = new Text(group, 2048);
            this.fParameterNameDecoration = new ControlDecoration((Control)text, 16512);
            text.setText(ExtractClassWizard.this.fDescriptor.getFieldName());
            text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ExtractClassWizard.this.fDescriptor.setFieldName(text.getText());
                    ExtractClassUserInputWizardPage.this.validateRefactoring();
                }
            });
            GridData gridData = new GridData(768);
            gridData.horizontalIndent = FieldDecorationRegistry.getDefault().getMaximumDecorationWidth();
            text.setLayoutData((Object)gridData);
        }

        private void createTable(Composite parent) {
            Composite result = new Composite(parent, 0);
            GridLayout layout = new GridLayout(2, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            result.setLayout((Layout)layout);
            GridData gridData = new GridData(1808);
            gridData.horizontalSpan = 2;
            result.setLayoutData((Object)gridData);
            Label l = new Label(result, 0);
            l.setText(RefactoringMessages.ExtractClassWizard_label_select_fields);
            gridData = new GridData(768);
            gridData.horizontalSpan = 2;
            gridData.verticalIndent = 5;
            l.setLayoutData((Object)gridData);
            TableLayoutComposite layoutComposite = new TableLayoutComposite(result, 0);
            layoutComposite.addColumnData((ColumnLayoutData)new ColumnWeightData(40, this.convertWidthInCharsToPixels(20), true));
            layoutComposite.addColumnData((ColumnLayoutData)new ColumnWeightData(60, this.convertWidthInCharsToPixels(20), true));
            final CheckboxTableViewer tv = CheckboxTableViewer.newCheckList((Composite)layoutComposite, (int)68354);
            tv.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            this.createColumns(tv);
            Table table = tv.getTable();
            table.setLinesVisible(true);
            table.setHeaderVisible(true);
            gridData = new GridData(1808);
            table.setLayoutData((Object)gridData);
            ExtractClassDescriptor.Field[] fields = ExtractClassWizard.this.fDescriptor.getFields();
            tv.setInput((Object)fields);
            int i = 0;
            while (i < fields.length) {
                ExtractClassDescriptor.Field field = fields[i];
                tv.setChecked((Object)field, field.isCreateField());
                ++i;
            }
            gridData = new GridData(1808);
            gridData.heightHint = SWTUtil.getTableHeightHint(table, Math.max(fields.length, 5));
            gridData.widthHint = this.convertWidthInCharsToPixels(50);
            layoutComposite.setLayoutData(gridData);
            Composite controls = new Composite(result, 0);
            gridData = new GridData(4, 4, false, false);
            controls.setLayoutData((Object)gridData);
            GridLayout gridLayout = new GridLayout();
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            controls.setLayout((Layout)gridLayout);
            final Button editButton = new Button(controls, 0);
            editButton.setText(RefactoringMessages.ExtractClassWizard_button_edit);
            editButton.setLayoutData((Object)new GridData(768));
            editButton.setEnabled(!tv.getSelection().isEmpty());
            SWTUtil.setButtonDimensionHint(editButton);
            editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ISelection selection = tv.getSelection();
                    if (selection instanceof IStructuredSelection) {
                        IStructuredSelection ss = (IStructuredSelection)selection;
                        ExtractClassDescriptor.Field selected = (ExtractClassDescriptor.Field)ss.getFirstElement();
                        String message = RefactoringMessages.ExtractClassWizard_dialog_message;
                        String title = RefactoringMessages.ExtractClassWizard_dialog_title;
                        InputDialog inputDialog = new InputDialog(ExtractClassUserInputWizardPage.this.getShell(), title, message, selected.getNewFieldName(), new IInputValidator(){

                            public String isValid(String newText) {
                                IStatus status = JavaConventionsUtil.validateIdentifier(newText, (IJavaElement)ExtractClassWizard.this.fDescriptor.getType());
                                if (!status.isOK()) {
                                    return status.getMessage();
                                }
                                return null;
                            }
                        });
                        if (inputDialog.open() == 0) {
                            selected.setNewFieldName(inputDialog.getValue());
                            tv.refresh((Object)selected);
                        }
                    }
                }
            });
            tv.addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    ExtractClassDescriptor.Field element = (ExtractClassDescriptor.Field)event.getElement();
                    element.setCreateField(event.getChecked());
                    ExtractClassUserInputWizardPage.this.validateRefactoring();
                    tv.refresh((Object)element, true);
                }
            });
            tv.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection selection = (IStructuredSelection)tv.getSelection();
                    ExtractClassDescriptor.Field field = (ExtractClassDescriptor.Field)selection.getFirstElement();
                    if (selection.isEmpty()) {
                        editButton.setEnabled(false);
                    } else {
                        editButton.setEnabled(tv.getChecked((Object)field));
                    }
                }
            });
        }

        private void createColumns(CheckboxTableViewer tv) {
            TextCellEditor cellEditor = new TextCellEditor((Composite)tv.getTable());
            TableViewerColumn viewerColumn = new TableViewerColumn((TableViewer)tv, 16384);
            viewerColumn.setLabelProvider((CellLabelProvider)new FieldInfoLabelProvider(this){

                protected String doGetValue(ExtractClassDescriptor.Field pi) {
                    IField field = ExtractClassWizard.this.fDescriptor.getType().getField(pi.getFieldName());
                    try {
                        return Signature.toString((String)field.getTypeSignature());
                    }
                    catch (JavaModelException javaModelException) {
                        return RefactoringMessages.ExtractClassWizard_not_available;
                    }
                }
            });
            TableColumn column = viewerColumn.getColumn();
            column.setText(RefactoringMessages.ExtractClassWizard_column_type);
            viewerColumn = new TableViewerColumn((TableViewer)tv, 16384);
            viewerColumn.setLabelProvider((CellLabelProvider)new FieldInfoLabelProvider(this){

                protected String doGetValue(ExtractClassDescriptor.Field pi) {
                    if (pi.isCreateField()) {
                        return pi.getNewFieldName();
                    }
                    return pi.getFieldName();
                }
            });
            viewerColumn.setEditingSupport((EditingSupport)new FieldInfoEditingSupport(this, (CellEditor)cellEditor, (ColumnViewer)tv){

                public String doGetValue(ExtractClassDescriptor.Field pi) {
                    return pi.getNewFieldName();
                }

                public void doSetValue(ExtractClassDescriptor.Field pi, String string) {
                    pi.setNewFieldName(string);
                }

                protected boolean canEdit(Object element) {
                    if (element instanceof ExtractClassDescriptor.Field) {
                        ExtractClassDescriptor.Field field = (ExtractClassDescriptor.Field)element;
                        return field.isCreateField();
                    }
                    return super.canEdit(element);
                }
            });
            column = viewerColumn.getColumn();
            column.setText(RefactoringMessages.ExtractClassWizard_column_name);
        }

        protected RefactoringStatus validateParameterName() {
            RefactoringStatus status = new RefactoringStatus();
            ExtractClassRefactoring.ExtractClassDescriptorVerification verification = ExtractClassWizard.this.getVerification();
            status.merge(verification.validateParameterName());
            this.updateDecoration(this.fParameterNameDecoration, status);
            return status;
        }

        protected RefactoringStatus validateTopLevel() {
            RefactoringStatus status = new RefactoringStatus();
            ExtractClassRefactoring.ExtractClassDescriptorVerification verification = ExtractClassWizard.this.getVerification();
            status.merge(verification.validateTopLevel());
            this.updateDecoration(this.fClassNameDecoration, status);
            return status;
        }

        protected RefactoringStatus validateClassName() {
            RefactoringStatus status = new RefactoringStatus();
            ExtractClassRefactoring.ExtractClassDescriptorVerification verification = ExtractClassWizard.this.getVerification();
            status.merge(verification.validateClassName());
            this.updateDecoration(this.fClassNameDecoration, status);
            return status;
        }

        protected RefactoringStatus validateFields() {
            RefactoringStatus status = new RefactoringStatus();
            ExtractClassRefactoring.ExtractClassDescriptorVerification verification = ExtractClassWizard.this.getVerification();
            status.merge(verification.validateFields());
            return status;
        }

        protected RefactoringStatus validateRefactoring() {
            RefactoringStatus status = new RefactoringStatus();
            this.setErrorMessage(null);
            this.setMessage(null);
            this.setPageComplete(true);
            status.merge(this.validateTopLevel());
            status.merge(this.validateClassName());
            status.merge(this.validateParameterName());
            status.merge(this.validateFields());
            RefactoringStatusEntry highestSeverity = status.getEntryWithHighestSeverity();
            if (highestSeverity != null) {
                switch (highestSeverity.getSeverity()) {
                    case 3: 
                    case 4: {
                        this.setErrorMessage(highestSeverity.getMessage());
                        this.setPageComplete(false);
                        break;
                    }
                    case 2: {
                        this.setMessage(highestSeverity.getMessage(), 2);
                        break;
                    }
                    case 1: {
                        this.setMessage(highestSeverity.getMessage(), 1);
                    }
                }
            }
            return status;
        }

        protected boolean getBooleanSetting(String key, boolean defaultValue) {
            String update = this.getRefactoringSettings().get(key);
            if (update != null) {
                return Boolean.valueOf(update);
            }
            return defaultValue;
        }

        public void dispose() {
            IDialogSettings settings = this.getRefactoringSettings();
            settings.put(CREATE_GETTER_SETTER, ExtractClassWizard.this.fDescriptor.isCreateGetterSetter());
            settings.put(CREATE_TOP_LEVEL_SETTING, ExtractClassWizard.this.fDescriptor.isCreateTopLevel());
            super.dispose();
        }

        private abstract class FieldInfoEditingSupport
        extends EditingSupport {
            private CellEditor fTextEditor;

            private FieldInfoEditingSupport(CellEditor textEditor, ColumnViewer tv) {
                super(tv);
                this.fTextEditor = textEditor;
            }

            protected void setValue(Object element, Object value) {
                if (element instanceof ExtractClassDescriptor.Field) {
                    ExtractClassDescriptor.Field pi = (ExtractClassDescriptor.Field)element;
                    this.doSetValue(pi, value.toString());
                    this.getViewer().update(element, null);
                }
                ExtractClassUserInputWizardPage.this.validateRefactoring();
            }

            public abstract void doSetValue(ExtractClassDescriptor.Field var1, String var2);

            protected Object getValue(Object element) {
                if (element instanceof ExtractClassDescriptor.Field) {
                    ExtractClassDescriptor.Field pi = (ExtractClassDescriptor.Field)element;
                    return this.doGetValue(pi);
                }
                return null;
            }

            public abstract String doGetValue(ExtractClassDescriptor.Field var1);

            protected CellEditor getCellEditor(Object element) {
                return this.fTextEditor;
            }

            protected boolean canEdit(Object element) {
                if (element instanceof ExtractClassDescriptor.Field) {
                    return this.fTextEditor != null;
                }
                return false;
            }
        }

        private abstract class FieldInfoLabelProvider
        extends CellLabelProvider {
            private FieldInfoLabelProvider() {
            }

            public void update(ViewerCell cell) {
                ExtractClassDescriptor.Field pi = (ExtractClassDescriptor.Field)cell.getElement();
                cell.setText(this.doGetValue(pi));
            }

            protected abstract String doGetValue(ExtractClassDescriptor.Field var1);
        }
    }
}

