/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.browsing;

import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.CollapseAllAction;
import org.eclipse.jdt.internal.ui.browsing.JavaBrowsingPart;
import org.eclipse.jdt.internal.ui.browsing.LogicalPackage;
import org.eclipse.jdt.internal.ui.browsing.ProjectAndSourceFolderContentProvider;
import org.eclipse.jdt.internal.ui.viewsupport.FilterUpdater;
import org.eclipse.jdt.internal.ui.viewsupport.ProblemTreeViewer;
import org.eclipse.jdt.ui.actions.ProjectActionGroup;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.IShowInTargetList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectsView
extends JavaBrowsingPart {
    private FilterUpdater fFilterUpdater;
    private CollapseAllAction fCollapseAllAction;

    @Override
    protected StructuredViewer createViewer(Composite parent) {
        ProblemTreeViewer result = new ProblemTreeViewer(parent, 2);
        this.fFilterUpdater = new FilterUpdater(result);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.fFilterUpdater);
        return result;
    }

    @Override
    public void dispose() {
        if (this.fFilterUpdater != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.fFilterUpdater);
        }
        super.dispose();
    }

    @Override
    public <T> T getAdapter(Class<T> key) {
        if (key == IShowInTargetList.class) {
            return (T)new IShowInTargetList(){

                public String[] getShowInTargetIds() {
                    return new String[]{"org.eclipse.jdt.ui.PackageExplorer", "org.eclipse.ui.views.ResourceNavigator"};
                }
            };
        }
        return super.getAdapter(key);
    }

    @Override
    protected IContentProvider createContentProvider() {
        return new ProjectAndSourceFolderContentProvider(this);
    }

    @Override
    protected String getHelpContextId() {
        return "org.eclipse.jdt.ui.projects_view_context";
    }

    @Override
    protected String getLinkToEditorKey() {
        return "org.eclipse.jdt.ui.browsing.projectstoeditor";
    }

    @Override
    protected void hookViewerListeners() {
        super.hookViewerListeners();
        this.getViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object element;
                TreeViewer viewer = (TreeViewer)ProjectsView.this.getViewer();
                if (viewer.isExpandable(element = ((IStructuredSelection)event.getSelection()).getFirstElement())) {
                    viewer.setExpandedState(element, !viewer.getExpandedState(element));
                }
            }
        });
    }

    @Override
    protected void setInitialInput() {
        IJavaModel root = JavaCore.create((IWorkspaceRoot)JavaPlugin.getWorkspace().getRoot());
        this.getViewer().setInput((Object)root);
        this.updateTitle();
    }

    @Override
    protected boolean isValidInput(Object element) {
        return element instanceof IJavaModel;
    }

    @Override
    protected boolean isValidElement(Object element) {
        return element instanceof IJavaProject || element instanceof IPackageFragmentRoot;
    }

    @Override
    protected IJavaElement findElementToSelect(IJavaElement je) {
        if (je == null) {
            return null;
        }
        switch (je.getElementType()) {
            case 1: {
                return null;
            }
            case 2: {
                return je;
            }
            case 3: {
                if (je.getElementName().equals("")) {
                    return je.getParent();
                }
                return je;
            }
        }
        return this.findElementToSelect(je.getParent());
    }

    @Override
    protected void setInput(Object input) {
        if (input != null) {
            super.setInput(input);
        } else {
            this.getViewer().setSelection(null);
        }
    }

    @Override
    protected void createActions() {
        super.createActions();
        this.fActionGroups.addGroup(new ProjectActionGroup((IViewPart)this));
        this.fCollapseAllAction = new CollapseAllAction((TreeViewer)this.getViewer());
        this.fCollapseAllAction.setActionDefinitionId("org.eclipse.ui.navigate.collapseAll");
    }

    @Override
    protected void activateHandlers(IHandlerService handlerService) {
        super.activateHandlers(handlerService);
        handlerService.activateHandler("org.eclipse.ui.navigate.collapseAll", (IHandler)new ActionHandler((IAction)this.fCollapseAllAction));
    }

    @Override
    protected void fillToolBar(IToolBarManager tbm) {
        super.fillToolBar(tbm);
        tbm.add((IAction)this.fCollapseAllAction);
    }

    @Override
    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (!this.needsToProcessSelectionChanged(part)) {
            return;
        }
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection sel = (IStructuredSelection)selection;
            for (Object selectedElement : sel) {
                if (!(selectedElement instanceof LogicalPackage)) continue;
                selection = new StructuredSelection((Object)((LogicalPackage)((Object)selectedElement)).getJavaProject());
                break;
            }
        }
        super.selectionChanged(part, selection);
    }
}

