/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.swt.ui.components.massspectrum;

import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.swt.ui.internal.provider.IonListContentProvider;
import org.eclipse.chemclipse.msd.swt.ui.internal.provider.IonListLabelProvider;
import org.eclipse.chemclipse.msd.swt.ui.internal.provider.IonListTableComparator;
import org.eclipse.chemclipse.support.ui.swt.ExtendedTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Composite;

public class MassSpectrumIonsListUI
extends ExtendedTableViewer {
    private String[] titles = new String[]{"m/z", "abundance", "parent m/z", "parent resolution", "daughter m/z", "daughter resolution", "collision energy"};
    private int[] bounds = new int[]{100, 100, 120, 120, 120, 120, 120};

    public MassSpectrumIonsListUI(Composite parent) {
        super(parent);
        this.createColumns();
        this.addCopyToClipboardListener(this.titles);
    }

    public MassSpectrumIonsListUI(Composite parent, int style) {
        super(parent, style);
        this.createColumns();
        this.addCopyToClipboardListener(this.titles);
    }

    public void update(IScanMSD massSpectrum, boolean forceReload) {
        if (massSpectrum != null) {
            this.setInput(massSpectrum);
        }
    }

    public void clear() {
        this.setInput(null);
    }

    private void createColumns() {
        this.createColumns(this.titles, this.bounds);
        this.setLabelProvider((IBaseLabelProvider)new IonListLabelProvider());
        this.setContentProvider((IContentProvider)new IonListContentProvider());
        this.setComparator((ViewerComparator)new IonListTableComparator());
        this.setEditingSupport();
    }

    private void setEditingSupport() {
    }
}

