/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.swt.ui.components.massspectrum;

import java.util.List;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.core.IVendorMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.model.implementation.ScanMSD;
import org.eclipse.chemclipse.msd.swt.ui.internal.provider.IonListContentProvider;
import org.eclipse.chemclipse.msd.swt.ui.internal.provider.IonListLabelProvider;
import org.eclipse.chemclipse.msd.swt.ui.internal.provider.IonListTableComparator;
import org.eclipse.chemclipse.support.ui.swt.ExtendedTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class MassSpectrumCycleNumberIonsListUI {
    private ExtendedTableViewer tableViewer;
    private IonListTableComparator ionListTableComparator;
    private String[] titles = new String[]{"m/z", "abundance", "parent m/z", "parent resolution", "daughter m/z", "daughter resolution", "collision energy"};
    private int[] bounds = new int[]{100, 100, 120, 120, 120, 120, 120};

    public MassSpectrumCycleNumberIonsListUI(Composite parent, int style) {
        parent.setLayout((Layout)new FillLayout());
        this.tableViewer = new ExtendedTableViewer(parent, 66306);
        this.tableViewer.createColumns(this.titles, this.bounds);
        this.tableViewer.setContentProvider((IContentProvider)new IonListContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new IonListLabelProvider());
        this.ionListTableComparator = new IonListTableComparator();
        this.tableViewer.setComparator((ViewerComparator)this.ionListTableComparator);
        this.tableViewer.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 99 && e.stateMask == 262144) {
                    MassSpectrumCycleNumberIonsListUI.this.tableViewer.copyToClipboard(MassSpectrumCycleNumberIonsListUI.this.titles);
                }
            }
        });
    }

    public void setFocus() {
        this.tableViewer.getControl().setFocus();
    }

    public void update(IChromatogramSelectionMSD chromatogramSelection, boolean forceReload) {
        if (chromatogramSelection != null) {
            IVendorMassSpectrum massSpectrum = chromatogramSelection.getSelectedScan();
            IChromatogram chromatogram = chromatogramSelection.getChromatogram();
            if (chromatogram != null && massSpectrum != null) {
                int cycleNumber = massSpectrum.getCycleNumber();
                if (cycleNumber > 1) {
                    List scans = chromatogram.getScanCycleScans(cycleNumber);
                    ScanMSD massSpectrumCycleNumber = new ScanMSD();
                    for (IScan scan : scans) {
                        if (!(scan instanceof IScanMSD)) continue;
                        IScanMSD scanMSD = (IScanMSD)scan;
                        List ions = scanMSD.getIons();
                        for (IIon ion : ions) {
                            massSpectrumCycleNumber.addIon(ion, false);
                        }
                    }
                    this.tableViewer.setInput((Object)massSpectrumCycleNumber);
                } else {
                    this.tableViewer.setInput((Object)massSpectrum);
                }
            }
        }
    }

    public void clear() {
        this.tableViewer.setInput(null);
    }

    public ExtendedTableViewer getTableViewer() {
        return this.tableViewer;
    }

    public String[] getTitles() {
        return this.titles;
    }
}

