/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.swt.ui.components.massspectrum;

import java.text.DecimalFormat;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.identifier.ILibraryInformation;
import org.eclipse.chemclipse.msd.model.core.IRegularLibraryMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.xic.IExtractedIonSignal;
import org.eclipse.chemclipse.msd.swt.ui.components.massspectrum.MassValueDisplayPrecision;
import org.eclipse.chemclipse.msd.swt.ui.components.massspectrum.StackedMassSpectrumUI;
import org.eclipse.chemclipse.support.text.ValueFormat;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class LibraryMassSpectrumStackUI
extends Composite {
    private static final Logger logger = Logger.getLogger(LibraryMassSpectrumStackUI.class);
    private StackedMassSpectrumUI stackedMassSpectrumUnknown;
    private StackedMassSpectrumUI stackedMassSpectrumLibrary;
    private DecimalFormat decimalFormat = ValueFormat.getDecimalFormatEnglish((String)"0.000");
    private MassValueDisplayPrecision massValueDisplayPrecision;
    public static final int MAX_LENGTH_NAME = 20;

    public LibraryMassSpectrumStackUI(Composite parent, int style, MassValueDisplayPrecision massValueDisplayPrecision) {
        super(parent, style);
        this.massValueDisplayPrecision = massValueDisplayPrecision;
        this.initialize(parent);
    }

    private void initialize(Composite parent) {
        this.setLayout((Layout)new FillLayout());
        Composite composite = new Composite((Composite)this, 4);
        composite.setLayout((Layout)new FillLayout(512));
        this.stackedMassSpectrumUnknown = new StackedMassSpectrumUI(composite, 4, this.massValueDisplayPrecision);
        this.stackedMassSpectrumLibrary = new StackedMassSpectrumUI(composite, 4, this.massValueDisplayPrecision);
        this.stackedMassSpectrumUnknown.setOtherStackedMassSpectrumUI(this.stackedMassSpectrumLibrary);
        this.stackedMassSpectrumLibrary.setOtherStackedMassSpectrumUI(this.stackedMassSpectrumUnknown);
    }

    public void update(IScanMSD unknownMassSpectrum, IScanMSD libraryMassSpectrum, boolean forceReload) {
        if (unknownMassSpectrum != null && libraryMassSpectrum != null) {
            try {
                IScanMSD unknownMassSpectrumCopy = unknownMassSpectrum.makeDeepCopy().normalize(1000.0f);
                IScanMSD libraryMassSpectrumCopy = libraryMassSpectrum.makeDeepCopy().normalize(1000.0f);
                IExtractedIonSignal unknownMS = unknownMassSpectrumCopy.getExtractedIonSignal();
                IExtractedIonSignal libraryMS = libraryMassSpectrumCopy.getExtractedIonSignal();
                int startMZ = (unknownMS.getStartIon() < libraryMS.getStartIon() ? unknownMS.getStartIon() : libraryMS.getStartIon()) - 1;
                int stopMZ = (unknownMS.getStopIon() > libraryMS.getStopIon() ? unknownMS.getStopIon() : libraryMS.getStopIon()) + 1;
                this.stackedMassSpectrumUnknown.setFixedAxisRangeX(startMZ, stopMZ);
                this.stackedMassSpectrumLibrary.setFixedAxisRangeX(startMZ, stopMZ);
                this.setMassSpectrumLabel(unknownMassSpectrumCopy, libraryMassSpectrumCopy);
                this.stackedMassSpectrumUnknown.update(unknownMassSpectrumCopy, forceReload);
                this.stackedMassSpectrumLibrary.update(libraryMassSpectrumCopy, forceReload);
            }
            catch (CloneNotSupportedException e) {
                logger.warn((Object)e);
            }
        } else {
            this.stackedMassSpectrumUnknown.update(null, true);
            this.stackedMassSpectrumLibrary.update(null, true);
        }
    }

    private void setMassSpectrumLabel(IScanMSD unknownMassSpectrum, IScanMSD libraryMassSpectrum) {
        this.setMassSpectrumLabel(unknownMassSpectrum, "UNKNOWN MS = ", this.stackedMassSpectrumUnknown);
        this.setMassSpectrumLabel(libraryMassSpectrum, "LIBRARY MS = ", this.stackedMassSpectrumLibrary);
    }

    private void setMassSpectrumLabel(IScanMSD massSpectrum, String title, StackedMassSpectrumUI stackedMassSpectrumUI) {
        StringBuilder builder = new StringBuilder();
        builder.append("m/z [");
        builder.append(title);
        if (massSpectrum instanceof IRegularLibraryMassSpectrum) {
            IRegularLibraryMassSpectrum libraryMassSpectrum = (IRegularLibraryMassSpectrum)massSpectrum;
            ILibraryInformation libraryInformation = libraryMassSpectrum.getLibraryInformation();
            builder.append("NAME: ");
            String name = libraryInformation.getName();
            if (name.length() > 20) {
                builder.append(name.substring(0, 20));
                builder.append("...");
            } else {
                builder.append(name);
            }
        } else {
            builder.append("RT: ");
            builder.append(this.decimalFormat.format((double)massSpectrum.getRetentionTime() / 60000.0));
        }
        builder.append(" RI:");
        builder.append(Integer.toString((int)massSpectrum.getRetentionIndex()));
        builder.append("]");
        stackedMassSpectrumUI.setAxisTitle(1024, builder.toString());
    }
}

