/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.ui.internal.runnables.dialogs;

import java.text.DecimalFormat;
import java.text.ParseException;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.database.IQuantDatabase;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.database.controller.QuantitationCompoundEntryEdit;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.ui.internal.runnables.dialogs.AbstractEntryEditDialog;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.quantitation.CalibrationMethod;
import org.eclipse.chemclipse.model.quantitation.IRetentionIndexWindow;
import org.eclipse.chemclipse.model.quantitation.IRetentionTimeWindow;
import org.eclipse.chemclipse.msd.model.core.quantitation.IQuantitationCompoundMSD;
import org.eclipse.chemclipse.msd.model.implementation.QuantitationCompoundMSD;
import org.eclipse.chemclipse.support.text.ValueFormat;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class QuantitationCompoundEditDialog
extends AbstractEntryEditDialog {
    private static final Logger logger = Logger.getLogger(QuantitationCompoundEditDialog.class);
    private static final String KEY_NAME = "Name";
    private static final String KEY_CHEMICAL_CLASS = "Chemical Class";
    private static final String KEY_CONCENTRATION_UNIT = "Concentration Unit";
    private static final String KEY_CALIBRATION_METHOD = "Calibration Method";
    private static final String KEY_USE_CROSS_ZERO = "Cross Zero";
    private static final String KEY_USE_TIC = "TIC";
    private static final String KEY_RETENTION_TIME = "Retention Time (RT)";
    private static final String KEY_RT_NEGATIVE = "(RT) -";
    private static final String KEY_RT_POSITIVE = "(RT) +";
    private static final String KEY_RETENTION_INDEX = "Retention Index";
    private static final String KEY_RI_NEGATIVE = "(RI) -";
    private static final String KEY_RI_POSITIVE = "(RI) +";
    private QuantitationCompoundEntryEdit quantitationCompoundEntryEdit;
    private DecimalFormat decimalFormat;
    private IQuantDatabase database;
    private boolean isNewCompound;

    public QuantitationCompoundEditDialog(Shell parentShell, QuantitationCompoundEntryEdit quantitationCompoundEntryEdit, String title, IQuantDatabase database, boolean isNewCompound) {
        super(parentShell, title, isNewCompound ? "Create a quantitation compound." : "Edit a quantitation compound.");
        this.quantitationCompoundEntryEdit = quantitationCompoundEntryEdit;
        if (database != null) {
            this.database = database;
        } else {
            this.setErrorMessage("The selected database is not valid.");
        }
        this.isNewCompound = isNewCompound;
        this.decimalFormat = ValueFormat.getDecimalFormatEnglish();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            try {
                String name = this.getWidgetInput(KEY_NAME);
                String chemicalClass = this.getWidgetInput(KEY_CHEMICAL_CLASS);
                String concentrationUnit = this.getWidgetInput(KEY_CONCENTRATION_UNIT);
                CalibrationMethod calibrationMethod = CalibrationMethod.valueOf((String)this.getWidgetInput(KEY_CALIBRATION_METHOD));
                boolean useCrossZero = Boolean.parseBoolean(this.getWidgetInput(KEY_USE_CROSS_ZERO));
                boolean useTIC = Boolean.parseBoolean(this.getWidgetInput(KEY_USE_TIC));
                int retentionTime = (int)(this.decimalFormat.parse(this.getWidgetInput(KEY_RETENTION_TIME)).doubleValue() * 60000.0);
                float allowedNegativeDeviationRT = (int)(this.decimalFormat.parse(this.getWidgetInput(KEY_RT_NEGATIVE)).doubleValue() * 60000.0);
                float allowedPositiveDeviationRT = (int)(this.decimalFormat.parse(this.getWidgetInput(KEY_RT_POSITIVE)).doubleValue() * 60000.0);
                float retentionIndex = this.decimalFormat.parse(this.getWidgetInput(KEY_RETENTION_INDEX)).floatValue();
                float allowedNegativeDeviationRI = this.decimalFormat.parse(this.getWidgetInput(KEY_RI_NEGATIVE)).floatValue();
                float allowedPositiveDeviationRI = this.decimalFormat.parse(this.getWidgetInput(KEY_RI_POSITIVE)).floatValue();
                QuantitationCompoundMSD quantitationCompoundMSD = new QuantitationCompoundMSD(name, concentrationUnit, retentionTime);
                quantitationCompoundMSD.setUseTIC(useTIC);
                quantitationCompoundMSD.setCalibrationMethod(calibrationMethod);
                quantitationCompoundMSD.setUseCrossZero(useCrossZero);
                quantitationCompoundMSD.setChemicalClass(chemicalClass);
                IRetentionTimeWindow retentionTimeWindow = quantitationCompoundMSD.getRetentionTimeWindow();
                retentionTimeWindow.setRetentionTime(retentionTime);
                retentionTimeWindow.setAllowedNegativeDeviation(allowedNegativeDeviationRT);
                retentionTimeWindow.setAllowedPositiveDeviation(allowedPositiveDeviationRT);
                IRetentionIndexWindow retentionIndexWindow = quantitationCompoundMSD.getRetentionIndexWindow();
                retentionIndexWindow.setRetentionIndex(retentionIndex);
                retentionIndexWindow.setAllowedNegativeDeviation(allowedNegativeDeviationRI);
                retentionIndexWindow.setAllowedPositiveDeviation(allowedPositiveDeviationRI);
                this.quantitationCompoundEntryEdit.setQuantitationCompoundMSD((IQuantitationCompoundMSD)quantitationCompoundMSD);
            }
            catch (ParseException e) {
                this.setErrorMessage("A value can't be parsed.");
                logger.warn((Object)e);
            }
        }
        super.buttonPressed(buttonId);
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridData layoutData = new GridData(1796);
        layoutData.widthHint = this.convertHorizontalDLUsToPixels(300);
        String name = "";
        String chemicalClass = "";
        String concentrationUnit = "";
        String calibrationMethod = CalibrationMethod.LINEAR.toString();
        boolean useCrossZero = true;
        boolean useTIC = true;
        String retentionTime = "";
        String allowedNegativeDeviationRT = this.decimalFormat.format(0.025);
        String allowedPositiveDeviationRT = this.decimalFormat.format(0.025);
        String retentionIndex = this.decimalFormat.format(0L);
        String allowedNegativeDeviationRI = this.decimalFormat.format(5L);
        String allowedPositiveDeviationRI = this.decimalFormat.format(5L);
        IQuantitationCompoundMSD quantitationCompoundMSD = this.quantitationCompoundEntryEdit.getQuantitationCompoundMSD();
        if (quantitationCompoundMSD != null) {
            name = quantitationCompoundMSD.getName();
            chemicalClass = quantitationCompoundMSD.getChemicalClass();
            concentrationUnit = quantitationCompoundMSD.getConcentrationUnit();
            calibrationMethod = quantitationCompoundMSD.getCalibrationMethod().toString();
            useCrossZero = quantitationCompoundMSD.isCrossZero();
            useTIC = quantitationCompoundMSD.isUseTIC();
            retentionTime = this.decimalFormat.format((double)quantitationCompoundMSD.getRetentionTimeWindow().getRetentionTime() / 60000.0);
            allowedNegativeDeviationRT = this.decimalFormat.format((double)quantitationCompoundMSD.getRetentionTimeWindow().getAllowedNegativeDeviation() / 60000.0);
            allowedPositiveDeviationRT = this.decimalFormat.format((double)quantitationCompoundMSD.getRetentionTimeWindow().getAllowedPositiveDeviation() / 60000.0);
            retentionIndex = this.decimalFormat.format(quantitationCompoundMSD.getRetentionIndexWindow().getRetentionIndex());
            allowedNegativeDeviationRI = this.decimalFormat.format(quantitationCompoundMSD.getRetentionIndexWindow().getAllowedNegativeDeviation());
            allowedPositiveDeviationRI = this.decimalFormat.format(quantitationCompoundMSD.getRetentionIndexWindow().getAllowedPositiveDeviation());
        }
        this.createTextInput(composite, layoutData, KEY_NAME, "", name, this.isNewCompound);
        this.createTextInput(composite, layoutData, KEY_CHEMICAL_CLASS, "", chemicalClass, true);
        this.createTextInput(composite, layoutData, KEY_CONCENTRATION_UNIT, "", concentrationUnit, true);
        this.createEnumInput(composite, layoutData, KEY_CALIBRATION_METHOD, "", this.getCalibrationMethodItems(), calibrationMethod);
        this.createCheckInput(composite, layoutData, KEY_USE_CROSS_ZERO, "", useCrossZero);
        this.createCheckInput(composite, layoutData, KEY_USE_TIC, "", useTIC);
        this.createTextInput(composite, layoutData, KEY_RETENTION_TIME, "minutes", retentionTime, true);
        this.createTextInput(composite, layoutData, KEY_RT_NEGATIVE, "minutes", allowedNegativeDeviationRT, true);
        this.createTextInput(composite, layoutData, KEY_RT_POSITIVE, "minutes", allowedPositiveDeviationRT, true);
        this.createTextInput(composite, layoutData, KEY_RETENTION_INDEX, "", retentionIndex, true);
        this.createTextInput(composite, layoutData, KEY_RI_NEGATIVE, "", allowedNegativeDeviationRI, true);
        this.createTextInput(composite, layoutData, KEY_RI_POSITIVE, "", allowedPositiveDeviationRI, true);
        this.validateInput();
        return composite;
    }

    private String[] getCalibrationMethodItems() {
        CalibrationMethod[] calibrationMethods = CalibrationMethod.values();
        String[] items = new String[calibrationMethods.length];
        int counter = 0;
        CalibrationMethod[] calibrationMethodArray = calibrationMethods;
        int n = calibrationMethods.length;
        int n2 = 0;
        while (n2 < n) {
            CalibrationMethod calibrationMethod = calibrationMethodArray[n2];
            items[counter++] = calibrationMethod.toString();
            ++n2;
        }
        return items;
    }

    @Override
    protected boolean validateInput() {
        boolean isValid = super.validateInput();
        if (isValid) {
            float value;
            double value2;
            String name;
            if (this.database != null && this.isNewCompound && this.database.isQuantitationCompoundAlreadyAvailable(name = this.getWidgetInput(KEY_NAME))) {
                this.setErrorMessage("The compound is already available.");
                return false;
            }
            String concentrationUnit = this.getWidgetInput(KEY_CONCENTRATION_UNIT);
            if (concentrationUnit == null || concentrationUnit.equals("")) {
                this.setErrorMessage("The concentration unit is not valid.");
                return false;
            }
            try {
                double retentionTime = this.decimalFormat.parse(this.getWidgetInput(KEY_RETENTION_TIME)).doubleValue();
                if (retentionTime <= 0.0) {
                    this.setErrorMessage("Select a retention time > 0.");
                    return false;
                }
            }
            catch (ParseException parseException) {
                this.setErrorMessage("The retention time is not valid.");
                return false;
            }
            try {
                value2 = this.decimalFormat.parse(this.getWidgetInput(KEY_RT_NEGATIVE)).doubleValue();
                if (value2 < 0.0) {
                    this.setErrorMessage("Select an allowed negative retention time deviation >= 0.");
                    return false;
                }
            }
            catch (ParseException parseException) {
                this.setErrorMessage("The allowed negative retention time deviation is not valid.");
                return false;
            }
            try {
                value2 = this.decimalFormat.parse(this.getWidgetInput(KEY_RT_POSITIVE)).doubleValue();
                if (value2 < 0.0) {
                    this.setErrorMessage("Select an allowed positive retention time deviation >= 0.");
                    return false;
                }
            }
            catch (ParseException parseException) {
                this.setErrorMessage("The allowed positive retention time deviation is not valid.");
                return false;
            }
            try {
                float retentionIndex = this.decimalFormat.parse(this.getWidgetInput(KEY_RETENTION_INDEX)).floatValue();
                if (retentionIndex < 0.0f) {
                    this.setErrorMessage("Select a retention index >= 0.");
                    return false;
                }
            }
            catch (ParseException parseException) {
                this.setErrorMessage("The retention index is not valid.");
                return false;
            }
            try {
                value = this.decimalFormat.parse(this.getWidgetInput(KEY_RI_NEGATIVE)).floatValue();
                if (value < 0.0f) {
                    this.setErrorMessage("Select an allowed negative retention index deviation >= 0.");
                    return false;
                }
            }
            catch (ParseException parseException) {
                this.setErrorMessage("The allowed negative retention index deviation is not valid.");
                return false;
            }
            try {
                value = this.decimalFormat.parse(this.getWidgetInput(KEY_RI_POSITIVE)).floatValue();
                if (value < 0.0f) {
                    this.setErrorMessage("Select an allowed positive retention index deviation >= 0.");
                    return false;
                }
            }
            catch (ParseException parseException) {
                this.setErrorMessage("The allowed positive retention index deviation is not valid.");
                return false;
            }
        }
        return isValid;
    }
}

