/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.editors;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.DataInputEntry;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.IDataInputEntry;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.editors.PcaEditor;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.internal.wizards.BatchProcessWizardDialog;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.internal.wizards.PeakInputFilesWizard;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class InputFilesPage {
    private static final String FILES = "Input Files: ";
    private PcaEditor pcaEditor;
    private Table inputFilesTable;
    private Label countFiles;
    private List<IDataInputEntry> dataInputEntries;

    public InputFilesPage(PcaEditor pcaEditor, TabFolder tabFolder, FormToolkit formToolkit) {
        this.pcaEditor = pcaEditor;
        this.dataInputEntries = new ArrayList<IDataInputEntry>();
        this.initialize(tabFolder, formToolkit);
    }

    public List<IDataInputEntry> getDataInputEntries() {
        return this.dataInputEntries;
    }

    private void initialize(TabFolder tabFolder, FormToolkit formToolkit) {
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText("Data Input Files");
        Composite composite = new Composite((Composite)tabFolder, 0);
        composite.setLayout((Layout)new FillLayout());
        formToolkit = new FormToolkit(composite.getDisplay());
        ScrolledForm scrolledForm = formToolkit.createScrolledForm(composite);
        Composite scrolledFormComposite = scrolledForm.getBody();
        scrolledFormComposite.setLayout((Layout)new TableWrapLayout());
        scrolledForm.setText("Input File Editor");
        this.createInputFilesSection(scrolledFormComposite, formToolkit);
        tabItem.setControl((Control)composite);
    }

    private void createInputFilesSection(Composite parent, FormToolkit formToolkit) {
        Section section = formToolkit.createSection(parent, 384);
        section.setText("Input files");
        section.setDescription("Select the files to process. Use the add and remove buttons as needed. Click Run PCA to process the files. ");
        section.marginWidth = 5;
        section.marginHeight = 5;
        section.setLayoutData((Object)new TableWrapData(256));
        Composite client = formToolkit.createComposite((Composite)section, 64);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        client.setLayout((Layout)layout);
        GridData gridData = new GridData(768);
        gridData.horizontalIndent = 20;
        gridData.heightHint = 30;
        gridData.horizontalSpan = 2;
        Label label = formToolkit.createLabel(client, "");
        label.setLayoutData((Object)gridData);
        this.createTable(client, formToolkit);
        this.createButtons(client, formToolkit);
        this.createLabels(client, formToolkit);
        section.setClient((Control)client);
        formToolkit.paintBordersFor(client);
    }

    private void createTable(Composite client, FormToolkit formToolkit) {
        this.inputFilesTable = formToolkit.createTable(client, 2);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 400;
        gridData.widthHint = 100;
        gridData.verticalSpan = 5;
        this.inputFilesTable.setLayoutData((Object)gridData);
        this.inputFilesTable.setHeaderVisible(true);
        this.inputFilesTable.setLinesVisible(true);
    }

    private void createButtons(Composite client, FormToolkit formToolkit) {
        GridData gridData = new GridData(258);
        this.createAddButton(client, gridData, formToolkit);
        this.createRemoveButton(client, gridData, formToolkit);
        this.createProcessButton(client, gridData, formToolkit);
    }

    private void createAddButton(Composite client, GridData gridData, FormToolkit formToolkit) {
        Button add = formToolkit.createButton(client, "Add", 8);
        add.setLayoutData((Object)gridData);
        add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List<String> selectedPeakFiles;
                super.widgetSelected(e);
                PeakInputFilesWizard inputWizard = new PeakInputFilesWizard();
                BatchProcessWizardDialog wizardDialog = new BatchProcessWizardDialog(Display.getCurrent().getActiveShell(), (IWizard)inputWizard);
                wizardDialog.create();
                int returnCode = wizardDialog.open();
                if (returnCode == 0 && (selectedPeakFiles = inputWizard.getSelectedPeakFiles()).size() > 0) {
                    InputFilesPage.this.addEntries(selectedPeakFiles);
                    InputFilesPage.this.reloadInputFilesTable();
                }
            }
        });
    }

    private void createRemoveButton(Composite client, GridData gridData, FormToolkit formToolkit) {
        Button remove = formToolkit.createButton(client, "Remove", 8);
        remove.setLayoutData((Object)gridData);
        remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                InputFilesPage.this.removeEntries(InputFilesPage.this.inputFilesTable.getSelectionIndices());
            }
        });
    }

    private void createProcessButton(Composite client, GridData gridData, FormToolkit formToolkit) {
        Button process = formToolkit.createButton(client, "Run PCA", 8);
        process.setLayoutData((Object)gridData);
        process.setImage(ApplicationImageFactory.getInstance().getImage("execute.gif", "16x16"));
        process.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                InputFilesPage.this.pcaEditor.runPcaCalculation();
            }
        });
    }

    private void addEntries(List<String> selectedFiles) {
        for (String inputFile : selectedFiles) {
            DataInputEntry inputEntry = new DataInputEntry(inputFile);
            this.dataInputEntries.add((IDataInputEntry)inputEntry);
        }
    }

    private void removeEntries(int[] indices) {
        if (indices == null || indices.length == 0) {
            return;
        }
        this.inputFilesTable.remove(indices);
        int counter = 0;
        int[] nArray = indices;
        int n = indices.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            this.dataInputEntries.remove(index -= counter);
            ++counter;
            ++n2;
        }
        this.redrawCountFiles(this.dataInputEntries);
    }

    private void createLabels(Composite client, FormToolkit formToolkit) {
        this.countFiles = formToolkit.createLabel(client, "Input Files: 0", 0);
        GridData gridData = new GridData(256);
        gridData.horizontalSpan = 2;
        this.countFiles.setLayoutData((Object)gridData);
    }

    private void reloadInputFilesTable() {
        if (this.inputFilesTable != null) {
            this.inputFilesTable.removeAll();
            String[] titles = new String[]{"Filename", "Path"};
            int i = 0;
            while (i < titles.length) {
                TableColumn column = new TableColumn(this.inputFilesTable, 0);
                column.setText(titles[i]);
                ++i;
            }
            for (IDataInputEntry entry : this.dataInputEntries) {
                TableItem item = new TableItem(this.inputFilesTable, 0);
                item.setText(0, entry.getName());
                item.setText(1, entry.getInputFile());
            }
            i = 0;
            while (i < titles.length) {
                this.inputFilesTable.getColumn(i).pack();
                ++i;
            }
            this.redrawCountFiles(this.dataInputEntries);
        }
    }

    private void redrawCountFiles(List<IDataInputEntry> inputEntries) {
        this.countFiles.setText(FILES + Integer.toString(inputEntries.size()));
    }
}

