/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal;

import org.cloudfoundry.client.lib.domain.CloudSpace;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.spaces.CloudFoundrySpace;
import org.eclipse.cft.server.core.internal.spaces.CloudSpacesDescriptor;
import org.eclipse.cft.server.ui.internal.CloudSpacesDelegate;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.operation.IRunnableContext;

public class CloudServerSpacesDelegate
extends CloudSpacesDelegate {
    public CloudServerSpacesDelegate(CloudFoundryServer cloudServer) {
        super(cloudServer);
    }

    @Override
    protected CloudSpacesDescriptor internalUpdateDescriptor(String urlText, String userName, String password, boolean selfSigned, IRunnableContext context) throws CoreException {
        CloudSpacesDescriptor spacesDescriptor = super.internalUpdateDescriptor(urlText, userName, password, selfSigned, context);
        this.internalDescriptorChanged();
        return spacesDescriptor;
    }

    protected void internalDescriptorChanged() throws CoreException {
        if (this.getCurrentSpacesDescriptor() != null) {
            CloudSpace defaultCloudSpace = this.getSpaceWithNoServerInstance();
            this.setSelectedSpace(defaultCloudSpace);
        } else {
            this.setSelectedSpace(null);
        }
    }

    @Override
    public void setSelectedSpace(CloudSpace selectedCloudSpace) {
        if (this.hasSpaceChanged(selectedCloudSpace)) {
            this.getCloudServer().setSpace(selectedCloudSpace);
        }
    }

    protected boolean hasSpaceChanged(CloudSpace selectedCloudSpace) {
        CloudFoundrySpace existingSpace = this.getCloudServer().getCloudFoundrySpace();
        return !CloudServerSpacesDelegate.matchesSpace(selectedCloudSpace, existingSpace);
    }

    @Override
    public boolean hasSpace() {
        return this.getCloudServer().hasCloudSpace();
    }

    @Override
    public CloudSpace getCurrentCloudSpace() {
        return this.getCloudServer().getCloudFoundrySpace() != null ? this.getCloudServer().getCloudFoundrySpace().getSpace() : null;
    }
}

