/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal;

import java.util.List;
import org.cloudfoundry.client.lib.domain.CloudApplication;
import org.eclipse.cft.server.core.AbstractCloudFoundryUrl;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.CloudServerEvent;
import org.eclipse.cft.server.core.internal.CloudServerListener;
import org.eclipse.cft.server.core.internal.CloudServerUtil;
import org.eclipse.cft.server.core.internal.ServerEventHandler;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.cft.server.core.internal.spaces.CloudFoundrySpace;
import org.eclipse.cft.server.ui.internal.CloudFoundryImages;
import org.eclipse.cft.server.ui.internal.CloudFoundryServerUiPlugin;
import org.eclipse.cft.server.ui.internal.CloudServerUIUtil;
import org.eclipse.cft.server.ui.internal.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.ui.internal.view.servers.ModuleServer;

public class CloudFoundryDecorator
extends LabelProvider
implements ILightweightLabelDecorator {
    private final CloudServerListener listener = new CloudServerListener(){

        public void serverChanged(CloudServerEvent event) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    LabelProviderChangedEvent labelEvent = new LabelProviderChangedEvent((IBaseLabelProvider)CloudFoundryDecorator.this);
                    CloudFoundryDecorator.this.fireLabelProviderChanged(labelEvent);
                }
            });
        }
    };

    public CloudFoundryDecorator() {
        ServerEventHandler.getDefault().addServerListener(this.listener);
    }

    public void decorate(Object element, final IDecoration decoration) {
        CloudFoundryServer cfServer;
        Server server;
        if (element instanceof ModuleServer) {
            IModule[] modules;
            ModuleServer moduleServer = (ModuleServer)element;
            IServer s = moduleServer.getServer();
            if (s != null && CloudServerUtil.isCloudFoundryServer((IServer)s) && (modules = moduleServer.getModule()) != null && modules.length == 1) {
                CloudFoundryServer server2 = this.getCloudFoundryServer(moduleServer.getServer());
                if (server2 == null || !server2.isConnected()) {
                    return;
                }
                CloudFoundryApplicationModule module = server2.getExistingCloudModule(modules[0]);
                if (module == null) {
                    return;
                }
                module.getLocalModule();
                CloudApplication application = module.getApplication();
                if (application != null) {
                    String deployedAppName = application.getName();
                    IModule localModule = module.getLocalModule();
                    if (localModule != null && !localModule.getName().equals(deployedAppName)) {
                        decoration.addSuffix(NLS.bind((String)Messages.CloudFoundryDecorator_SUFFIX_DEPLOYED_AS, (Object)deployedAppName));
                    } else {
                        decoration.addSuffix(Messages.CloudFoundryDecorator_SUFFIX_DEPLOYED);
                    }
                } else {
                    decoration.addSuffix(Messages.CloudFoundryDecorator_SUFFIX_NOT_DEPLOYED);
                }
                if (module.getStatus() != null && !module.getStatus().isOK()) {
                    if (module.getStatus().getSeverity() == 4) {
                        decoration.addOverlay(CloudFoundryImages.OVERLAY_ERROR, 2);
                    } else if (module.getStatus().getSeverity() == 2) {
                        decoration.addOverlay(CloudFoundryImages.OVERLAY_WARNING, 2);
                    }
                }
            }
        } else if (element instanceof Server && CloudServerUtil.isCloudFoundryServer((IServer)(server = (Server)element)) && (cfServer = this.getCloudFoundryServer((IServer)server)) != null && cfServer.getUsername() != null) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    CloudFoundrySpace clSpace;
                    if (cfServer.hasCloudSpace() && (clSpace = cfServer.getCloudFoundrySpace()) != null) {
                        decoration.addSuffix(NLS.bind((String)" - {0} - {1}", (Object)clSpace.getOrgName(), (Object)clSpace.getSpaceName()));
                    }
                    try {
                        List<AbstractCloudFoundryUrl> cloudUrls = CloudServerUIUtil.getAllUrls(cfServer.getBehaviour().getServer().getServerType().getId(), null);
                        String url = cfServer.getUrl();
                        for (AbstractCloudFoundryUrl cloudUrl : cloudUrls) {
                            if (!cloudUrl.getUrl().equals(url)) continue;
                            decoration.addSuffix(NLS.bind((String)" - {0}", (Object)cloudUrl.getUrl()));
                            break;
                        }
                    }
                    catch (CoreException e) {
                        CloudFoundryServerUiPlugin.logError(e);
                    }
                }
            });
        }
    }

    public void dispose() {
        super.dispose();
        ServerEventHandler.getDefault().removeServerListener(this.listener);
    }

    private CloudFoundryServer getCloudFoundryServer(IServer server) {
        Object obj = server.getAdapter(CloudFoundryServer.class);
        if (obj instanceof CloudFoundryServer) {
            return (CloudFoundryServer)obj;
        }
        return null;
    }
}

