/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.client.v2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.cloudfoundry.client.lib.CloudFoundryException;
import org.cloudfoundry.client.lib.CloudFoundryOperations;
import org.cloudfoundry.client.lib.HttpProxyConfiguration;
import org.cloudfoundry.client.lib.domain.CloudApplication;
import org.cloudfoundry.client.lib.domain.CloudSpace;
import org.cloudfoundry.client.lib.util.CloudEntityResourceMapper;
import org.cloudfoundry.client.lib.util.JsonUtil;
import org.eclipse.cft.server.core.internal.client.v2.CfClientSideCart;
import org.eclipse.cft.server.core.internal.client.v2.CloudInfoV2;
import org.springframework.http.HttpStatus;

public class ExternalClientV1
extends CfClientSideCart {
    private CloudEntityResourceMapper resourceMapper = new CloudEntityResourceMapper();

    public ExternalClientV1(CloudFoundryOperations client, CloudSpace sessionSpace, CloudInfoV2 cloudInfo, boolean trustSelfSigned, HttpProxyConfiguration httpProxyConfiguration) {
        super(client, sessionSpace, cloudInfo, trustSelfSigned, httpProxyConfiguration);
    }

    public CloudApplication getApplicationNoRunningInstances(String appName) {
        Map<String, Object> resource = this.findApplicationResource(appName, true);
        if (resource == null) {
            throw new CloudFoundryException(HttpStatus.NOT_FOUND, "Not Found", "Application not found");
        }
        return this.mapCloudApplicationNoRunningInstances(resource);
    }

    public List<CloudApplication> getApplicationsNoRunningInstances() {
        ArrayList<CloudApplication> apps = new ArrayList<CloudApplication>();
        if (this.sessionSpace != null) {
            HashMap<String, Object> urlVars = new HashMap<String, Object>();
            String urlPath = "/v2";
            urlVars.put("space", this.sessionSpace.getMeta().getGuid());
            urlPath = String.valueOf(urlPath) + "/spaces/{space}";
            urlPath = String.valueOf(urlPath) + "/apps?inline-relations-depth=1";
            List<Map<String, Object>> resourceList = this.getAllResources(urlPath, urlVars);
            for (Map<String, Object> resource : resourceList) {
                this.processApplicationResource(resource, true);
                apps.add(this.mapCloudApplicationNoRunningInstances(resource));
            }
        }
        return apps;
    }

    public void stopApplication(String appName) {
        CloudApplication app = this.getApplicationNoRunningInstances(appName);
        if (app.getState() != CloudApplication.AppState.STOPPED) {
            HashMap<String, CloudApplication.AppState> appRequest = new HashMap<String, CloudApplication.AppState>();
            appRequest.put("state", CloudApplication.AppState.STOPPED);
            this.restTemplate.put(this.getUrl("/v2/apps/{guid}"), appRequest, new Object[]{app.getMeta().getGuid()});
        }
    }

    protected CloudApplication mapCloudApplicationNoRunningInstances(Map<String, Object> resource) {
        CloudApplication cloudApp = null;
        if (resource != null) {
            cloudApp = (CloudApplication)this.resourceMapper.mapResource(resource, CloudApplication.class);
            cloudApp.setUris(this.findApplicationUris(cloudApp.getMeta().getGuid()));
        }
        return cloudApp;
    }

    protected Map<String, Object> findApplicationResource(String appName, boolean fetchServiceInfo) {
        HashMap<String, Object> urlVars = new HashMap<String, Object>();
        String urlPath = "/v2";
        if (this.sessionSpace != null) {
            urlVars.put("space", this.sessionSpace.getMeta().getGuid());
            urlPath = String.valueOf(urlPath) + "/spaces/{space}";
        }
        urlVars.put("q", "name:" + appName);
        urlPath = String.valueOf(urlPath) + "/apps?inline-relations-depth=1&q={q}";
        List<Map<String, Object>> allResources = this.getAllResources(urlPath, urlVars);
        if (!allResources.isEmpty()) {
            return this.processApplicationResource(allResources.get(0), fetchServiceInfo);
        }
        return null;
    }

    protected Map<String, Object> processApplicationResource(Map<String, Object> resource, boolean fetchServiceInfo) {
        if (fetchServiceInfo) {
            this.fillInEmbeddedResource(resource, "service_bindings", "service_instance");
        }
        this.fillInEmbeddedResource(resource, "stack");
        return resource;
    }

    protected void fillInEmbeddedResource(Map<String, Object> resource, String ... resourcePath) {
        Object embeddedResource;
        if (resourcePath.length == 0) {
            return;
        }
        Map entity = (Map)resource.get("entity");
        String headKey = resourcePath[0];
        String[] tailPath = Arrays.copyOfRange(resourcePath, 1, resourcePath.length);
        if (!entity.containsKey(headKey)) {
            Map responseMap;
            String pathUrl = entity.get(String.valueOf(headKey) + "_url").toString();
            Object response = this.restTemplate.getForObject(this.getUrl(pathUrl), Object.class, new Object[0]);
            if (response instanceof Map && (responseMap = (Map)response).containsKey("resources")) {
                response = responseMap.get("resources");
            }
            entity.put(headKey, response);
        }
        if ((embeddedResource = entity.get(headKey)) instanceof Map) {
            Map embeddedResourceMap = (Map)embeddedResource;
            this.fillInEmbeddedResource(embeddedResourceMap, tailPath);
        } else if (embeddedResource instanceof List) {
            List embeddedResourcesList = (List)embeddedResource;
            for (Object r : embeddedResourcesList) {
                this.fillInEmbeddedResource((Map)r, tailPath);
            }
        } else {
            return;
        }
    }

    protected List<Map<String, Object>> getAllResources(String urlPath, Map<String, Object> urlVars) {
        ArrayList<Map<String, Object>> allResources = new ArrayList<Map<String, Object>>();
        String resp = urlVars != null ? (String)this.restTemplate.getForObject(this.getUrl(urlPath), String.class, urlVars) : (String)this.restTemplate.getForObject(this.getUrl(urlPath), String.class, new Object[0]);
        Map respMap = JsonUtil.convertJsonToMap((String)resp);
        List newResources = (List)respMap.get("resources");
        if (newResources != null && newResources.size() > 0) {
            allResources.addAll(newResources);
        }
        String nextUrl = (String)respMap.get("next_url");
        while (nextUrl != null && nextUrl.length() > 0) {
            nextUrl = this.addPageOfResources(nextUrl, allResources);
        }
        return allResources;
    }

    protected String addPageOfResources(String nextUrl, List<Map<String, Object>> allResources) {
        String resp = (String)this.restTemplate.getForObject(this.getUrl(nextUrl), String.class, new Object[0]);
        Map respMap = JsonUtil.convertJsonToMap((String)resp);
        List newResources = (List)respMap.get("resources");
        if (newResources != null && newResources.size() > 0) {
            allResources.addAll(newResources);
        }
        return (String)respMap.get("next_url");
    }

    protected List<String> findApplicationUris(UUID appGuid) {
        String urlPath = "/v2/apps/{app}/routes?inline-relations-depth=1";
        HashMap<String, Object> urlVars = new HashMap<String, Object>();
        urlVars.put("app", appGuid);
        List<Map<String, Object>> resourceList = this.getAllResources(urlPath, urlVars);
        ArrayList<String> uris = new ArrayList<String>();
        for (Map<String, Object> resource : resourceList) {
            Map domainResource = CloudEntityResourceMapper.getEmbeddedResource(resource, (String)"domain");
            String host = (String)CloudEntityResourceMapper.getEntityAttribute(resource, (String)"host", String.class);
            String domain = (String)CloudEntityResourceMapper.getEntityAttribute((Map)domainResource, (String)"name", String.class);
            if (host != null && host.length() > 0) {
                uris.add(String.valueOf(host) + "." + domain);
                continue;
            }
            uris.add(domain);
        }
        return uris;
    }
}

