/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.jrebel;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.cloudfoundry.client.lib.domain.CloudApplication;
import org.eclipse.cft.server.core.internal.CloudErrorUtil;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.CloudServerEvent;
import org.eclipse.cft.server.core.internal.CloudServerListener;
import org.eclipse.cft.server.core.internal.ExternalRestTemplate;
import org.eclipse.cft.server.core.internal.Messages;
import org.eclipse.cft.server.core.internal.application.ModuleChangeEvent;
import org.eclipse.cft.server.core.internal.client.AppUrlChangeEvent;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.osgi.framework.Bundle;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;

public abstract class CloudRebelAppHandler
implements CloudServerListener {
    private static final String ERROR_NO_APP = "No application module found. Application may no longer exist in the Cloud.";

    public abstract void register();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isRemotingAgentRunning(IModule module, CloudFoundryServer server, int eventType, IProgressMonitor monitor) {
        CloudFoundryApplicationModule appModule = null;
        try {
            CloudApplication cloudApp;
            appModule = server.getExistingCloudModule(module);
            int attempts = 40;
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(100 * (attempts + 1)));
            if (appModule == null) {
                appModule = server.getBehaviour().updateCloudModule(module, (IProgressMonitor)subMonitor.newChild(100));
            }
            CloudApplication cloudApplication = cloudApp = appModule != null ? appModule.getApplication() : null;
            if (cloudApp == null) {
                CloudFoundryPlugin.logError(ERROR_NO_APP);
                return false;
            }
            while (true) {
                if (attempts <= 0 || subMonitor.isCanceled()) {
                    if (subMonitor.isCanceled()) return false;
                    this.printErrorToConsole(appModule, server, Messages.CloudRebelAppHandler_TIME_OUT_RESOLVING_REMOTING_AGENT);
                    CloudFoundryPlugin.logError(Messages.CloudRebelAppHandler_TIME_OUT_RESOLVING_REMOTING_AGENT);
                    return false;
                }
                if (this.findRemotingAgent(appModule, server)) {
                    return true;
                }
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException interruptedException) {}
                appModule = server.getBehaviour().updateCloudModule(module, (IProgressMonitor)subMonitor.newChild(100));
                --attempts;
            }
        }
        catch (CoreException e) {
            this.printErrorToConsole(appModule, server, NLS.bind((String)Messages.CloudRebelAppHandler_ERROR, (Object)e.getMessage()));
            CloudFoundryPlugin.logError(e);
        }
        return false;
    }

    protected boolean findRemotingAgent(CloudFoundryApplicationModule appModule, CloudFoundryServer cloudServer) throws CoreException {
        block5: {
            if (appModule == null) {
                throw CloudErrorUtil.toCoreException(ERROR_NO_APP);
            }
            if (appModule.getDeploymentInfo() == null) {
                return false;
            }
            List<String> urls = appModule.getDeploymentInfo().getUris();
            try {
                String url;
                String string = url = urls != null && !urls.isEmpty() ? "http://" + urls.get(0) + "/app" : null;
                if (url != null) {
                    HttpHeaders headers = new HttpHeaders();
                    headers.set("x-rebel-id", "random");
                    HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
                    ResponseEntity responseEntity = new ExternalRestTemplate().exchange(url, HttpMethod.POST, requestEntity, String.class, new Object[0]);
                    return responseEntity != null && responseEntity.getHeaders() != null && responseEntity.getHeaders().containsKey((Object)"x-rebel-response");
                }
            }
            catch (RestClientException e) {
                if (CloudErrorUtil.isNotFoundException(e)) break block5;
                throw CloudErrorUtil.toCoreException(e);
            }
        }
        return false;
    }

    @Override
    public void serverChanged(CloudServerEvent event) {
        if (event.getServer() != null && (event.getType() == 700 || this.shouldReplaceRemotingUrl(event.getType()))) {
            ModuleChangeEvent moduleEvent;
            IModule module;
            ArrayList<IModule> modules = new ArrayList<IModule>();
            if (event instanceof ModuleChangeEvent && (module = (moduleEvent = (ModuleChangeEvent)event).getModule()) != null) {
                modules.add(module);
            }
            if (!modules.isEmpty()) {
                this.updateModulesWithRebelProjects(modules, event);
            }
        }
    }

    protected void updateModulesWithRebelProjects(List<IModule> modules, CloudServerEvent event) {
        Iterator<IModule> iterator = modules.iterator();
        while (iterator.hasNext()) {
            IModule module;
            final IModule mod = module = iterator.next();
            final CloudServerEvent moduleEvent = event;
            if (!CloudRebelAppHandler.isJRebelEnabled(module)) continue;
            Job job = new Job(NLS.bind((String)Messages.CloudRebelAppHandler_UPDATING_JREBEL_REMOTING, (Object)module.getName())){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        CloudRebelAppHandler.this.handleRebelProject(moduleEvent, mod, monitor);
                    }
                    catch (CoreException e) {
                        CloudFoundryPlugin.logError(e);
                        return e.getStatus();
                    }
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
    }

    protected void handleRebelProject(CloudServerEvent event, IModule module, IProgressMonitor monitor) throws CoreException {
        CloudFoundryServer cloudServer = event.getServer();
        CloudFoundryApplicationModule cloudAppModule = cloudServer.getExistingCloudModule(module);
        int eventType = event.getType();
        List<String> oldUrls = null;
        List<String> currentUrls = null;
        if (event instanceof AppUrlChangeEvent) {
            AppUrlChangeEvent appUrlEvent = (AppUrlChangeEvent)event;
            oldUrls = appUrlEvent.getOldUrls();
            currentUrls = appUrlEvent.getCurrentUrls();
        } else if (cloudAppModule != null && cloudAppModule.getDeploymentInfo() != null) {
            currentUrls = cloudAppModule.getDeploymentInfo().getUris();
        }
        this.updateJRebelRemoting(cloudServer, eventType, module, oldUrls, currentUrls, monitor);
    }

    protected void updateJRebelRemoting(CloudFoundryServer cloudServer, int cloudEventType, IModule module, List<String> oldUrls, List<String> currentUrls, IProgressMonitor monitor) throws CoreException {
        Bundle bundle = CloudRebelAppHandler.getJRebelBundle();
        if (bundle != null) {
            Exception error;
            block29: {
                error = null;
                try {
                    Object authority;
                    int n;
                    Class providerClass = bundle.loadClass("org.zeroturnaround.eclipse.jrebel.remoting.RebelRemotingProvider");
                    if (providerClass == null) break block29;
                    CloudFoundryApplicationModule appModule = cloudServer.getExistingCloudModule(module);
                    Method getRemotingProject = providerClass.getMethod("getRemotingProject", IProject.class);
                    if (getRemotingProject == null) break block29;
                    getRemotingProject.setAccessible(true);
                    IProject project = module.getProject();
                    Object remoteProjectObj = getRemotingProject.invoke(null, project);
                    if (remoteProjectObj == null || !remoteProjectObj.getClass().getName().equals("org.zeroturnaround.eclipse.jrebel.remoting.RemotingProject")) break block29;
                    URL[] existingRebelUrls = null;
                    Method getUrls = remoteProjectObj.getClass().getMethod("getRemoteUrls", new Class[0]);
                    if (getUrls != null) {
                        getUrls.setAccessible(true);
                        Object urlList = getUrls.invoke(remoteProjectObj, new Object[0]);
                        if (urlList instanceof URL[]) {
                            existingRebelUrls = (URL[])urlList;
                        }
                    }
                    if (existingRebelUrls == null) {
                        existingRebelUrls = new URL[]{};
                    }
                    ArrayList<String> currentAppUrls = new ArrayList<String>();
                    ArrayList<String> oldAppUrls = new ArrayList<String>();
                    if (currentUrls != null) {
                        currentAppUrls.addAll(currentUrls);
                    }
                    if (oldUrls != null) {
                        oldAppUrls.addAll(oldUrls);
                    }
                    ArrayList<URL> updatedRebelUrls = new ArrayList<URL>();
                    boolean replace = false;
                    if (this.shouldReplaceRemotingUrl(cloudEventType)) {
                        URL[] uRLArray = existingRebelUrls;
                        n = existingRebelUrls.length;
                        int n2 = 0;
                        while (n2 < n) {
                            URL rebelUrl = uRLArray[n2];
                            authority = rebelUrl.getAuthority();
                            if (oldAppUrls.contains(authority)) {
                                replace = true;
                                break;
                            }
                            ++n2;
                        }
                    }
                    if (!replace && cloudEventType != 700) break block29;
                    if (!currentAppUrls.isEmpty()) {
                        boolean changed = false;
                        authority = existingRebelUrls;
                        int n3 = existingRebelUrls.length;
                        n = 0;
                        while (n < n3) {
                            URL rebelUrl = authority[n];
                            String authority2 = rebelUrl.getAuthority();
                            if (oldAppUrls.contains(authority2) && !currentAppUrls.contains(authority2)) {
                                changed = true;
                            } else {
                                updatedRebelUrls.add(rebelUrl);
                            }
                            ++n;
                        }
                        String urlToAdd = (String)currentAppUrls.get(0);
                        for (URL updatedRebelUrl : updatedRebelUrls) {
                            String updatedRebelAuthority = updatedRebelUrl.getAuthority();
                            if (!currentAppUrls.contains(updatedRebelAuthority)) continue;
                            urlToAdd = null;
                            break;
                        }
                        if (urlToAdd != null) {
                            if (!urlToAdd.startsWith("http://") && !urlToAdd.startsWith("https://")) {
                                urlToAdd = "http://" + urlToAdd;
                            }
                            try {
                                URL toAdd = new URL(urlToAdd);
                                updatedRebelUrls.add(toAdd);
                                changed = true;
                            }
                            catch (MalformedURLException e) {
                                throw CloudErrorUtil.toCoreException(e);
                            }
                        }
                        if (changed) {
                            Method setRebelRemotingUrls = remoteProjectObj.getClass().getDeclaredMethod("setRemoteUrls", URL[].class);
                            if (setRebelRemotingUrls != null) {
                                setRebelRemotingUrls.setAccessible(true);
                                setRebelRemotingUrls.invoke(remoteProjectObj, new Object[]{updatedRebelUrls.toArray(new URL[0])});
                                this.printToConsole(appModule, cloudServer, NLS.bind((String)Messages.CloudRebelAppHandler_UPDATED_URL, updatedRebelUrls));
                            }
                        } else {
                            this.printToConsole(appModule, cloudServer, Messages.CloudRebelAppHandler_UP_TO_DATE);
                        }
                        break block29;
                    }
                    throw CloudErrorUtil.toCoreException("No Cloud application deployment URL found for " + module.getName() + ". Unable to automatically set a deployment URL in JRebel remoting.");
                }
                catch (ClassNotFoundException e) {
                    error = e;
                }
                catch (SecurityException e) {
                    error = e;
                }
                catch (NoSuchMethodException e) {
                    error = e;
                }
                catch (IllegalAccessException e) {
                    error = e;
                }
                catch (InvocationTargetException e) {
                    error = e;
                }
                catch (IllegalArgumentException e) {
                    error = e;
                }
            }
            if (error != null) {
                throw CloudErrorUtil.toCoreException(error);
            }
        }
    }

    protected boolean shouldReplaceRemotingUrl(int eventType) {
        return eventType == 430;
    }

    protected void printToConsole(CloudFoundryApplicationModule appModule, CloudFoundryServer server, String message) {
        this.printToConsole(appModule, server, message, false);
    }

    protected void printErrorToConsole(CloudFoundryApplicationModule appModule, CloudFoundryServer server, String message) {
        this.printToConsole(appModule, server, message, true);
    }

    protected void printToConsole(CloudFoundryApplicationModule appModule, CloudFoundryServer server, String message, boolean error) {
        if (appModule != null && server != null) {
            message = String.valueOf(Messages.CloudRebelAppHandler_MESSAGE_PREFIX) + " - " + message + '\n';
            CloudFoundryPlugin.getCallback().printToConsole(server, appModule, message, false, error);
        }
    }

    public static boolean isJRebelEnabled(IModule module) {
        IProject project = module != null ? module.getProject() : null;
        try {
            return project != null && project.isAccessible() && project.hasNature("org.zeroturnaround.eclipse.remoting.remotingNature") && project.hasNature("org.zeroturnaround.eclipse.jrebelNature");
        }
        catch (CoreException e) {
            CloudFoundryPlugin.logError(e);
            return false;
        }
    }

    public static Bundle getJRebelBundle() {
        Bundle bundle = null;
        try {
            bundle = Platform.getBundle((String)"org.zeroturnaround.eclipse.remoting");
        }
        catch (Throwable e) {
            CloudFoundryPlugin.logError(e);
        }
        return bundle;
    }

    public static boolean isJRebelIDEInstalled() {
        return CloudRebelAppHandler.getJRebelBundle() != null;
    }
}

