/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.cloudfoundry.client.lib.archive.ApplicationArchive;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudUtil;
import org.eclipse.cft.server.core.internal.DeployedResourceCache;
import org.eclipse.cft.server.core.internal.application.AbstractModuleResourceArchive;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.model.IModuleFile;
import org.eclipse.wst.server.core.model.IModuleFolder;
import org.eclipse.wst.server.core.model.IModuleResource;

public class CachingApplicationArchive
extends AbstractModuleResourceArchive {
    private final Set<String> changedResources;
    private String fileName;
    private final DeployedResourceCache.CachedDeployedApplication appID;

    public CachingApplicationArchive(List<IModuleResource> allResources, List<IModuleResource> changedResources, IModule module, String appName) {
        super(module, allResources);
        this.appID = new DeployedResourceCache.CachedDeployedApplication(appName);
        this.changedResources = this.changedResourcesAsZipNames(changedResources);
    }

    protected Set<String> changedResourcesAsZipNames(List<IModuleResource> changedResources) {
        HashSet<String> names = new HashSet<String>();
        for (IModuleResource resource : changedResources) {
            names.add(CloudUtil.getZipRelativeName(resource));
        }
        return names;
    }

    public String getFilename() {
        return this.fileName;
    }

    @Override
    protected AbstractModuleResourceArchive.ModuleFolderEntryAdapter getModuleFolderAdapter(IModuleFolder folder) {
        return new ZipModuleFolderEntryAdapter(folder);
    }

    @Override
    protected AbstractModuleResourceArchive.ModuleFileEntryAdapter getFileResourceEntryAdapter(IModuleFile file) {
        String zipName = CloudUtil.getZipRelativeName((IModuleResource)file);
        boolean changed = this.changedResources != null && this.changedResources.contains(zipName);
        return new ZipModuleFileEntryAdapter(file, this.appID, changed);
    }

    public void generatePartialWarFile(Set<String> knownResourceNames) {
        Iterable<ApplicationArchive.Entry> localEntries = this.getEntries();
        HashMap<String, AbstractModuleResourceArchive.AbstractModuleResourceEntryAdapter> missingChangedEntries = new HashMap<String, AbstractModuleResourceArchive.AbstractModuleResourceEntryAdapter>();
        HashSet<IModuleResource> missingChangedResources = new HashSet<IModuleResource>();
        for (ApplicationArchive.Entry entry : localEntries) {
            if (!entry.isDirectory() && knownResourceNames.contains(entry.getName())) continue;
            missingChangedEntries.put(entry.getName(), (AbstractModuleResourceArchive.AbstractModuleResourceEntryAdapter)entry);
            missingChangedResources.add(((AbstractModuleResourceArchive.AbstractModuleResourceEntryAdapter)entry).getResource());
        }
        try {
            File partialWar = CloudUtil.createWarFile(this.getModuleResources(), this.getModule(), missingChangedResources, null);
            if (partialWar.exists()) {
                this.fileName = partialWar.getName();
                ZipFile zipPartialWar = new ZipFile(partialWar);
                Enumeration<? extends ZipEntry> zipEntries = zipPartialWar.entries();
                ArrayList<PartialZipEntryAdapter> toDeploy = new ArrayList<PartialZipEntryAdapter>();
                while (zipEntries.hasMoreElements()) {
                    ZipEntry zipEntry = zipEntries.nextElement();
                    AbstractModuleResourceArchive.AbstractModuleResourceEntryAdapter archiveEntry = (AbstractModuleResourceArchive.AbstractModuleResourceEntryAdapter)((Object)missingChangedEntries.get(zipEntry.getName()));
                    if (archiveEntry == null) continue;
                    DeployedResourceCache.DeployedResourceEntry deployedResourcesEntry = archiveEntry instanceof ZipModuleFileEntryAdapter ? ((ZipModuleFileEntryAdapter)archiveEntry).getDeployedResourcesEntry() : null;
                    toDeploy.add(new PartialZipEntryAdapter(deployedResourcesEntry, zipEntry, zipPartialWar));
                }
                this.entries = toDeploy;
            }
        }
        catch (CoreException e) {
            CloudFoundryPlugin.log(e);
        }
        catch (ZipException e) {
            CloudFoundryPlugin.logError(e);
        }
        catch (IOException e) {
            CloudFoundryPlugin.logError(e);
        }
    }

    public class PartialZipEntryAdapter
    implements ApplicationArchive.Entry {
        private final DeployedResourceCache.DeployedResourceEntry deployedResourcesEntry;
        private final ZipEntry zipEntry;
        private final ZipFile zipFile;

        public PartialZipEntryAdapter(DeployedResourceCache.DeployedResourceEntry deployedResourcesEntry, ZipEntry zipEntry, ZipFile zipFile) {
            this.zipFile = zipFile;
            this.zipEntry = zipEntry;
            this.deployedResourcesEntry = deployedResourcesEntry;
        }

        public boolean isDirectory() {
            return this.zipEntry.isDirectory();
        }

        public String getName() {
            return this.zipEntry.getName();
        }

        protected DeployedResourceCache.DeployedResourceEntry getDeployedResourceEntry() {
            return this.deployedResourcesEntry;
        }

        public long getSize() {
            return this.getDeployedResourceEntry() != null ? this.getDeployedResourceEntry().getFileSize() : -1L;
        }

        public byte[] getSha1Digest() {
            return this.getDeployedResourceEntry() != null ? this.getDeployedResourceEntry().getSha1() : null;
        }

        public InputStream getInputStream() throws IOException {
            if (this.isDirectory()) {
                return null;
            }
            return this.zipFile.getInputStream(this.zipEntry);
        }
    }

    public class ZipModuleFileEntryAdapter
    extends AbstractModuleResourceArchive.ModuleFileEntryAdapter {
        private final DeployedResourceCache.CachedDeployedApplication appName;
        private final boolean recalculate;

        public ZipModuleFileEntryAdapter(IModuleFile moduleFile, DeployedResourceCache.CachedDeployedApplication appName, boolean recalculate) {
            super((AbstractModuleResourceArchive)CachingApplicationArchive.this, moduleFile);
            this.appName = appName;
            this.recalculate = recalculate;
        }

        public long getSize() {
            DeployedResourceCache.DeployedResourceEntry entry = this.getDeployedResourcesEntry();
            return entry != null ? entry.getFileSize() : -1L;
        }

        public DeployedResourceCache.DeployedResourceEntry getDeployedResourcesEntry() {
            DeployedResourceCache.DeployedResourceEntry deployedResourcesEntry = CloudFoundryPlugin.getDefault().getDeployedResourcesCache().getEntry(this.appName, this.getName());
            if (this.canComputeResourceEntry() && (this.recalculate || deployedResourcesEntry == null)) {
                byte[] sha1 = super.getSha1Digest();
                long fileSize = super.getSize();
                deployedResourcesEntry = new DeployedResourceCache.DeployedResourceEntry(sha1, fileSize, this.getName());
                CloudFoundryPlugin.getDefault().getDeployedResourcesCache().add(this.appName, deployedResourcesEntry);
            }
            return deployedResourcesEntry;
        }

        public byte[] getSha1Digest() {
            DeployedResourceCache.DeployedResourceEntry entry = this.getDeployedResourcesEntry();
            return entry != null ? entry.getSha1() : null;
        }

        @Override
        protected String computeName(IModuleResource resource) {
            return CloudUtil.getZipRelativeName(resource);
        }
    }

    public class ZipModuleFolderEntryAdapter
    extends AbstractModuleResourceArchive.ModuleFolderEntryAdapter {
        public ZipModuleFolderEntryAdapter(IModuleFolder moduleResource) {
            super((AbstractModuleResourceArchive)CachingApplicationArchive.this, moduleResource);
        }

        @Override
        protected String computeName(IModuleResource resource) {
            return CloudUtil.getZipRelativeName(resource);
        }
    }
}

