/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.cloudfoundry.client.lib.domain.ApplicationStats;
import org.cloudfoundry.client.lib.domain.CloudApplication;
import org.cloudfoundry.client.lib.domain.CloudService;
import org.cloudfoundry.client.lib.domain.InstanceInfo;
import org.cloudfoundry.client.lib.domain.InstanceStats;
import org.cloudfoundry.client.lib.domain.InstancesInfo;
import org.eclipse.cft.server.core.internal.ApplicationAction;
import org.eclipse.cft.server.core.internal.CloudErrorUtil;
import org.eclipse.cft.server.core.internal.CloudFoundryBrandingExtensionPoint;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.CloudServerEvent;
import org.eclipse.cft.server.core.internal.ServerEventHandler;
import org.eclipse.cft.server.core.internal.application.ManifestParser;
import org.eclipse.cft.server.core.internal.application.ModuleChangeEvent;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.cft.server.core.internal.client.CloudFoundryServerBehaviour;
import org.eclipse.cft.server.core.internal.client.DeploymentInfoWorkingCopy;
import org.eclipse.cft.server.core.internal.debug.ApplicationDebugLauncher;
import org.eclipse.cft.server.core.internal.debug.CloudFoundryProperties;
import org.eclipse.cft.server.core.internal.debug.DebugOperationType;
import org.eclipse.cft.server.core.internal.jrebel.CloudRebelAppHandler;
import org.eclipse.cft.server.rse.internal.ConfigureRemoteCloudFoundryAction;
import org.eclipse.cft.server.ui.internal.CloudFoundryImages;
import org.eclipse.cft.server.ui.internal.CloudUiUtil;
import org.eclipse.cft.server.ui.internal.Messages;
import org.eclipse.cft.server.ui.internal.actions.DebugApplicationEditorAction;
import org.eclipse.cft.server.ui.internal.actions.EditorAction;
import org.eclipse.cft.server.ui.internal.actions.RemoveServicesFromApplicationAction;
import org.eclipse.cft.server.ui.internal.actions.ShowConsoleEditorAction;
import org.eclipse.cft.server.ui.internal.actions.StartStopApplicationAction;
import org.eclipse.cft.server.ui.internal.actions.TerminateDebugEditorAction;
import org.eclipse.cft.server.ui.internal.actions.UpdateApplicationMemoryAction;
import org.eclipse.cft.server.ui.internal.actions.UpdateInstanceCountAction;
import org.eclipse.cft.server.ui.internal.editor.AppStatsContentProvider;
import org.eclipse.cft.server.ui.internal.editor.AppStatsLabelProvider;
import org.eclipse.cft.server.ui.internal.editor.ApplicationInstanceServiceColumn;
import org.eclipse.cft.server.ui.internal.editor.CloudFoundryApplicationsEditorPage;
import org.eclipse.cft.server.ui.internal.editor.CloudFoundryViewerSorter;
import org.eclipse.cft.server.ui.internal.editor.ServicesLabelProvider;
import org.eclipse.cft.server.ui.internal.editor.ServicesViewerDropListener;
import org.eclipse.cft.server.ui.internal.editor.TreeContentProvider;
import org.eclipse.cft.server.ui.internal.wizards.EnvVarsWizard;
import org.eclipse.cft.server.ui.internal.wizards.MappedURLsWizard;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.RowLayoutFactory;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.internal.progress.ProgressManager;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.ui.internal.ImageResource;

public class ApplicationDetailsPart
extends AbstractFormPart
implements IDetailsPage {
    private boolean canUpdate;
    private final CloudFoundryServer cloudServer;
    private final CloudFoundryApplicationsEditorPage editorPage;
    private Section generalSection;
    private Section generalSectionRestartRequired;
    private Section operationsSection;
    private AppStatsContentProvider instancesContentProvider;
    private Spinner instanceSpinner;
    private Section instancesSection;
    private TableViewer instancesViewer;
    private Link mappedURIsLink;
    private IModule module;
    private Button startAppButton;
    private Button updateRestartAppButton;
    private final CloudFoundryServerBehaviour serverBehaviour;
    private Text serverNameText;
    private TreeContentProvider servicesContentProvider;
    private ServicesViewerDropListener servicesDropListener;
    private Section servicesSection;
    private TableViewer servicesViewer;
    private Button pushAppButton;
    private Button debugButton;
    private Button stopAppButton;
    private Button saveManifest;
    private Button jrebelManualAppUrlUpdate;
    private Text memoryText;
    private Composite topButtonRow;
    private Composite lowerButtonRow;
    private FormToolkit toolkit;
    private List<String> appUrls;
    private final boolean provideServices;
    private ApplicationDebugLauncher debugLauncher;
    private boolean isPublished = false;
    private boolean initialTableResized = false;
    protected boolean skipButtonRefreshOnRestart;

    public ApplicationDetailsPart(CloudFoundryApplicationsEditorPage editorPage, CloudFoundryServer cloudServer) {
        this.editorPage = editorPage;
        this.cloudServer = cloudServer;
        this.serverBehaviour = cloudServer.getBehaviour();
        this.provideServices = CloudFoundryBrandingExtensionPoint.getProvideServices((String)editorPage.getServer().getServerType().getId());
        this.debugLauncher = this.serverBehaviour.getDebugLauncher();
    }

    public void createContents(Composite parent) {
        this.toolkit = this.getManagedForm().getToolkit();
        parent.setLayout((Layout)new GridLayout());
        this.createGeneralSection(parent);
        this.createGeneralSectionRestartRequired(parent);
        this.createApplicationOperationsSection(parent);
        if (this.provideServices) {
            this.createServicesSection(parent);
            this.servicesDropListener = new ServicesViewerDropListener((Viewer)this.servicesViewer, this.serverBehaviour, this.editorPage);
        }
        this.createInstancesSection(parent);
        if (this.provideServices) {
            this.addDropSupport(this.generalSection);
            this.addDropSupport(this.generalSectionRestartRequired);
            this.addDropSupport(this.operationsSection);
            this.addDropSupport(this.servicesSection);
            this.addDropSupport(this.instancesSection);
        }
    }

    protected int getSelectedAppInstance() {
        return 0;
    }

    public void refreshDebugControls(CloudFoundryApplicationModule appModule) {
        if (this.debugButton == null || this.debugButton.isDisposed()) {
            return;
        }
        int appInstance = this.getSelectedAppInstance();
        if (!this.debugLauncher.supportsDebug(appModule, this.cloudServer) || this.debugLauncher.isConnectedToDebugger(appModule, this.cloudServer, appInstance)) {
            this.debugButton.setEnabled(false);
            this.debugButton.setText(Messages.ApplicationDetailsPart_TEXT_DEBUG);
        } else {
            this.debugButton.setEnabled(true);
            this.debugButton.setText(Messages.ApplicationDetailsPart_TEXT_DEBUG);
            this.debugButton.setData((Object)DebugOperationType.Debug);
        }
        this.debugButton.getParent().layout(true);
    }

    protected void refreshDeploymentButtons(CloudFoundryApplicationModule appModule) {
        if (this.topButtonRow == null || this.lowerButtonRow == null || this.lowerButtonRow.isDisposed() || this.topButtonRow.isDisposed()) {
            return;
        }
        int state = appModule.getState();
        if (this.skipButtonRefreshOnRestart) {
            this.skipButtonRefreshOnRestart = false;
            return;
        }
        if (state == 4 || state == 0) {
            this.stopAppButton.setEnabled(false);
            this.startAppButton.setText(Messages.ApplicationDetailsPart_TEXT_START);
            this.startAppButton.setImage(ImageResource.getImage((String)"IMG_CLCL_START"));
            this.startAppButton.setToolTipText(Messages.ApplicationDetailsPart_TEXT_START_TOOLTIP);
        } else {
            this.stopAppButton.setEnabled(true);
            this.startAppButton.setText(Messages.ApplicationDetailsPart_TEXT_RESTART);
            this.startAppButton.setImage(CloudFoundryImages.getImage(CloudFoundryImages.RESTART));
            this.startAppButton.setToolTipText(Messages.ApplicationDetailsPart_TEXT_RESTART_TOOLTIP);
        }
        if (CloudFoundryProperties.isModuleProjectAccessible.testProperty(new IModule[]{this.module}, this.cloudServer)) {
            this.pushAppButton.setEnabled(true);
        } else {
            this.pushAppButton.setEnabled(false);
        }
        if (state == 4 || state == 0 || !CloudFoundryProperties.isModuleProjectAccessible.testProperty(new IModule[]{this.module}, this.cloudServer)) {
            this.updateRestartAppButton.setEnabled(false);
        } else {
            this.updateRestartAppButton.setEnabled(true);
        }
        this.refreshDebugControls(appModule);
        this.topButtonRow.getParent().layout(true);
        this.lowerButtonRow.getParent().layout(true);
    }

    private void updateServerNameDisplay(CloudFoundryApplicationModule application) {
        if (application.getApplication() == null) {
            this.serverNameText.setText(NLS.bind((String)Messages.ApplicationDetailsPart_TEXT_UPDATE_NOT_DEPLOYED, (Object)application.getDeployedApplicationName()));
            return;
        }
        int state = application.getState();
        switch (state) {
            case 2: {
                String message = Messages.ApplicationDetailsPart_TEXT_UPDATE_STARTED;
                this.serverNameText.setText(NLS.bind((String)"{0} {1}", (Object)application.getDeployedApplicationName(), (Object)message));
                break;
            }
            case 4: {
                this.serverNameText.setText(NLS.bind((String)Messages.ApplicationDetailsPart_TEXT_UPDATE_STOPPED, (Object)application.getDeployedApplicationName()));
                break;
            }
            default: {
                this.serverNameText.setText(application.getDeployedApplicationName());
            }
        }
    }

    protected void refreshPublishState(CloudFoundryApplicationModule appModule) {
        this.isPublished = appModule != null && appModule.isDeployed();
    }

    public void refreshUI() {
        int appMemory;
        this.logError(null);
        this.resizeTableColumns();
        this.canUpdate = false;
        CloudFoundryApplicationModule appModule = this.cloudServer.getExistingCloudModule(this.module);
        this.refreshPublishState(appModule);
        if (appModule == null) {
            return;
        }
        if (this.saveManifest != null) {
            ManifestParser parser = new ManifestParser(appModule, this.cloudServer);
            if (!parser.canWriteToManifest()) {
                this.saveManifest.setEnabled(false);
                this.saveManifest.setToolTipText(Messages.ApplicationDetailsPart_TEXT_MANIFEST_SAVE_CREATE_TOOLTIP);
            } else {
                this.saveManifest.setEnabled(true);
                this.saveManifest.setToolTipText(Messages.ApplicationDetailsPart_TEXT_MANIFEST_UPDATE);
            }
        }
        int state = appModule.getState();
        if (this.jrebelManualAppUrlUpdate != null) {
            this.jrebelManualAppUrlUpdate.setEnabled(CloudRebelAppHandler.isJRebelEnabled((IModule)this.module));
        }
        this.updateServerNameDisplay(appModule);
        this.instanceSpinner.setSelection(appModule.getInstanceCount());
        this.refreshDeploymentButtons(appModule);
        this.mappedURIsLink.setEnabled(state == 2);
        CloudApplication cloudApplication = appModule.getApplication();
        this.instanceSpinner.setEnabled(cloudApplication != null);
        this.instancesViewer.getTable().setEnabled(cloudApplication != null);
        this.instancesViewer.setInput(null);
        this.memoryText.setEnabled(cloudApplication != null);
        if (cloudApplication != null && (appMemory = appModule.getApplication().getMemory()) > 0) {
            this.memoryText.setText(String.valueOf(appMemory));
        }
        List<String> currentURIs = null;
        if (cloudApplication != null) {
            currentURIs = cloudApplication.getUris();
            ApplicationStats applicationStats = appModule.getApplicationStats();
            InstancesInfo instancesInfo = appModule.getInstancesInfo();
            if (applicationStats != null) {
                List statss = applicationStats.getRecords();
                List infos = instancesInfo != null ? instancesInfo.getInstances() : null;
                AppStatsContentProvider.InstanceStatsAndInfo[] statsAndInfos = new AppStatsContentProvider.InstanceStatsAndInfo[statss.size()];
                int i = 0;
                while (i < statss.size()) {
                    InstanceStats stats = (InstanceStats)statss.get(i);
                    InstanceInfo info = null;
                    if (infos != null && infos.size() > i) {
                        info = (InstanceInfo)infos.get(i);
                    }
                    statsAndInfos[i] = new AppStatsContentProvider.InstanceStatsAndInfo(stats, info);
                    ++i;
                }
                this.instancesViewer.setInput((Object)statsAndInfos);
            }
        }
        if (currentURIs == null && !this.isPublished) {
            List<String> list = currentURIs = appModule.getDeploymentInfo() != null ? appModule.getDeploymentInfo().getUris() : null;
        }
        if (currentURIs == null) {
            currentURIs = Collections.emptyList();
        }
        if (!currentURIs.equals(this.appUrls)) {
            this.updateAppUrls(currentURIs);
        }
        this.refreshServices(appModule);
        this.instancesViewer.refresh(true);
        this.canUpdate = true;
        if (appModule.getStatus() != null && !appModule.getStatus().isOK()) {
            if (appModule.getStatus().getSeverity() == 4) {
                this.editorPage.setMessage(appModule.getStatus().getMessage(), 3);
            } else if (appModule.getStatus().getSeverity() == 2) {
                this.editorPage.setMessage(appModule.getStatus().getMessage(), 2);
            }
        } else {
            this.editorPage.setMessage(null, 3);
            this.editorPage.setMessage(null, 2);
        }
    }

    private void refreshServices(CloudFoundryApplicationModule appModule) {
        if (this.provideServices) {
            List<CloudService> allServices;
            ArrayList<CloudService> updatedServices = new ArrayList<CloudService>();
            DeploymentInfoWorkingCopy deploymentInfo = null;
            List serviceNames = null;
            try {
                deploymentInfo = appModule.resolveDeploymentInfoWorkingCopy(ProgressManager.getInstance().getDefaultMonitor());
                serviceNames = deploymentInfo.asServiceBindingList();
            }
            catch (CoreException coreException) {
                this.logError(NLS.bind((String)Messages.ApplicationDetailsPart_ERROR_INCORRECT_SERVICE, (Object)appModule.getDeployedApplicationName()));
            }
            if (serviceNames == null) {
                serviceNames = Collections.emptyList();
            }
            if ((allServices = this.editorPage.getServices()) != null && !serviceNames.isEmpty()) {
                for (CloudService service : allServices) {
                    if (!serviceNames.contains(service.getName())) continue;
                    updatedServices.add(service);
                }
                if (!updatedServices.isEmpty() && deploymentInfo != null) {
                    deploymentInfo.setServices(updatedServices);
                    deploymentInfo.save();
                }
            }
            this.servicesViewer.setInput((Object)updatedServices.toArray(new CloudService[updatedServices.size()]));
            this.servicesDropListener.setModule(appModule);
            this.servicesViewer.refresh(true);
        }
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        IStructuredSelection sel = (IStructuredSelection)selection;
        this.module = (IModule)sel.getFirstElement();
        this.refreshUI();
        this.editorPage.refresh(EditorAction.RefreshArea.DETAIL);
    }

    private void adaptControl(Control control) {
        control.setBackground(this.toolkit.getColors().getBackground());
        control.setForeground(this.toolkit.getColors().getForeground());
    }

    private void addDropSupport(Section section) {
        int ops = 21;
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        DropTarget dropTarget = new DropTarget((Control)section, ops);
        dropTarget.setTransfer(transfers);
        dropTarget.addDropListener((DropTargetListener)this.servicesDropListener);
    }

    protected void resizeTableColumns() {
        if (this.initialTableResized) {
            return;
        }
        ArrayList<TableViewer> tableViewers = new ArrayList<TableViewer>();
        if (this.servicesViewer != null) {
            tableViewers.add(this.servicesViewer);
        }
        if (this.instancesViewer != null) {
            tableViewers.add(this.instancesViewer);
        }
        for (TableViewer tableViewer : tableViewers) {
            Table table = tableViewer.getTable();
            Composite tableComposite = table.getParent();
            Rectangle tableCompositeArea = tableComposite.getClientArea();
            int tableWidth = tableCompositeArea.width;
            TableColumn[] tableColumns = table.getColumns();
            if (tableColumns.length == 0) continue;
            int totalColumnWidths = 0;
            TableColumn[] tableColumnArray = tableColumns;
            int n = tableColumns.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumn column = tableColumnArray[n2];
                totalColumnWidths += column.getWidth();
                ++n2;
            }
            if (totalColumnWidths >= tableWidth) continue;
            this.initialTableResized = true;
            TableColumn lastColumn = tableColumns[tableColumns.length - 1];
            int newWidth = tableWidth - totalColumnWidths + lastColumn.getWidth();
            lastColumn.setWidth(newWidth);
        }
    }

    protected void updateAppUrls(List<String> urls) {
        this.appUrls = urls;
        this.mappedURIsLink.setText(ApplicationDetailsPart.getURIsAsLinkText(urls));
        this.generalSection.getParent().layout(true, true);
        this.editorPage.reflow();
    }

    private void createGeneralSection(Composite parent) {
        this.generalSection = this.toolkit.createSection(parent, 258);
        this.generalSection.setExpanded(true);
        this.generalSection.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.generalSection);
        this.generalSection.setText(Messages.ApplicationDetailsPart_TEXT_GENERAL);
        this.generalSection.clientVerticalSpacing = 0;
        Composite client = this.toolkit.createComposite((Composite)this.generalSection);
        client.setLayout((Layout)new GridLayout(2, false));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)client);
        this.generalSection.setClient((Control)client);
        this.createLabel(client, Messages.COMMONTXT_NAME_WITH_COLON, 0x1000000);
        this.serverNameText = this.createText(client, 0);
        this.createLabel(client, Messages.ApplicationDetailsPart_TEXT_MAPPED_URL, 128);
        Composite uriComposite = this.toolkit.createComposite(client);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(0, 0).applyTo(uriComposite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)uriComposite);
        ImageHyperlink editURI = this.toolkit.createImageHyperlink(uriComposite, 8);
        GridDataFactory.fillDefaults().grab(false, false).align(1, 128).applyTo((Control)editURI);
        editURI.setImage(CloudFoundryImages.getImage(CloudFoundryImages.EDIT));
        editURI.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                try {
                    CloudFoundryApplicationModule appModule = ApplicationDetailsPart.this.getExistingApplication();
                    MappedURLsWizard wizard = new MappedURLsWizard(ApplicationDetailsPart.this.cloudServer, appModule, ApplicationDetailsPart.this.appUrls);
                    WizardDialog dialog = new WizardDialog(ApplicationDetailsPart.this.editorPage.getEditorSite().getShell(), (IWizard)wizard);
                    if (dialog.open() == 0) {
                        ApplicationDetailsPart.this.updateAppUrls(wizard.getURLs());
                    }
                }
                catch (CoreException coreException) {
                    ApplicationDetailsPart.this.logApplicationModuleFailureError(Messages.ApplicationDetailsPart_ERROR_OPEN_URL_WIZ);
                }
            }
        });
        editURI.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = Messages.MappedURLsWizard_TITLE_MOD_MAPPED_URL;
            }
        });
        this.mappedURIsLink = new Link(uriComposite, 2);
        GridDataFactory.fillDefaults().grab(true, false).hint(250, -1).applyTo((Control)this.mappedURIsLink);
        this.adaptControl((Control)this.mappedURIsLink);
        this.mappedURIsLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CloudUiUtil.openUrl("http://" + e.text);
            }
        });
        this.createLabel(client, Messages.ApplicationDetailsPart_TEXT_INSTANCE, 0x1000000);
        this.instanceSpinner = new Spinner(client, 2048);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)this.instanceSpinner);
        this.instanceSpinner.setMinimum(0);
        this.instanceSpinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ApplicationDetailsPart.this.canUpdate) {
                    try {
                        CloudFoundryApplicationModule appModule = ApplicationDetailsPart.this.getExistingApplication();
                        new UpdateInstanceCountAction(ApplicationDetailsPart.this.editorPage, ApplicationDetailsPart.this.instanceSpinner, appModule).run();
                    }
                    catch (CoreException coreException) {
                        ApplicationDetailsPart.this.logApplicationModuleFailureError(Messages.ApplicationDetailsPart_ERROR_UPDATE_APP_INSTANCE);
                    }
                }
            }
        });
        this.toolkit.adapt((Composite)this.instanceSpinner);
        this.createLabel(client, Messages.ApplicationDetailsPart_TEXT_MANIFEST, 0x1000000);
        this.saveManifest = this.createGeneralPushButton(client, Messages.ApplicationDetailsPart_TEXT_SAVE);
        this.saveManifest.setEnabled(false);
        this.saveManifest.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ApplicationDetailsPart.this.writeToManifest();
            }
        });
        this.saveManifest.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = Messages.ApplicationDetailsPart_TEXT_MANIFEST_SAVE_BUTTON_ACC_LABEL;
            }
        });
        this.createJRebelSection(client);
    }

    private void createJRebelSection(Composite parent) {
        if (!CloudRebelAppHandler.isJRebelIDEInstalled()) {
            return;
        }
        Label label = this.createLabel(parent, Messages.ApplicationDetailsPart_TEXT_JREBEL, 0x1000000);
        label.setToolTipText(Messages.ApplicationDetailsPart_TEXT_JREBEL_UPDATE_REMOTING_TOOLTIP);
        this.jrebelManualAppUrlUpdate = this.toolkit.createButton(parent, Messages.ApplicationDetailsPart_TEXT_JREBEL_UPDATE_REMOTING, 8);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)this.jrebelManualAppUrlUpdate);
        this.jrebelManualAppUrlUpdate.setEnabled(false);
        this.jrebelManualAppUrlUpdate.setToolTipText(Messages.ApplicationDetailsPart_TEXT_JREBEL_UPDATE_REMOTING_TOOLTIP);
        this.jrebelManualAppUrlUpdate.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = Messages.ApplicationDetailsPart_TEXT_JREBEL_UPDATE_REMOTING;
            }
        });
        this.jrebelManualAppUrlUpdate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ApplicationDetailsPart.this.module != null) {
                    Job job = new Job(Messages.ApplicationDetailsPart_TEXT_JREBEL_UPDATE_REMOTING_JOB){

                        public IStatus run(IProgressMonitor monitor) {
                            ServerEventHandler.getDefault().fireServerEvent((CloudServerEvent)new ModuleChangeEvent(ApplicationDetailsPart.this.cloudServer, 700, ApplicationDetailsPart.this.module, Status.OK_STATUS));
                            return Status.OK_STATUS;
                        }
                    };
                    job.schedule();
                }
            }
        });
    }

    private void createGeneralSectionRestartRequired(Composite parent) {
        this.generalSectionRestartRequired = this.toolkit.createSection(parent, 258);
        this.generalSectionRestartRequired.setExpanded(true);
        this.generalSectionRestartRequired.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.generalSectionRestartRequired);
        this.generalSectionRestartRequired.setText(Messages.ApplicationDetailsPart_TEXT_GENERAL_APP_RESTART);
        this.generalSectionRestartRequired.clientVerticalSpacing = 0;
        Composite client = this.toolkit.createComposite((Composite)this.generalSectionRestartRequired);
        client.setLayout((Layout)new GridLayout(2, false));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)client);
        this.generalSectionRestartRequired.setClient((Control)client);
        this.createLabel(client, Messages.ApplicationDetailsPart_TEXT_MEMORY_LIMIT_LABEL, 0x1000000);
        Composite memoryArea = this.toolkit.createComposite(client);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(0, 0).applyTo(memoryArea);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)memoryArea);
        this.memoryText = new Text(memoryArea, 2048);
        this.memoryText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    Integer.parseInt(ApplicationDetailsPart.this.memoryText.getText());
                    ApplicationDetailsPart.this.logError(null);
                }
                catch (NumberFormatException numberFormatException) {
                    ApplicationDetailsPart.this.logError(Messages.ApplicationDetailsPart_ERROR_INVALID_MEMORY);
                }
            }
        });
        GridDataFactory.fillDefaults().align(16384, 4).hint(50, -1).applyTo((Control)this.memoryText);
        Button setMemoryButton = this.createGeneralPushButton(memoryArea, Messages.ApplicationDetailsPart_TEXT_SET);
        setMemoryButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ApplicationDetailsPart.this.canUpdate && ApplicationDetailsPart.this.memoryText != null && !ApplicationDetailsPart.this.memoryText.isDisposed()) {
                    int memory = -1;
                    try {
                        memory = Integer.parseInt(ApplicationDetailsPart.this.memoryText.getText());
                    }
                    catch (NumberFormatException numberFormatException) {}
                    if (memory > 0) {
                        try {
                            CloudFoundryApplicationModule appModule = ApplicationDetailsPart.this.getExistingApplication();
                            new UpdateApplicationMemoryAction(ApplicationDetailsPart.this.editorPage, memory, appModule).run();
                            ApplicationDetailsPart.this.logError(null);
                        }
                        catch (CoreException coreException) {
                            ApplicationDetailsPart.this.logError(Messages.ApplicationDetailsPart_ERROR_FAILED_MEMORY_UPDATE);
                        }
                    } else {
                        ApplicationDetailsPart.this.logError(Messages.ApplicationDetailsPart_ERROR_INVALID_MEMORY);
                    }
                }
            }
        });
        this.createLabel(client, Messages.ApplicationDetailsPart_TEXT_ENV_VAR, 0x1000000);
        Button envVarsButton = this.createGeneralPushButton(client, Messages.ApplicationDetailsPart_TEXT_EDIT_BUTTON);
        envVarsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    final CloudFoundryApplicationModule appModule = ApplicationDetailsPart.this.getExistingApplication();
                    if (appModule != null) {
                        UIJob uiJob = new UIJob(Messages.ApplicationDetailsPart_JOB_EDIT_ENV_VAR){

                            public IStatus runInUIThread(IProgressMonitor monitor) {
                                try {
                                    DeploymentInfoWorkingCopy infoWorkingCopy = appModule.resolveDeploymentInfoWorkingCopy(monitor);
                                    EnvVarsWizard wizard = new EnvVarsWizard(ApplicationDetailsPart.this.cloudServer, appModule, infoWorkingCopy);
                                    WizardDialog dialog = new WizardDialog(ApplicationDetailsPart.this.editorPage.getEditorSite().getShell(), (IWizard)wizard);
                                    dialog.open();
                                    return Status.OK_STATUS;
                                }
                                catch (CoreException e) {
                                    return e.getStatus();
                                }
                            }
                        };
                        uiJob.setSystem(true);
                        uiJob.setPriority(10);
                        uiJob.schedule();
                    }
                }
                catch (CoreException ce) {
                    ApplicationDetailsPart.this.logError(NLS.bind((String)Messages.ApplicationDetailsPart_ERROR_UPDATE_ENV_VAR, (Object)ce.getMessage()));
                }
            }
        });
        envVarsButton.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = Messages.ApplicationDetailsPart_TEXT_ENV_VAR_EDIT_BUTTON_ACC_LABEL;
            }
        });
    }

    private void createApplicationOperationsSection(Composite parent) {
        this.operationsSection = this.toolkit.createSection(parent, 258);
        this.operationsSection.setExpanded(true);
        this.operationsSection.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.operationsSection);
        this.operationsSection.setText(Messages.ApplicationDetailsPart_TEXT_APP_OP);
        this.operationsSection.clientVerticalSpacing = 0;
        Composite client = this.toolkit.createComposite((Composite)this.operationsSection);
        client.setLayout((Layout)new GridLayout(2, false));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)client);
        this.operationsSection.setClient((Control)client);
        this.topButtonRow = this.toolkit.createComposite(client);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.topButtonRow);
        RowLayout layout = RowLayoutFactory.fillDefaults().margins(0, 2).wrap(false).create();
        layout.center = true;
        this.topButtonRow.setLayout((Layout)layout);
        this.startAppButton = this.toolkit.createButton(this.topButtonRow, Messages.ApplicationDetailsPart_TEXT_START, 8);
        this.startAppButton.setImage(ImageResource.getImage((String)"IMG_CLCL_START"));
        this.startAppButton.setToolTipText(Messages.ApplicationDetailsPart_TEXT_START_TOOLTIP);
        this.startAppButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ApplicationDetailsPart.this.restartApplication(ApplicationAction.RESTART);
            }
        });
        this.startAppButton.setEnabled(true);
        this.stopAppButton = this.toolkit.createButton(this.topButtonRow, Messages.ApplicationDetailsPart_TEXT_STOP, 8);
        this.stopAppButton.setImage(ImageResource.getImage((String)"IMG_CLCL_STOP"));
        this.stopAppButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ApplicationDetailsPart.this.startStopApplication(ApplicationAction.STOP);
            }
        });
        this.updateRestartAppButton = this.toolkit.createButton(this.topButtonRow, Messages.ApplicationDetailsPart_TEXT_UPDATE_RESTART, 8);
        this.updateRestartAppButton.setImage(CloudFoundryImages.getImage(CloudFoundryImages.RESTART));
        this.updateRestartAppButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ApplicationDetailsPart.this.restartApplication(ApplicationAction.UPDATE_RESTART);
            }
        });
        this.updateRestartAppButton.setToolTipText(Messages.ApplicationDetailsPart_TEXT_UPDATE_RESTART_TOOLTIP);
        this.lowerButtonRow = this.toolkit.createComposite(client);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.lowerButtonRow);
        layout = RowLayoutFactory.fillDefaults().margins(0, 2).wrap(false).create();
        layout.center = true;
        this.lowerButtonRow.setLayout((Layout)layout);
        this.pushAppButton = this.toolkit.createButton(this.lowerButtonRow, Messages.ApplicationDetailsPart_TEXT_PUSH, 8);
        this.pushAppButton.setImage(CloudFoundryImages.getImage(CloudFoundryImages.PUSH));
        this.pushAppButton.setEnabled(false);
        this.pushAppButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ApplicationDetailsPart.this.startStopApplication(ApplicationAction.START);
            }
        });
        this.pushAppButton.setToolTipText(Messages.ApplicationDetailsPart_TEXT_PUSH_TOOLTIP);
        this.createDebugArea(this.lowerButtonRow);
    }

    protected Button createGeneralPushButton(Composite parent, String text) {
        Button button = this.toolkit.createButton(parent, text, 8);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).hint(50, -1).applyTo((Control)button);
        return button;
    }

    protected void writeToManifest() {
        final IStatus[] errorStatus = new IStatus[1];
        try {
            final CloudFoundryApplicationModule appModule = this.getExistingApplication();
            if (appModule != null && this.saveManifest != null && !this.saveManifest.isDisposed()) {
                if (MessageDialog.openConfirm((Shell)this.saveManifest.getShell(), (String)Messages.ApplicationDetailsPart_TEXT_SAVE_MANIFEST, (String)Messages.ApplicationDetailsPart_TEXT_SAVE_MANIFEST_BODY)) {
                    Job job = new Job(NLS.bind((String)Messages.ApplicationDetailsPart_JOB_WRITE, (Object)appModule.getDeployedApplicationName())){

                        protected IStatus run(IProgressMonitor monitor) {
                            try {
                                CloudFoundryApplicationModule updatedMod = ApplicationDetailsPart.this.cloudServer.getBehaviour().updateCloudModuleWithInstances(appModule.getDeployedApplicationName(), monitor);
                                ApplicationDetailsPart.this.serverBehaviour.refreshApplicationBoundServices(updatedMod, monitor);
                                ManifestParser parser = new ManifestParser(updatedMod, ApplicationDetailsPart.this.cloudServer);
                                parser.write(monitor, null);
                            }
                            catch (CoreException ce) {
                                errorStatus[0] = ce.getStatus();
                                return errorStatus[0];
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    job.schedule();
                }
            } else {
                errorStatus[0] = CloudFoundryPlugin.getErrorStatus((String)Messages.ApplicationDetailsPart_ERROR_WRITE_TO_MANIFEST);
            }
        }
        catch (CoreException ce) {
            errorStatus[0] = ce.getStatus();
        }
        if (errorStatus[0] != null && !errorStatus[0].isOK()) {
            this.logError(NLS.bind((String)Messages.ApplicationDetailsPart_ERROR_WRITE_TO_MANIFEST_DUE, (Object)errorStatus[0].getMessage()));
        }
    }

    protected void logApplicationModuleFailureError(String issue) {
        if (issue == null) {
            issue = Messages.ApplicationDetailsPart_ERROR_UNKNOWN;
        }
        String errorMessage = NLS.bind((String)Messages.ApplicationDetailsPart_ERROR_FAIL_TO_RESOLVE_CLOUD_MODULE, (Object)issue);
        this.logError(errorMessage);
    }

    protected void createDebugArea(Composite parent) {
        this.debugButton = this.toolkit.createButton(parent, Messages.ApplicationDetailsPart_TEXT_DEBUG, 8);
        this.debugButton.setImage(CloudFoundryImages.getImage(CloudFoundryImages.DEBUG));
        this.debugButton.setEnabled(false);
        this.debugButton.setData((Object)DebugOperationType.Debug);
        this.debugButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (DebugOperationType.Debug.equals(ApplicationDetailsPart.this.debugButton.getData())) {
                    ApplicationDetailsPart.this.debug();
                } else if (DebugOperationType.Terminate.equals(ApplicationDetailsPart.this.debugButton.getData())) {
                    ApplicationDetailsPart.this.terminateDebug();
                }
            }
        });
        this.debugButton.setEnabled(false);
        this.debugButton.setToolTipText(Messages.ApplicationDetailsPart_TEXT_DEBUG_TOOLTIP);
    }

    protected ApplicationAction getCurrentDeploymentStateApplicationAction() {
        return ApplicationAction.START;
    }

    protected void restartApplication(ApplicationAction restartAction) {
        this.skipButtonRefreshOnRestart = restartAction == ApplicationAction.UPDATE_RESTART;
        this.startStopApplication(restartAction);
    }

    private void createInstancesSection(Composite parent) {
        this.instancesSection = this.toolkit.createSection(parent, 258);
        this.instancesSection.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.instancesSection);
        this.instancesSection.setText(Messages.ApplicationDetailsPart_TEXT_INSTANCES);
        this.instancesSection.setExpanded(true);
        Composite client = this.toolkit.createComposite((Composite)this.instancesSection);
        client.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().applyTo((Control)client);
        this.instancesSection.setClient((Control)client);
        Composite container = this.toolkit.createComposite(client);
        GridLayoutFactory.fillDefaults().applyTo(container);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)container);
        String[] columnNames = new String[]{Messages.ApplicationDetailsPart_TEXT_ID, Messages.ApplicationDetailsPart_TEXT_HOST, Messages.ApplicationDetailsPart_TEXT_PORT, Messages.ApplicationDetailsPart_TEXT_CPU, Messages.COMMONTXT_MEM, Messages.ApplicationDetailsPart_TEXT_DISK, Messages.ApplicationDetailsPart_TEXT_UPTIME};
        String[] columnTooltips = new String[]{Messages.ApplicationDetailsPart_TEXT_ID, Messages.ApplicationDetailsPart_TEXT_HOST, Messages.ApplicationDetailsPart_TEXT_PORT, Messages.ApplicationDetailsPart_TEXT_CPU_CIRE, Messages.ApplicationDetailsPart_TEXT_MEMORY_LIMIT, Messages.ApplicationDetailsPart_TEXT_DISK_LIMIT, Messages.ApplicationDetailsPart_TEXT_UPTIME};
        int[] columnWidths = new int[]{25, 105, 60, 60, 85, 85, 75};
        this.instancesViewer = this.createTableViewer(container, columnNames, columnTooltips, columnWidths);
        this.instancesContentProvider = new AppStatsContentProvider();
        this.instancesViewer.setContentProvider((IContentProvider)this.instancesContentProvider);
        this.instancesViewer.setLabelProvider((IBaseLabelProvider)new AppStatsLabelProvider());
        this.instancesViewer.setSorter((ViewerSorter)new CloudFoundryViewerSorter());
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ApplicationDetailsPart.this.fillInstancesContextMenu(manager);
            }
        });
        Menu menu = menuManager.createContextMenu(this.instancesViewer.getControl());
        this.instancesViewer.getControl().setMenu(menu);
        if (Platform.getBundle((String)"org.eclipse.rse.ui") != null) {
            final ConfigureRemoteCloudFoundryAction configAction = new ConfigureRemoteCloudFoundryAction(this.cloudServer);
            Link configLink = new Link(client, 0);
            configLink.setText(Messages.ApplicationDetailsPart_TEXT_SHOW_IN_REMOTE_VIEW);
            configLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    configAction.run();
                }
            });
        }
    }

    private Label createLabel(Composite parent, String value, int verticalAlign) {
        Label label = this.toolkit.createLabel(parent, value);
        GridDataFactory.fillDefaults().align(4, verticalAlign).applyTo((Control)label);
        label.setForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        return label;
    }

    private void createServicesSection(Composite parent) {
        this.servicesSection = this.toolkit.createSection(parent, 258);
        this.servicesSection.setExpanded(true);
        this.servicesSection.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.servicesSection);
        this.servicesSection.setText(Messages.ApplicationDetailsPart_TEXT_APP_SERVICES);
        Composite client = this.toolkit.createComposite((Composite)this.servicesSection);
        client.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().applyTo((Control)client);
        this.servicesSection.setClient((Control)client);
        Composite container = this.toolkit.createComposite(client);
        GridLayoutFactory.fillDefaults().applyTo(container);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)container);
        String[] columnNames = new String[]{};
        int[] columnWidths = new int[]{};
        ServicesLabelProvider labelProvider = new ServicesLabelProvider();
        ApplicationInstanceServiceColumn[] columnDescriptor = labelProvider.getServiceViewColumn();
        if (columnDescriptor != null) {
            int length = columnDescriptor.length;
            columnNames = new String[length];
            columnWidths = new int[length];
            int i = 0;
            ApplicationInstanceServiceColumn[] applicationInstanceServiceColumnArray = columnDescriptor;
            int n = columnDescriptor.length;
            int n2 = 0;
            while (n2 < n) {
                ApplicationInstanceServiceColumn descriptor = applicationInstanceServiceColumnArray[n2];
                if (i < length) {
                    columnNames[i] = descriptor.name();
                    columnWidths[i] = descriptor.getWidth();
                    ++i;
                }
                ++n2;
            }
        }
        this.servicesViewer = this.createTableViewer(container, columnNames, null, columnWidths);
        this.servicesContentProvider = new TreeContentProvider();
        this.servicesViewer.setContentProvider((IContentProvider)this.servicesContentProvider);
        this.servicesViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.servicesViewer.setSorter((ViewerSorter)new CloudFoundryViewerSorter());
        this.servicesViewer.setInput((Object)new CloudService[0]);
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ApplicationDetailsPart.this.fillServicesContextMenu(manager);
            }
        });
        Menu menu = menuManager.createContextMenu(this.servicesViewer.getControl());
        this.servicesViewer.getControl().setMenu(menu);
        this.servicesSection.setVisible(CloudFoundryBrandingExtensionPoint.getProvideServices((String)this.editorPage.getServer().getServerType().getId()));
    }

    private TableViewer createTableViewer(Composite parent, String[] columnNames, String[] columnTooltips, int[] columnWeights) {
        Table table = this.toolkit.createTable(parent, 67586);
        GridDataFactory.fillDefaults().grab(true, true).hint(-1, 60).applyTo((Control)table);
        table.setHeaderVisible(true);
        int i = 0;
        while (i < columnNames.length) {
            TableColumn col = new TableColumn(table, 0);
            col.setWidth(columnWeights[i]);
            col.setText(columnNames[i]);
            if (columnTooltips == null) {
                col.setToolTipText(null);
            } else {
                col.setToolTipText(columnTooltips[i]);
            }
            ++i;
        }
        TableViewer tableViewer = new TableViewer(table);
        tableViewer.setColumnProperties(columnNames);
        return tableViewer;
    }

    private Text createText(Composite parent, int style) {
        Text text = new Text(parent, style);
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)text);
        text.setEditable(false);
        this.adaptControl((Control)text);
        return text;
    }

    private void fillServicesContextMenu(IMenuManager manager) {
        IStructuredSelection selection = (IStructuredSelection)this.servicesViewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        try {
            CloudFoundryApplicationModule appModule = this.getExistingApplication();
            manager.add((IAction)new RemoveServicesFromApplicationAction(selection, appModule, this.serverBehaviour, this.editorPage));
        }
        catch (CoreException coreException) {
            this.logApplicationModuleFailureError(Messages.ApplicationDetailsPart_ERROR_DETERMINE_BOUND_SERVICE);
        }
    }

    private void fillInstancesContextMenu(IMenuManager manager) {
        InstanceStats stats;
        IStructuredSelection selection = (IStructuredSelection)this.instancesViewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        Object instanceObject = selection.getFirstElement();
        if (instanceObject instanceof AppStatsContentProvider.InstanceStatsAndInfo && (stats = ((AppStatsContentProvider.InstanceStatsAndInfo)instanceObject).getStats()) != null) {
            try {
                CloudFoundryApplicationModule appModule = this.getExistingApplication();
                manager.add((IAction)new ShowConsoleEditorAction(this.cloudServer, appModule, Integer.parseInt(stats.getId())));
            }
            catch (CoreException coreException) {
                this.logApplicationModuleFailureError(Messages.ApplicationDetailsPart_ERROR_GENERATE_APP_INSTANCE_CONTEXT_MENU);
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    protected CloudFoundryApplicationModule getExistingApplication() throws CoreException {
        CloudFoundryApplicationModule appModule = this.cloudServer.getExistingCloudModule(this.module);
        if (appModule == null) {
            String errorMessage = this.module != null ? NLS.bind((String)Messages.ApplicationDetailsPart_ERROR_NO_CF_APP_MODULE_FOR, (Object)this.module.getId()) : Messages.ApplicationDetailsPart_ERROR_NO_CF_APP_MODULE;
            throw CloudErrorUtil.toCoreException((String)errorMessage);
        }
        return appModule;
    }

    protected void logError(String message) {
        this.logError(message, null);
    }

    protected void logError(String message, Shell dialogueShell) {
        if (this.editorPage != null && !this.editorPage.isDisposed()) {
            if (message != null) {
                this.editorPage.setErrorMessage(message);
            } else {
                this.editorPage.setErrorMessage(null);
            }
        }
        if (dialogueShell != null && message != null) {
            MessageDialog.openError((Shell)dialogueShell, (String)Messages.ApplicationDetailsPart_TEXT_DEBUG, (String)message);
        }
    }

    protected void debug() {
        CloudFoundryApplicationModule appModule = this.cloudServer.getExistingCloudModule(this.module);
        if (appModule != null) {
            new DebugApplicationEditorAction(this.editorPage, appModule, this.cloudServer, this.getSelectedAppInstance(), this.debugLauncher).run();
        }
    }

    protected void terminateDebug() {
        CloudFoundryApplicationModule appModule = this.cloudServer.getExistingCloudModule(this.module);
        if (appModule != null) {
            new TerminateDebugEditorAction(this.editorPage, appModule, this.cloudServer, this.getSelectedAppInstance(), this.debugLauncher).run();
        }
    }

    private void startStopApplication(ApplicationAction action) {
        try {
            CloudFoundryApplicationModule appModule = this.getExistingApplication();
            new StartStopApplicationAction(this.editorPage, action, appModule, this.serverBehaviour).run();
        }
        catch (CoreException coreException) {
            this.logApplicationModuleFailureError(NLS.bind((String)Messages.ApplicationDetailsPart_ERROR_PERFORM, (Object)action.getDisplayName()));
        }
    }

    private static String getURIsAsLinkText(List<String> uris) {
        StringBuilder result = new StringBuilder();
        for (String uri : uris) {
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append("<a href=\"");
            result.append(uri);
            result.append("\">");
            result.append(uri);
            result.append("</a>");
        }
        return result.toString();
    }
}

