/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.console;

import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.log.CloudLog;
import org.eclipse.cft.server.ui.internal.console.ApplicationLogConsoleManager;
import org.eclipse.cft.server.ui.internal.console.CloudConsoleManager;
import org.eclipse.cft.server.ui.internal.console.CloudFoundryConsole;
import org.eclipse.cft.server.ui.internal.console.ConsoleConfig;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleListener;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;

public class ConsoleManagerRegistry {
    public static final String CLOUD_FOUNDRY_TRACE_CONSOLE_NAME = "Cloud Foundry Trace";
    static final String TRACE_CONSOLE_ID = "org.eclipse.cft.server.trace";
    private static ConsoleManagerRegistry registry;
    private CloudFoundryConsole traceConsole;
    private IConsoleManager consoleManager;
    private CloudConsoleManager appConsoleManager = new ApplicationLogConsoleManager();
    private final IConsoleListener listener = new IConsoleListener(){

        public void consolesAdded(IConsole[] consoles) {
        }

        public void consolesRemoved(IConsole[] consoles) {
            IConsole[] iConsoleArray = consoles;
            int n = consoles.length;
            int n2 = 0;
            while (n2 < n) {
                IConsole console = iConsoleArray[n2];
                if (ConsoleManagerRegistry.TRACE_CONSOLE_ID.equals(console.getType()) && ConsoleManagerRegistry.this.traceConsole != null) {
                    ConsoleManagerRegistry.this.traceConsole.stop();
                    ConsoleManagerRegistry.this.traceConsole = null;
                }
                ++n2;
            }
        }
    };

    public ConsoleManagerRegistry() {
        this.consoleManager = ConsolePlugin.getDefault().getConsoleManager();
        this.consoleManager.addConsoleListener(this.listener);
    }

    public static ConsoleManagerRegistry getInstance() {
        if (registry == null) {
            registry = new ConsoleManagerRegistry();
        }
        return registry;
    }

    public static CloudConsoleManager getConsoleManager(CloudFoundryServer cloudServer) {
        return ConsoleManagerRegistry.getInstance().getCloudConsoleManager(cloudServer);
    }

    public CloudConsoleManager getCloudConsoleManager(CloudFoundryServer cloudServer) {
        return this.appConsoleManager;
    }

    public void setTraceConsoleVisible() {
        CloudFoundryConsole console = this.getTraceConsoleStream();
        if (console != null) {
            this.consoleManager.showConsoleView((IConsole)console.getConsole());
        }
    }

    public void trace(CloudLog log, boolean clear) {
        if (log == null) {
            return;
        }
        try {
            CloudFoundryConsole console = this.getTraceConsoleStream();
            if (console != null) {
                console.writeToStream(log);
            }
        }
        catch (Throwable e) {
            CloudFoundryPlugin.logError((Throwable)e);
        }
    }

    protected synchronized CloudFoundryConsole getTraceConsoleStream() {
        if (this.traceConsole == null) {
            MessageConsole messageConsole = null;
            IConsole[] iConsoleArray = ConsolePlugin.getDefault().getConsoleManager().getConsoles();
            int n = iConsoleArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConsole console = iConsoleArray[n2];
                if (console instanceof MessageConsole && console.getName().equals(CLOUD_FOUNDRY_TRACE_CONSOLE_NAME)) {
                    messageConsole = (MessageConsole)console;
                }
                ++n2;
            }
            if (messageConsole == null) {
                messageConsole = new MessageConsole(CLOUD_FOUNDRY_TRACE_CONSOLE_NAME, TRACE_CONSOLE_ID, null, true);
            }
            this.traceConsole = new CloudFoundryConsole(new ConsoleConfig(messageConsole, null, null));
            ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{messageConsole});
        }
        return this.traceConsole;
    }
}

