/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.wizards;

import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.ui.internal.CloudFoundryImages;
import org.eclipse.cft.server.ui.internal.Messages;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class RegisterAccountWizardPage
extends WizardPage {
    private CloudFoundryServer cloudServer;
    private Text emailText;
    private Text passwordText;
    private Text verifyPasswordText;

    protected RegisterAccountWizardPage(CloudFoundryServer cloudServer) {
        super(Messages.RegisterAccountWizardPage_TEXT_REGISTER_ACC);
        this.cloudServer = cloudServer;
        this.setTitle(Messages.RegisterAccountWizardPage_TITLE_REGISTER_ACC);
        this.setDescription(NLS.bind((String)Messages.RegisterAccountWizardPage_TEXT_SIGNUP, (Object)cloudServer.getUrl()));
        ImageDescriptor banner = CloudFoundryImages.getWizardBanner(cloudServer.getServer().getServerType().getId());
        if (banner != null) {
            this.setImageDescriptor(banner);
        }
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        Label emailLabel = new Label(composite, 0);
        emailLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        emailLabel.setText(Messages.COMMONTXT_EMAIL_WITH_COLON);
        this.emailText = new Text(composite, 2048);
        this.emailText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.emailText.setEditable(true);
        this.emailText.setFocus();
        if (this.cloudServer.getUsername() != null) {
            this.emailText.setText(this.cloudServer.getUsername());
        }
        this.emailText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RegisterAccountWizardPage.this.update();
            }
        });
        Label passwordLabel = new Label(composite, 0);
        passwordLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        passwordLabel.setText(Messages.COMMONTXT_PW);
        this.passwordText = new Text(composite, 0x400800);
        this.passwordText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.passwordText.setEditable(true);
        if (this.cloudServer.getPassword() != null) {
            this.passwordText.setText(this.cloudServer.getPassword());
        }
        this.passwordText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RegisterAccountWizardPage.this.update();
            }
        });
        Label verifyPasswordLabel = new Label(composite, 0);
        verifyPasswordLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        verifyPasswordLabel.setText(Messages.RegisterAccountWizardPage_LABEL_VERIFY);
        this.verifyPasswordText = new Text(composite, 0x400800);
        this.verifyPasswordText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.verifyPasswordText.setEditable(true);
        this.verifyPasswordText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RegisterAccountWizardPage.this.update();
            }
        });
        this.update();
        this.setControl((Control)composite);
    }

    public String getEmail() {
        return this.emailText.getText();
    }

    public String getPassword() {
        return this.passwordText.getText();
    }

    private void update() {
        String errorMessage = null;
        String message = null;
        if (this.emailText.getText().length() == 0) {
            message = Messages.RegisterAccountWizardPage_TEXT_ENTER_EMAIL;
        } else if (this.passwordText.getText().length() == 0) {
            message = Messages.RegisterAccountWizardPage_TEXT_ENTER_PW;
        } else if (this.verifyPasswordText.getText().length() == 0) {
            message = Messages.RegisterAccountWizardPage_TEXT_ENTER_PW_VERIFICATION;
        } else if (!this.passwordText.getText().equals(this.verifyPasswordText.getText())) {
            errorMessage = Messages.RegisterAccountWizardPage_ERROR_PW_NO_MATCH;
        }
        this.setMessage(message);
        this.setErrorMessage(errorMessage);
        this.setPageComplete(message == null && errorMessage == null);
    }
}

