/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.debug;

import org.eclipse.cft.server.core.AbstractDebugProvider;
import org.eclipse.cft.server.core.internal.CloudErrorUtil;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.CloudServerUtil;
import org.eclipse.cft.server.core.internal.Messages;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;

public abstract class CloudFoundryDebugProvider
extends AbstractDebugProvider {
    public abstract String getLaunchConfigurationType(CloudFoundryApplicationModule var1, CloudFoundryServer var2);

    public String getLaunchLabel(CloudFoundryApplicationModule appModule, CloudFoundryServer cloudServer, int appInstance) {
        StringBuilder idBuffer = new StringBuilder();
        idBuffer.append(cloudServer.getUrl());
        idBuffer.append('-');
        idBuffer.append(cloudServer.getCloudFoundrySpace().getOrgName());
        idBuffer.append('-');
        idBuffer.append(cloudServer.getCloudFoundrySpace().getSpaceName());
        idBuffer.append('-');
        idBuffer.append(appModule.getDeployedApplicationName());
        idBuffer.append('-');
        idBuffer.append(appInstance);
        return idBuffer.toString();
    }

    @Override
    public String getApplicationDebugLaunchId(IModule module, IServer server, int appInstance) throws CoreException {
        StringBuilder idBuffer = new StringBuilder();
        CloudFoundryServer cloudServer = this.getCloudServer(server);
        CloudFoundryApplicationModule appModule = this.getCloudFoundryApplicationModule(module, cloudServer);
        idBuffer.append(cloudServer.getUrl());
        idBuffer.append('-');
        idBuffer.append(cloudServer.getUsername());
        idBuffer.append('-');
        idBuffer.append(cloudServer.getCloudFoundrySpace().getOrgName());
        idBuffer.append('-');
        idBuffer.append(cloudServer.getCloudFoundrySpace().getSpaceName());
        idBuffer.append('-');
        idBuffer.append(appModule.getDeployedApplicationName());
        idBuffer.append('-');
        idBuffer.append(appInstance);
        return idBuffer.toString();
    }

    @Override
    public ILaunchConfiguration getLaunchConfiguration(IModule module, IServer server, int appInstance, int remoteDebugPort, IProgressMonitor monitor) throws CoreException {
        CloudFoundryServer cloudServer = this.getCloudServer(server);
        CloudFoundryApplicationModule appModule = this.getCloudFoundryApplicationModule(module, cloudServer);
        String launchLabel = this.getLaunchLabel(appModule, cloudServer, appInstance);
        launchLabel = launchLabel.replaceAll("@", "-");
        String launchType = this.getLaunchConfigurationType(appModule, cloudServer);
        ILaunchConfigurationType launchConfigType = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(launchType);
        if (launchConfigType != null) {
            IProject project = appModule.getLocalModule().getProject();
            ILaunchConfigurationWorkingCopy launchConfiguration = launchConfigType.newInstance((IContainer)project, launchLabel);
            ILaunchConfigurationWorkingCopy wc = launchConfiguration.getWorkingCopy();
            if (project != null && project.isAccessible()) {
                wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, project.getName());
            }
            wc.setAttribute("cloudDebugServer", cloudServer.getServerId());
            wc.setAttribute("cloudDebugAppName", appModule.getDeployedApplicationName());
            wc.setAttribute("cloudDebugAppInstance", appInstance);
            wc.setAttribute("cloudDebugRemoteDebugPort", remoteDebugPort);
            wc.setAttribute("cloudDebugAppLaunchId", this.getApplicationDebugLaunchId(module, server, appInstance));
            launchConfiguration = wc.doSave();
            return launchConfiguration;
        }
        throw CloudErrorUtil.toCoreException("No debug launch configuration found for - " + launchType);
    }

    protected CloudFoundryServer getCloudServer(IServer server) throws CoreException {
        return CloudServerUtil.getCloudServer(server);
    }

    protected CloudFoundryApplicationModule getCloudFoundryApplicationModule(IModule module, CloudFoundryServer cloudServer) throws CoreException {
        CloudFoundryApplicationModule appModule = cloudServer.getExistingCloudModule(module);
        if (appModule == null) {
            throw CloudErrorUtil.toCoreException(NLS.bind((String)Messages.CloudFoundryDebugProvider_NO_CLOUD_MODULE_FOUND, (Object)module.getName(), (Object)cloudServer.getServer().getId()));
        }
        return appModule;
    }
}

