/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.xmlpivot.common.predicates;

import com.google.common.base.Predicate;
import java.util.Collection;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class EMFPredicates {
    private static Predicate<EObject> isRootContainer;
    private static Predicate<EStructuralFeature> isDerived;
    private static Predicate<EReference> hasAbstractType;

    public static Predicate<EObject> isRootContainer() {
        if (isRootContainer == null) {
            isRootContainer = new Predicate<EObject>(){

                public boolean apply(EObject input) {
                    return input != null && input.eContainer() == null;
                }
            };
        }
        return isRootContainer;
    }

    public static Predicate<EObject> isAncestor(final Collection<? extends EObject> ancestorObjects) {
        return new Predicate<EObject>(){

            public boolean apply(EObject input_p) {
                return EcoreUtil.isAncestor((Collection)ancestorObjects, (EObject)input_p);
            }
        };
    }

    public static <T extends EObject> Predicate<T> isEBooleanAttributeSet(final EAttribute attribute_p, Class<T> clazz) {
        return new Predicate<T>(){

            public boolean apply(T input_p) {
                return (Boolean)input_p.eGet((EStructuralFeature)attribute_p);
            }
        };
    }

    public static Predicate<EStructuralFeature> isDerived() {
        if (isDerived == null) {
            isDerived = EMFPredicates.isEBooleanAttributeSet(EcorePackage.Literals.ESTRUCTURAL_FEATURE__DERIVED, EStructuralFeature.class);
        }
        return isDerived;
    }

    public static Predicate<EReference> hasAbstractType() {
        if (hasAbstractType == null) {
            hasAbstractType = new Predicate<EReference>(){

                public boolean apply(EReference input_p) {
                    return input_p.getEReferenceType().isAbstract();
                }
            };
        }
        return hasAbstractType;
    }

    public static Predicate<EObject> isInstance(final EClass clazz) {
        return new Predicate<EObject>(){

            public boolean apply(EObject input_p) {
                return clazz.isInstance((Object)input_p);
            }
        };
    }

    public static Predicate<EObject> hasEClass(final EClass clazz) {
        return new Predicate<EObject>(){

            public boolean apply(EObject input_p) {
                return input_p.eClass() == clazz;
            }
        };
    }
}

