/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.docgen.util.pattern.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.AbstractExchangeItem;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.fa.ComponentPort;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.information.ExchangeItemElement;
import org.polarsys.capella.core.data.information.ParameterDirection;
import org.polarsys.capella.core.data.information.datavalue.DataValue;
import org.polarsys.capella.core.model.helpers.InterfaceExt;
import org.polarsys.capella.docgen.util.CapellaDataValueServices;
import org.polarsys.capella.docgen.util.CapellaLabelProviderHelper;
import org.polarsys.capella.docgen.util.CapellaServices;
import org.polarsys.capella.docgen.util.StringUtil;
import org.polarsys.capella.docgen.util.pattern.helper.CapellaExchangeItemElementHelper;

public class CapellaInterfaceHelper {
    private static String exchangeItemToString(String projectName, String outputFolder, ExchangeItem exchangeItem) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<table style=\"border:0px;\"><tr><td style=\"border:0px; vertical-align:top; max-width:none; white-space: nowrap;\">");
        buffer.append(CapellaServices.getImageLinkFromElement((EObject)exchangeItem, projectName, outputFolder));
        buffer.append("&nbsp;");
        buffer.append("<strong id=\"" + CapellaServices.getAnchorId((EObject)exchangeItem) + "\">");
        buffer.append(CapellaServices.getHyperlinkFromElement((EObject)exchangeItem));
        buffer.append("</strong></td><td style=\"border:0px; max-width:none;\">");
        ExchangeItemElement returnElement = null;
        if (exchangeItem.getOwnedElements().size() > 0) {
            buffer.append(" (");
            Iterator iterator = exchangeItem.getOwnedElements().iterator();
            while (iterator.hasNext()) {
                ExchangeItemElement currentTypedElement = (ExchangeItemElement)iterator.next();
                if (currentTypedElement.getDirection().equals((Object)ParameterDirection.RETURN)) {
                    returnElement = currentTypedElement;
                    continue;
                }
                buffer.append(currentTypedElement.getDirection().getName());
                buffer.append(" <strong>");
                buffer.append(currentTypedElement.getName());
                buffer.append("</strong>");
                if (currentTypedElement.getOwnedMinCard() != null && currentTypedElement.getOwnedMaxCard() != null) {
                    String min = CapellaDataValueServices.getSimpleValueOfDataValue((DataValue)currentTypedElement.getOwnedMinCard());
                    String max = CapellaDataValueServices.getSimpleValueOfDataValue((DataValue)currentTypedElement.getOwnedMaxCard());
                    if (!min.equals("1") || !max.equals("1")) {
                        buffer.append("&nbsp;");
                        buffer.append("[");
                        buffer.append(min);
                        buffer.append(", ");
                        buffer.append(max);
                        buffer.append("]");
                    }
                }
                if (currentTypedElement.getType() != null) {
                    buffer.append(": ");
                    buffer.append(CapellaServices.getFullDataPkgHierarchyLink((EObject)currentTypedElement.getType()));
                } else {
                    buffer.append(": &lt;undefined&gt;");
                }
                if (!iterator.hasNext()) continue;
                buffer.append(", <br />");
            }
            buffer.append(")");
        }
        buffer.append("</td></tr>");
        if (returnElement != null) {
            buffer.append("<tr><td style=\"border:0px; max-width:none;\"></td><td style=\"border:0px; max-width:none;\">");
            buffer.append("RETURN ");
            buffer.append(returnElement.getName());
            if (returnElement.getType() != null) {
                buffer.append(":");
                buffer.append(CapellaServices.getFullDataPkgHierarchyLink((EObject)returnElement.getType()));
            }
            buffer.append("</td></tr>");
        }
        buffer.append("</table>");
        if (exchangeItem.getSummary() != null && exchangeItem.getSummary().length() > 0) {
            buffer.append("\n<br />");
            buffer.append(exchangeItem.getSummary());
        }
        if (exchangeItem.getDescription() != null && exchangeItem.getDescription().length() > 0) {
            buffer.append("\n<br />");
            buffer.append(StringUtil.transformAREFString((EObject)exchangeItem, exchangeItem.getDescription(), projectName, outputFolder));
        }
        ArrayList<String> exchangeItemElementStrings = new ArrayList<String>();
        for (ExchangeItemElement exchangeItemElement : exchangeItem.getOwnedElements()) {
            exchangeItemElementStrings.add(CapellaExchangeItemElementHelper.exchangeItemElementToString(exchangeItemElement, projectName, outputFolder));
        }
        if (exchangeItemElementStrings.size() > 0) {
            buffer.append(StringUtil.stringListToBulette(exchangeItemElementStrings));
        }
        return buffer.toString();
    }

    public static Collection<String> getProvidedBy(Interface interface1, String projectName, String outputFolder) {
        ArrayList<String> ret = new ArrayList<String>();
        for (ComponentPort componentPort : InterfaceExt.getProvidedByPorts((Interface)interface1)) {
            EObject componentEObject = componentPort.eContainer();
            if (!(componentEObject instanceof Component)) continue;
            ret.add(CapellaInterfaceHelper.componentToString(projectName, outputFolder, componentPort, componentEObject));
        }
        return ret;
    }

    public static Collection<String> getImplementedBy(Interface interface1, String projectName, String outputFolder) {
        ArrayList<String> ret = new ArrayList<String>();
        for (Component component : interface1.getImplementorComponents()) {
            ret.add(CapellaInterfaceHelper.componentToString(projectName, outputFolder, (EObject)component));
        }
        return ret;
    }

    public static Collection<String> getRequiredBy(Interface interface1, String projectName, String outputFolder) {
        ArrayList<String> ret = new ArrayList<String>();
        for (ComponentPort componentPort : InterfaceExt.getRequiredByPorts((Interface)interface1)) {
            EObject componentEObject = componentPort.eContainer();
            if (!(componentEObject instanceof Component)) continue;
            ret.add(CapellaInterfaceHelper.componentToString(projectName, outputFolder, componentPort, componentEObject));
        }
        return ret;
    }

    public static Collection<String> getUsedBy(Interface interface1, String projectName, String outputFolder) {
        ArrayList<String> ret = new ArrayList<String>();
        for (Component component : interface1.getUserComponents()) {
            ret.add(CapellaInterfaceHelper.componentToString(projectName, outputFolder, (EObject)component));
        }
        return ret;
    }

    private static String componentToString(String projectName, String outputFolder, EObject componentEObject) {
        return CapellaInterfaceHelper.componentToString(projectName, outputFolder, null, componentEObject);
    }

    private static String componentToString(String projectName, String outputFolder, ComponentPort componentPort, EObject componentEObject) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(CapellaServices.getImageLinkFromElement(componentEObject, projectName, outputFolder));
        buffer.append(" ");
        buffer.append(CapellaServices.getHyperlinkFromElement(componentEObject));
        if (componentPort != null) {
            buffer.append(" ");
            buffer.append("(");
            buffer.append(CapellaLabelProviderHelper.getText((EObject)componentPort));
            buffer.append(")");
        }
        return buffer.toString();
    }

    public static Collection<String> getOperationExchangeItems(Interface interface1, String projectName, String outputFolder) {
        return CapellaInterfaceHelper.getExchangeItems(interface1, projectName, outputFolder, 2);
    }

    public static Collection<String> getSharedDataExchangeItems(Interface interface1, String projectName, String outputFolder) {
        return CapellaInterfaceHelper.getExchangeItems(interface1, projectName, outputFolder, 4);
    }

    public static Collection<String> getEventExchangeItems(Interface interface1, String projectName, String outputFolder) {
        return CapellaInterfaceHelper.getExchangeItems(interface1, projectName, outputFolder, 3);
    }

    public static Collection<String> getFlowExchangeItems(Interface interface1, String projectName, String outputFolder) {
        return CapellaInterfaceHelper.getExchangeItems(interface1, projectName, outputFolder, 1);
    }

    public static Collection<String> getUnsetExchangeItems(Interface interface1, String projectName, String outputFolder) {
        return CapellaInterfaceHelper.getExchangeItems(interface1, projectName, outputFolder, 0);
    }

    public static Collection<String> getExchangeItems(Interface interface1, String projectName, String outputFolder, int exchangeMechanismValue) {
        ArrayList<String> exchangeItems = new ArrayList<String>();
        for (AbstractExchangeItem currentExchangeItem : interface1.getExchangeItems()) {
            if (!(currentExchangeItem instanceof ExchangeItem) || ((ExchangeItem)currentExchangeItem).getExchangeMechanism().getValue() != exchangeMechanismValue) continue;
            exchangeItems.add(CapellaInterfaceHelper.exchangeItemToString(projectName, outputFolder, (ExchangeItem)currentExchangeItem));
        }
        return exchangeItems;
    }
}

