/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.pde.internal.ui;

import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egf.core.pde.internal.ui.ModelModification;
import org.eclipse.egf.core.pde.internal.ui.XMLTextChangeListener;
import org.eclipse.jface.text.IDocument;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.ISharedExtensionsModel;
import org.eclipse.pde.internal.core.bundle.BundleFragmentModel;
import org.eclipse.pde.internal.core.bundle.BundlePluginModel;
import org.eclipse.pde.internal.core.ibundle.IBundleModel;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.core.text.AbstractEditingModel;
import org.eclipse.pde.internal.core.text.IEditingModel;
import org.eclipse.pde.internal.core.text.IModelTextChangeListener;
import org.eclipse.pde.internal.core.text.build.BuildModel;
import org.eclipse.pde.internal.core.text.build.PropertiesTextChangeListener;
import org.eclipse.pde.internal.core.text.bundle.BundleModel;
import org.eclipse.pde.internal.core.text.bundle.BundleTextChangeListener;
import org.eclipse.pde.internal.core.text.plugin.FragmentModel;
import org.eclipse.pde.internal.core.text.plugin.PluginModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.build.BuildEditor;
import org.eclipse.pde.internal.ui.editor.build.BuildSourcePage;
import org.eclipse.pde.internal.ui.editor.context.InputContext;
import org.eclipse.pde.internal.ui.editor.plugin.ManifestEditor;
import org.eclipse.pde.internal.ui.editor.schema.SchemaEditor;
import org.eclipse.pde.internal.ui.editor.site.SiteEditor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.forms.editor.IFormPage;

public class PDEModelUtility {
    public static final String F_MANIFEST = "MANIFEST.MF";
    public static final String F_MANIFEST_FP = "META-INF/MANIFEST.MF";
    public static final String F_PLUGIN = "plugin.xml";
    public static final String F_FRAGMENT = "fragment.xml";
    public static final String F_PROPERTIES = ".properties";
    public static final String F_BUILD = "build.properties";
    private static final int F_Bi = 0;
    private static final int F_Xi = 1;
    private static Hashtable fOpenPDEEditors = new Hashtable();

    public static void connect(PDEFormEditor editor) {
        IProject project = editor.getCommonProject();
        if (project == null) {
            return;
        }
        if (fOpenPDEEditors.containsKey(project)) {
            ArrayList list = (ArrayList)fOpenPDEEditors.get(project);
            if (!list.contains(editor)) {
                list.add(editor);
            }
        } else {
            ArrayList<PDEFormEditor> list = new ArrayList<PDEFormEditor>();
            list.add(editor);
            fOpenPDEEditors.put(project, list);
        }
    }

    public static void disconnect(PDEFormEditor editor) {
        IProject project = editor.getCommonProject();
        if (project == null) {
            return;
        }
        if (!fOpenPDEEditors.containsKey(project)) {
            return;
        }
        ArrayList list = (ArrayList)fOpenPDEEditors.get(project);
        list.remove(editor);
        if (list.size() == 0) {
            fOpenPDEEditors.remove(project);
        }
    }

    public static ManifestEditor getOpenManifestEditor(IProject project) {
        return (ManifestEditor)PDEModelUtility.getOpenEditor(project, "org.eclipse.pde.ui.manifestEditor");
    }

    public static BuildEditor getOpenBuildPropertiesEditor(IProject project) {
        return (BuildEditor)PDEModelUtility.getOpenEditor(project, "org.eclipse.pde.ui.buildEditor");
    }

    public static SiteEditor getOpenUpdateSiteEditor(IProject project) {
        return (SiteEditor)PDEModelUtility.getOpenEditor(project, "org.eclipse.pde.ui.siteEditor");
    }

    private static PDEFormEditor getOpenEditor(IProject project, String editorId) {
        ArrayList list = (ArrayList)fOpenPDEEditors.get(project);
        if (list == null) {
            return null;
        }
        int i = 0;
        while (i < list.size()) {
            PDEFormEditor editor = (PDEFormEditor)list.get(i);
            if (editor.getEditorSite().getId().equals(editorId)) {
                return editor;
            }
            ++i;
        }
        return null;
    }

    public static SchemaEditor getOpenSchemaEditor(IFile file) {
        return (SchemaEditor)PDEModelUtility.getOpenEditor("org.eclipse.pde.ui.schemaEditor", "schema-context", file);
    }

    private static PDEFormEditor getOpenEditor(String editorID, String inputContextID, IFile file) {
        IProject project = file.getProject();
        ArrayList list = (ArrayList)fOpenPDEEditors.get(project);
        if (list == null) {
            return null;
        }
        int i = 0;
        while (i < list.size()) {
            IFile currentFile;
            IEditorInput input;
            InputContext context;
            PDEFormEditor editor = (PDEFormEditor)list.get(i);
            String currentEditorID = editor.getEditorSite().getId();
            if (currentEditorID.equals(editorID) && (context = editor.getContextManager().findContext(inputContextID)) != null && (input = context.getInput()) instanceof IFileEditorInput && (currentFile = ((IFileEditorInput)input).getFile()).equals((Object)file)) {
                return editor;
            }
            ++i;
        }
        return null;
    }

    public static IPluginModelBase getActivePluginModel() {
        IBaseModel model;
        IEditorPart editor = PDEPlugin.getActivePage().getActiveEditor();
        if (editor instanceof ManifestEditor && (model = ((ManifestEditor)editor).getAggregateModel()) instanceof IPluginModelBase) {
            return (IPluginModelBase)model;
        }
        return null;
    }

    public static IEditingModel getOpenModel(IDocument document) {
        for (ArrayList list : fOpenPDEEditors.values()) {
            int i = 0;
            while (i < list.size()) {
                PDEFormEditor e = (PDEFormEditor)list.get(i);
                IPluginModelBase model = (IPluginModelBase)e.getAggregateModel();
                if (model instanceof IBundlePluginModelBase) {
                    IBundleModel bModel = ((IBundlePluginModelBase)model).getBundleModel();
                    if (bModel instanceof IEditingModel && document == ((IEditingModel)bModel).getDocument()) {
                        return (IEditingModel)bModel;
                    }
                    ISharedExtensionsModel eModel = ((IBundlePluginModelBase)model).getExtensionsModel();
                    if (eModel instanceof IEditingModel && document == ((IEditingModel)eModel).getDocument()) {
                        return (IEditingModel)eModel;
                    }
                }
                if (model instanceof IEditingModel && document == ((IEditingModel)model).getDocument()) {
                    return (IEditingModel)model;
                }
                ++i;
            }
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    public static void modifyModel(ModelModification modification, IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [22[DOLOOP]], but top level block is 23[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void modifyEditorModel(final ModelModification mod, final PDEFormEditor editor, final IBaseModel model, final IProgressMonitor monitor) {
        PDEModelUtility.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    mod.modifyModel(model, monitor);
                    IFile[] files = new IFile[]{mod.getManifestFile(), mod.getXMLFile(), mod.getPropertiesFile()};
                    int i = 0;
                    while (i < files.length) {
                        InputContext con;
                        if (files[i] != null && (con = editor.getContextManager().findContext((IResource)files[i])) != null) {
                            con.flushEditorInput();
                        }
                        ++i;
                    }
                    if (mod.saveOpenEditor()) {
                        editor.doSave(monitor);
                    }
                }
                catch (CoreException e) {
                    PDEPlugin.log((Throwable)e);
                }
            }
        });
    }

    private static PDEFormEditor getOpenEditor(ModelModification modification) {
        IProject project = modification.getFile().getProject();
        String name = modification.getFile().getName();
        if (name.equals(F_PLUGIN) || name.equals(F_FRAGMENT) || name.equals(F_MANIFEST)) {
            return PDEModelUtility.getOpenManifestEditor(project);
        }
        if (name.equals(F_BUILD)) {
            BuildEditor openEditor = PDEModelUtility.getOpenBuildPropertiesEditor(project);
            if (openEditor == null) {
                openEditor = PDEModelUtility.getOpenManifestEditor(project);
            }
            return openEditor;
        }
        return null;
    }

    private static IBaseModel getModelFromEditor(PDEFormEditor openEditor, ModelModification modification) {
        if (openEditor == null) {
            return null;
        }
        String name = modification.getFile().getName();
        IBaseModel model = null;
        if (name.equals(F_PLUGIN) || name.equals(F_FRAGMENT)) {
            model = openEditor.getAggregateModel();
            if (model instanceof IBundlePluginModelBase) {
                model = ((IBundlePluginModelBase)model).getExtensionsModel();
            }
        } else if (name.equals(F_BUILD)) {
            IFormPage page;
            if (openEditor instanceof BuildEditor) {
                model = openEditor.getAggregateModel();
            } else if (openEditor instanceof ManifestEditor && (page = openEditor.findPage("build-context")) instanceof BuildSourcePage) {
                model = ((BuildSourcePage)page).getInputContext().getModel();
            }
        } else if (name.equals(F_MANIFEST) && (model = openEditor.getAggregateModel()) instanceof IBundlePluginModelBase) {
            return model;
        }
        if (model instanceof AbstractEditingModel) {
            return model;
        }
        return null;
    }

    private static IModelTextChangeListener createListener(String filename, IDocument doc) {
        if (filename.equals(F_PLUGIN) || filename.equals(F_FRAGMENT)) {
            return new XMLTextChangeListener(doc);
        }
        if (filename.equals(F_MANIFEST)) {
            return new BundleTextChangeListener(doc);
        }
        if (filename.endsWith(F_PROPERTIES)) {
            return new PropertiesTextChangeListener(doc);
        }
        return null;
    }

    private static AbstractEditingModel prepareAbstractEditingModel(IFile file, IDocument doc) {
        BundleModel model;
        String filename = file.getName();
        if (filename.equals(F_MANIFEST)) {
            model = new BundleModel(doc, true);
        } else if (filename.equals(F_FRAGMENT)) {
            model = new FragmentModel(doc, true);
        } else if (filename.equals(F_PLUGIN)) {
            model = new PluginModel(doc, true);
        } else if (filename.endsWith(F_PROPERTIES)) {
            model = new BuildModel(doc, true);
        } else {
            return null;
        }
        model.setUnderlyingResource((IResource)file);
        try {
            model.load();
            IModelTextChangeListener listener = PDEModelUtility.createListener(filename, doc);
            model.addModelChangedListener((IModelChangedListener)listener);
        }
        catch (CoreException e) {
            PDEPlugin.log((Throwable)e);
        }
        return model;
    }

    private static IBaseModel prepareBundlePluginModel(IFile[] files, IDocument[] docs) {
        AbstractEditingModel[] models = new AbstractEditingModel[docs.length];
        boolean isFragment = false;
        models[0] = PDEModelUtility.prepareAbstractEditingModel(files[0], docs[0]);
        if (models[0] instanceof IBundleModel) {
            isFragment = ((IBundleModel)models[0]).getBundle().getHeader("Fragment-Host") != null;
        }
        Object pluginModel = isFragment ? new BundleFragmentModel() : new BundlePluginModel();
        pluginModel.setBundleModel((IBundleModel)models[0]);
        if (files.length > 1 && files[1] != null) {
            models[1] = PDEModelUtility.prepareAbstractEditingModel(files[1], docs[1]);
            pluginModel.setExtensionsModel((ISharedExtensionsModel)models[1]);
        }
        return pluginModel;
    }

    private static IModelTextChangeListener[] gatherListeners(IBaseModel editModel) {
        IModelTextChangeListener[] listeners = new IModelTextChangeListener[]{};
        if (editModel instanceof AbstractEditingModel) {
            listeners = new IModelTextChangeListener[]{((AbstractEditingModel)editModel).getLastTextChangeListener()};
        }
        if (editModel instanceof IBundlePluginModelBase) {
            IBundlePluginModelBase modelBase = (IBundlePluginModelBase)editModel;
            listeners = new IModelTextChangeListener[]{PDEModelUtility.gatherListener((IBaseModel)modelBase.getBundleModel()), PDEModelUtility.gatherListener((IBaseModel)modelBase.getExtensionsModel())};
            return listeners;
        }
        return listeners;
    }

    private static IModelTextChangeListener gatherListener(IBaseModel model) {
        if (model instanceof AbstractEditingModel) {
            return ((AbstractEditingModel)model).getLastTextChangeListener();
        }
        return null;
    }

    private static Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }
}

