/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.docgen.util.pattern.helper;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.polarsys.capella.core.data.capellacore.Involvement;
import org.polarsys.capella.core.data.cs.ExchangeItemAllocation;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.fa.FunctionalChain;
import org.polarsys.capella.core.data.fa.FunctionalChainInvolvementLink;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.helpers.information.services.ExchangeItemExt;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.information.ExchangeItemElement;
import org.polarsys.capella.docgen.util.CapellaServices;
import org.polarsys.capella.docgen.util.pattern.helper.CapellaExchangeItemElementHelper;

public class CapellaExchangeItemHelper {
    public static Collection<String> getExchangeItemElements(ExchangeItem exchangeItem, String projectName, String outputFolder) {
        ArrayList<String> ret = new ArrayList<String>();
        for (ExchangeItemElement exchangeItemElement : exchangeItem.getOwnedElements()) {
            ret.add(CapellaExchangeItemElementHelper.exchangeItemElementToString(exchangeItemElement, projectName, outputFolder));
        }
        return ret;
    }

    public static Collection<String> getExchangeItemInterfaces(ExchangeItem exchangeItem, String projectName, String outputFolder) {
        ArrayList<String> ret = new ArrayList<String>();
        for (ExchangeItemAllocation allocation : ExchangeItemExt.getRelatedExchangeItemAllocations((ExchangeItem)exchangeItem)) {
            StringBuffer buffer = new StringBuffer();
            Interface interface1 = allocation.getAllocatingInterface();
            buffer.append(CapellaServices.getImageLinkFromElement((EObject)interface1, projectName, outputFolder));
            buffer.append(" ");
            buffer.append(CapellaServices.getHyperlinkFromElement((EObject)interface1));
            allocation.getAllocatingInterface();
            ret.add(buffer.toString());
        }
        return ret;
    }

    public static Collection<String> getReferencingFunctionalExchanges(ExchangeItem exchangeItem, String projectName, String outputFolder) {
        ArrayList<String> referencingFunctionalExchanges = new ArrayList<String>();
        EObject root = EcoreUtil.getRootContainer((EObject)exchangeItem);
        TreeIterator it = root.eAllContents();
        while (it.hasNext()) {
            FunctionalExchange exchange;
            EList referencedItems;
            EObject object = (EObject)it.next();
            if (!(object instanceof FunctionalExchange) || !(referencedItems = (exchange = (FunctionalExchange)object).getExchangedItems()).contains((Object)exchangeItem)) continue;
            referencingFunctionalExchanges.add(CapellaServices.buildHyperlinkWithIcon(projectName, outputFolder, (EObject)exchange));
        }
        return referencingFunctionalExchanges;
    }

    public static Collection<String> getInvolvingFunctionalChains(ExchangeItem exchangeItem, String projectName, String outputFolder) {
        ArrayList<FunctionalChain> referencingFunctionalChains = new ArrayList<FunctionalChain>();
        ArrayList<String> referencingFunctionalChainsStrings = new ArrayList<String>();
        EObject root = EcoreUtil.getRootContainer((EObject)exchangeItem);
        TreeIterator it = root.eAllContents();
        while (it.hasNext()) {
            EObject object = (EObject)it.next();
            if (!(object instanceof FunctionalChain)) continue;
            FunctionalChain functionalChain = (FunctionalChain)object;
            for (Involvement involvment : functionalChain.getInvolvedInvolvements()) {
                EList referencedItems;
                if (!(involvment instanceof FunctionalChainInvolvementLink) || !(referencedItems = ((FunctionalChainInvolvementLink)involvment).getExchangedItems()).contains((Object)exchangeItem) || referencingFunctionalChains.contains(functionalChain)) continue;
                referencingFunctionalChainsStrings.add(CapellaServices.buildHyperlinkWithIcon(projectName, outputFolder, (EObject)functionalChain));
                referencingFunctionalChains.add(functionalChain);
            }
        }
        return referencingFunctionalChainsStrings;
    }
}

