/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.strategy.domaindriven;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.egf.model.pattern.DomainVisitor;
import org.eclipse.egf.model.pattern.Node;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternContext;
import org.eclipse.egf.model.pattern.PatternException;
import org.eclipse.egf.model.pattern.PatternParameter;
import org.eclipse.egf.pattern.engine.PatternEngine;
import org.eclipse.egf.pattern.execution.InternalPatternContext;
import org.eclipse.egf.pattern.extension.ExtensionHelper;
import org.eclipse.egf.pattern.extension.PatternExtension;
import org.eclipse.egf.pattern.l10n.EGFPatternMessages;
import org.eclipse.egf.pattern.utils.ParameterTypeHelper;
import org.eclipse.egf.pattern.utils.SubstitutionHelper;
import org.eclipse.emf.common.util.EList;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDomainVisitor
implements DomainVisitor {
    protected static final Object[] EMPTY_ARRAY = new Object[0];
    protected final Map<String, List<Pattern>> type2patterns = new HashMap<String, List<Pattern>>(100);
    protected final Set<Object> visited = new HashSet<Object>();

    public void setPatterns(List<Pattern> patterns) throws PatternException {
        for (Pattern p : patterns) {
            EList parameters = p.getAllParameters();
            if (parameters.size() != 1) {
                throw new PatternException(NLS.bind((String)EGFPatternMessages.strategy_error4, (Object)p.getName()));
            }
            this.registerPattern(p, (PatternParameter)parameters.get(0));
        }
    }

    private void registerPattern(Pattern p, PatternParameter patternParameter) throws PatternException {
        String type = patternParameter.getType();
        List<Pattern> patterns = this.type2patterns.get(type);
        if (patterns == null) {
            try {
                String string = ParameterTypeHelper.INSTANCE.getSourceTypeLiteral(type);
            }
            catch (Exception e) {
                throw new PatternException(NLS.bind((String)EGFPatternMessages.strategy_error5, (Object)p.getName()), (Throwable)e);
            }
            patterns = new ArrayList<Pattern>();
            this.type2patterns.put(type, patterns);
        }
        patterns.add(p);
    }

    protected List<Pattern> findPatterns(PatternContext context, Object model) throws PatternException {
        List<Pattern> result = this.findPatterns(model);
        if (result == null) {
            return null;
        }
        List<Object> parameterValues = Arrays.asList(model);
        return SubstitutionHelper.apply(context, result, parameterValues);
    }

    protected List<Pattern> findPatterns(Object model) {
        Class<?> clazz = model.getClass();
        List<Pattern> patterns = this.findPatternFromClass(clazz);
        if (patterns != null && !patterns.isEmpty()) {
            return patterns;
        }
        Class<?> superclass = clazz.getSuperclass();
        if (superclass == null) {
            return null;
        }
        return this.findPatternFromClass(superclass);
    }

    private List<Pattern> findPatternFromClass(Class<?> clazz) {
        List<Pattern> result = this.getPatterns(clazz);
        if (result == null || result.isEmpty()) {
            Class<?>[] classArray = clazz.getInterfaces();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> cls = classArray[n2];
                result = this.getPatterns(cls);
                if (result != null && !result.isEmpty()) {
                    return result;
                }
                ++n2;
            }
        }
        return result;
    }

    private List<Pattern> getPatterns(Class<?> clazz) {
        String fullName = clazz.getName();
        return this.type2patterns.get(fullName);
    }

    public void visit(PatternContext context, Object model) throws PatternException {
        Object[] objectArray = this.getChildren(model);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (!this.hasBeenVisited(obj)) {
                this.doProcess(context, obj);
            }
            this.visit(context, obj);
            ++n2;
        }
    }

    protected void doProcess(PatternContext context, Object model) throws PatternException {
        this.markVisited(model);
        List<Pattern> foundPattern = this.findPatterns(context, model);
        if (foundPattern == null || foundPattern.isEmpty()) {
            return;
        }
        this.executeWithInjection(foundPattern, context, model);
    }

    protected void executeWithInjection(Collection<Pattern> patterns, PatternContext context, Object model) throws PatternException {
        Node.Container currentNode = ((InternalPatternContext)context).getNode();
        for (Pattern pattern : patterns) {
            try {
                Map<PatternParameter, Object> parameters = this.createParameterMap(pattern, model);
                PatternExtension extension = ExtensionHelper.getExtension(pattern.getNature());
                String canExecute = extension.canExecute(pattern);
                if (canExecute != null) {
                    throw new PatternException(canExecute);
                }
                PatternEngine engine = extension.createEngine(pattern);
                if (!engine.checkCondition(context, parameters)) continue;
                if (currentNode != null) {
                    Node.Container localNode = new Node.Container(currentNode, engine.getUnderlyingClassname());
                    ((InternalPatternContext)context).setNode(localNode);
                }
                engine.executeWithInjection(context, parameters);
            }
            catch (ExtensionHelper.MissingExtensionException e) {
                throw new PatternException((Throwable)e);
            }
        }
        ((InternalPatternContext)context).setNode(currentNode);
    }

    private Map<PatternParameter, Object> createParameterMap(Pattern pattern, Object model) {
        HashMap<PatternParameter, Object> parameters = new HashMap<PatternParameter, Object>();
        parameters.put((PatternParameter)pattern.getAllParameters().get(0), model);
        return parameters;
    }

    public void dispose() {
        this.visited.clear();
        for (String key : this.type2patterns.keySet()) {
            this.type2patterns.get(key).clear();
        }
        this.type2patterns.clear();
    }

    protected boolean hasBeenVisited(Object obj) {
        return this.visited.contains(obj);
    }

    protected void markVisited(Object model) {
        this.visited.add(model);
    }
}

