/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.producer.fprod.internal.manager;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.egf.common.helper.EMFHelper;
import org.eclipse.egf.core.producer.InvocationException;
import org.eclipse.egf.core.producer.context.IProductionContext;
import org.eclipse.egf.core.producer.context.ProductionContext;
import org.eclipse.egf.model.fcore.Contract;
import org.eclipse.egf.model.fcore.ContractMode;
import org.eclipse.egf.model.fcore.FactoryComponent;
import org.eclipse.egf.model.fcore.Invocation;
import org.eclipse.egf.model.fcore.InvocationContract;
import org.eclipse.egf.model.fcore.Orchestration;
import org.eclipse.egf.model.fcore.OrchestrationParameter;
import org.eclipse.egf.model.fprod.ProductionPlan;
import org.eclipse.egf.model.fprod.ProductionPlanInvocation;
import org.eclipse.egf.model.types.Type;
import org.eclipse.egf.producer.EGFProducerPlugin;
import org.eclipse.egf.producer.fprod.internal.context.ProducerFprodContextFactory;
import org.eclipse.egf.producer.fprod.internal.manager.ProductionPlanInvocationManager;
import org.eclipse.egf.producer.fprod.l10n.FprodProducerMessages;
import org.eclipse.egf.producer.internal.manager.OrchestrationManager;
import org.eclipse.egf.producer.manager.IActivityManager;
import org.eclipse.egf.producer.manager.IModelElementManager;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProductionPlanManager
extends OrchestrationManager<ProductionPlan> {
    private Map<ProductionPlanInvocation, ProductionPlanInvocationManager> _managers;

    public ProductionPlanManager(IActivityManager<FactoryComponent> parent, ProductionPlan productionPlan) throws InvocationException {
        super(parent, (Orchestration)productionPlan);
    }

    public ProductionContext<ProductionPlan, OrchestrationParameter> getInternalProductionContext() throws InvocationException {
        if (this._productionContext == null) {
            this._productionContext = ProducerFprodContextFactory.createContext((IProductionContext<FactoryComponent, Contract>)this.getParent().getProductionContext(), this.getProjectBundleSession(), (ProductionPlan)this.getElement());
        }
        return (ProductionContext)this._productionContext;
    }

    private Map<ProductionPlanInvocation, ProductionPlanInvocationManager> getProductionPlanManagers() throws InvocationException {
        if (this._managers == null && ((ProductionPlan)this.getElement()).getInvocations() != null) {
            this._managers = new HashMap<ProductionPlanInvocation, ProductionPlanInvocationManager>(((ProductionPlan)this.getElement()).getInvocations().size());
            for (ProductionPlanInvocation invocation : ((ProductionPlan)this.getElement()).getInvocations()) {
                this._managers.put(invocation, new ProductionPlanInvocationManager((IModelElementManager<ProductionPlan, OrchestrationParameter>)this, invocation));
            }
        }
        return this._managers;
    }

    public void dispose() throws InvocationException {
        super.dispose();
        Map<ProductionPlanInvocation, ProductionPlanInvocationManager> managers = this.getProductionPlanManagers();
        if (managers != null) {
            for (Invocation invocation : ((ProductionPlan)this.getElement()).getInvocations()) {
                managers.get(invocation).dispose();
            }
        }
    }

    public Diagnostic canInvoke() throws InvocationException {
        BasicDiagnostic diagnostic = this.checkInputElement(false);
        Map<ProductionPlanInvocation, ProductionPlanInvocationManager> managers = this.getProductionPlanManagers();
        if (managers != null) {
            for (Invocation invocation : ((ProductionPlan)this.getElement()).getInvocations()) {
                diagnostic.add(managers.get(invocation).canInvoke());
            }
        }
        return diagnostic;
    }

    public void initializeContext() throws InvocationException {
        super.initializeContext();
        Map<ProductionPlanInvocation, ProductionPlanInvocationManager> managers = this.getProductionPlanManagers();
        if (managers != null) {
            for (Invocation invocation : ((ProductionPlan)this.getElement()).getInvocations()) {
                managers.get(invocation).initializeContext();
            }
        }
    }

    public int getSteps() throws InvocationException {
        int steps = 0;
        Map<ProductionPlanInvocation, ProductionPlanInvocationManager> managers = this.getProductionPlanManagers();
        if (managers != null) {
            for (Invocation invocation : ((ProductionPlan)this.getElement()).getInvocations()) {
                steps += managers.get(invocation).getSteps();
            }
        }
        return steps;
    }

    public Diagnostic invoke(IProgressMonitor monitor) throws InvocationException {
        Map<ProductionPlanInvocation, ProductionPlanInvocationManager> managers;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, null, (int)(this.getSteps() * 100));
        BasicDiagnostic diagnostic = this.checkInputElement(true);
        if (diagnostic.getSeverity() != 4 && (managers = this.getProductionPlanManagers()) != null) {
            for (Invocation invocation : ((ProductionPlan)this.getElement()).getInvocations()) {
                ProductionPlanInvocationManager manager = managers.get(invocation);
                try {
                    diagnostic.add(manager.invoke((IProgressMonitor)subMonitor.newChild(manager.getSteps() * 100, 0)));
                }
                catch (InvocationException ie) {
                    if (ie.getDiagnostic() != null) {
                        diagnostic.add(ie.getDiagnostic());
                    }
                    ie.setDiagnostic((Diagnostic)diagnostic);
                    throw ie;
                }
                if (diagnostic.getSeverity() != 4) {
                    this.populateTargetRuntimeContext(manager);
                }
                if (!subMonitor.isCanceled()) continue;
                throw new OperationCanceledException();
            }
        }
        return diagnostic;
    }

    private void populateTargetRuntimeContext(ProductionPlanInvocationManager manager) throws InvocationException {
        for (InvocationContract contract : ((ProductionPlanInvocation)manager.getElement()).getInvocationContracts(ContractMode.OUT)) {
            for (InvocationContract targetInvocationContract : contract.getTargetInvocationContract()) {
                if (targetInvocationContract == null || targetInvocationContract.getInvocation() == null) continue;
                ProductionPlanInvocationManager targetManager = this.getProductionPlanManagers().get(targetInvocationContract.getInvocation());
                if (targetManager == null) {
                    throw new InvocationException((Throwable)new CoreException(EGFProducerPlugin.getDefault().newStatus(4, NLS.bind((String)FprodProducerMessages.ProductionPlanManager_unknown_manager, (Object)EMFHelper.getText((Object)targetInvocationContract.getInvocation())), null)));
                }
                Type type = contract.getType();
                if (type == null) {
                    type = contract.getInvokedContract().getType();
                }
                Object value = manager.getProductionContext().getOutputValue((Object)contract.getInvokedContract(), type.getType());
                if (targetInvocationContract.getInvokedMode() == ContractMode.IN) {
                    targetManager.getInternalProductionContext().addInputData((Object)targetInvocationContract, type.getType(), value, false);
                    continue;
                }
                targetManager.getInternalProductionContext().addInputData((Object)targetInvocationContract, type.getType(), value, false);
                targetManager.getInternalProductionContext().addOutputData((Object)targetInvocationContract, type.getType(), value, false);
            }
        }
    }
}

