/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.producer.internal.registry;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.egf.common.l10n.EGFCommonMessages;
import org.eclipse.egf.model.fcore.Orchestration;
import org.eclipse.egf.producer.EGFProducerPlugin;
import org.eclipse.egf.producer.internal.registry.OrchestrationManagerProducerProxy;
import org.eclipse.egf.producer.l10n.ProducerMessages;
import org.eclipse.egf.producer.manager.OrchestrationManagerProducer;
import org.eclipse.osgi.util.NLS;

public final class OrchestrationManagerProducerRegistry
implements IRegistryEventListener {
    private Map<String, OrchestrationManagerProducerProxy> _proxies;
    public static final String EXTENSION_ID = "org.eclipse.egf.producer.orchestrationManagerProducer";
    public static final String INVOKER_ATT_ORCHESTRATION = "orchestration";
    public static final String INVOKER_ATT_CLASS = "class";

    public OrchestrationManagerProducerRegistry() {
        this.initialize();
        RegistryFactory.getRegistry().addListener((IRegistryEventListener)this, EXTENSION_ID);
    }

    public <P extends Orchestration> OrchestrationManagerProducer<P> getOrchestrationManagerProducer(P orchestration) throws CoreException {
        OrchestrationManagerProducerProxy proxy = this._proxies.get(orchestration.eClass().getInstanceTypeName());
        if (proxy == null) {
            throw new CoreException(EGFProducerPlugin.getDefault().newStatus(4, NLS.bind((String)ProducerMessages.OrchestrationManagerProducer_extension_error, (Object)orchestration.eClass().getInstanceTypeName()), null));
        }
        return proxy.getOrchestrationManagerProducer(orchestration);
    }

    private void initialize() {
        if (this._proxies != null) {
            return;
        }
        this._proxies = new HashMap<String, OrchestrationManagerProducerProxy>();
        IExtensionPoint point = RegistryFactory.getRegistry().getExtensionPoint(EXTENSION_ID);
        if (point != null) {
            IExtension[] iExtensionArray = point.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    this.register(element);
                    ++n4;
                }
                ++n2;
            }
        }
    }

    private void register(IConfigurationElement element) {
        if (element == null) {
            return;
        }
        OrchestrationManagerProducerProxy proxy = OrchestrationManagerProducerProxy.createProxy(element);
        if (proxy != null) {
            if (this._proxies.get(proxy.getOrchestration()) != null) {
                EGFProducerPlugin.getDefault().logError(NLS.bind((String)EGFCommonMessages.Duplicate_Element_Message, (Object)proxy.getOrchestration()));
                EGFProducerPlugin.getDefault().logInfo(NLS.bind((String)EGFCommonMessages.Bundle_Message, (Object)element.getContributor().getName()), 1);
                EGFProducerPlugin.getDefault().logInfo(NLS.bind((String)EGFCommonMessages.Extension_Point_Message, (Object)element.getName()), 1);
            }
            this._proxies.put(proxy.getOrchestration(), proxy);
        }
    }

    public void added(IExtension[] extensions) {
        if (extensions == null) {
            return;
        }
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                this.register(element);
                ++n4;
            }
            ++n2;
        }
    }

    public void removed(IExtension[] extensions) {
        int i = 0;
        while (i < extensions.length) {
            Iterator<OrchestrationManagerProducerProxy> it = this._proxies.values().iterator();
            while (it.hasNext()) {
                OrchestrationManagerProducerProxy proxy = it.next();
                if (!proxy.originatesFrom(extensions[i])) continue;
                it.remove();
            }
            ++i;
        }
    }

    public void added(IExtensionPoint[] extensionPoints) {
    }

    public void removed(IExtensionPoint[] extensionPoints) {
    }

    public void dispose() {
        RegistryFactory.getRegistry().removeListener((IRegistryEventListener)this);
        this._proxies = null;
    }
}

