/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.platform.loader;

import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egf.common.helper.BundleHelper;
import org.eclipse.egf.common.helper.FileHelper;
import org.eclipse.egf.common.loader.JavaClassLoaderFactory;
import org.eclipse.egf.core.platform.EGFPlatformPlugin;
import org.eclipse.egf.core.platform.internal.loader.BundleClassLoader;
import org.eclipse.egf.core.platform.internal.pde.DirectoryBuildModel;
import org.eclipse.egf.core.platform.internal.pde.PlatformClasspathContainer;
import org.eclipse.egf.core.platform.internal.pde.PlatformRequiredPluginsClasspathContainer;
import org.eclipse.egf.core.platform.l10n.CorePlatformMessages;
import org.eclipse.egf.core.platform.loader.IBundleClassLoader;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.ModelEntry;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.PDEClasspathContainer;

public class BundleClassLoaderFactory {
    public static List<IPluginModelBase> getProjects(IPluginModelBase model) throws CoreException {
        UniqueEList models = new UniqueEList();
        if (model == null) {
            return models;
        }
        IProject project = null;
        if (model.getUnderlyingResource() != null) {
            project = model.getUnderlyingResource().getProject();
        }
        UniqueEList classpathEntries = new UniqueEList();
        Path location = new Path(model.getInstallLocation());
        if (project == null && location.toFile() != null && location.toFile().isDirectory()) {
            if (location.toFile() != null && location.toFile().exists()) {
                PlatformClasspathContainer.addLibraryEntry((IPath)location, null, new PlatformClasspathContainer.Rule[0], PlatformClasspathContainer.getClasspathAttributes(model), (List<IClasspathEntry>)classpathEntries);
            }
        } else {
            PlatformRequiredPluginsClasspathContainer classpathContainer = new PlatformRequiredPluginsClasspathContainer(model);
            IClasspathEntry[] entries = classpathContainer.getClasspathEntries();
            if (entries != null) {
                classpathEntries.addAll(Arrays.asList(entries));
            }
        }
        models.addAll(BundleClassLoaderFactory.getProjects(model, (List<IClasspathEntry>)classpathEntries));
        return models;
    }

    public static List<URL> getBundlesURLs(IPluginModelBase model, List<IProject> visitedProjects) throws CoreException {
        UniqueEList urls = new UniqueEList();
        if (model == null) {
            return urls;
        }
        IProject project = null;
        if (model.getUnderlyingResource() != null && (project = model.getUnderlyingResource().getProject()) != null && visitedProjects != null && visitedProjects.contains(project)) {
            return urls;
        }
        UniqueEList classpathEntries = new UniqueEList();
        Path location = new Path(model.getInstallLocation());
        if (project == null && location.toFile() != null && location.toFile().isDirectory()) {
            PlatformRequiredPluginsClasspathContainer classpathContainer;
            IClasspathEntry[] entries;
            if (location.toFile() != null && location.toFile().exists()) {
                PlatformClasspathContainer.addLibraryEntry((IPath)location, null, new PlatformClasspathContainer.Rule[0], PlatformClasspathContainer.getClasspathAttributes(model), (List<IClasspathEntry>)classpathEntries);
            }
            if ((entries = PDEClasspathContainer.getExternalEntries((IPluginModelBase)model)) != null) {
                classpathEntries.addAll(Arrays.asList(entries));
            }
            if ((location = location.append("build.properties")).toFile() != null && location.toFile().exists() && (entries = (classpathContainer = new PlatformRequiredPluginsClasspathContainer(model, new DirectoryBuildModel(location.toFile()).getBuild())).getClasspathEntries()) != null) {
                classpathEntries.addAll(Arrays.asList(entries));
            }
        } else {
            PlatformRequiredPluginsClasspathContainer classpathContainer = new PlatformRequiredPluginsClasspathContainer(model);
            IClasspathEntry[] entries = classpathContainer.getClasspathEntries();
            if (entries != null) {
                classpathEntries.addAll(Arrays.asList(entries));
            }
        }
        urls.addAll(BundleClassLoaderFactory.getBundlesURLs(model, (List<IClasspathEntry>)classpathEntries, visitedProjects));
        return urls;
    }

    protected static List<URL> getBundleURLs(IPluginModelBase model, List<IClasspathEntry> classpathEntries) throws CoreException {
        UniqueEList urls = new UniqueEList();
        if (model == null) {
            return urls;
        }
        IProject project = null;
        if (model.getUnderlyingResource() != null) {
            project = model.getUnderlyingResource().getProject();
        }
        IJavaProject javaProject = null;
        try {
            try {
                URL url;
                if (project != null) {
                    IFolder folder;
                    url = JavaClassLoaderFactory.getURL((IPath)project.getLocation());
                    if (url != null) {
                        urls.add(url);
                    }
                    if ((javaProject = JavaCore.create((IProject)project)).exists() && (folder = FileHelper.getFolder((IPath)javaProject.getOutputLocation())) != null && (url = JavaClassLoaderFactory.getURL((IPath)folder.getLocation())) != null) {
                        urls.add(url);
                    }
                } else {
                    url = JavaClassLoaderFactory.getURL((IPath)new Path(model.getInstallLocation()));
                    if (url != null) {
                        urls.add(url);
                    }
                }
                for (IClasspathEntry entry : classpathEntries) {
                    URL url2;
                    if (entry.getEntryKind() == 3) {
                        URL url3;
                        IFolder folder = FileHelper.getFolder((IPath)entry.getOutputLocation());
                        if (folder == null || (url3 = JavaClassLoaderFactory.getURL((IPath)folder.getLocation())) == null) continue;
                        urls.add(url3);
                        continue;
                    }
                    if (entry.getEntryKind() == 1) {
                        url2 = JavaClassLoaderFactory.getURL((IPath)entry.getPath());
                        if (url2 == null) continue;
                        urls.add(url2);
                        continue;
                    }
                    if (entry.getEntryKind() != 4 || (url2 = JavaClassLoaderFactory.getURL((IPath)entry.getPath())) == null) continue;
                    urls.add(url2);
                }
            }
            catch (Throwable t) {
                throw new CoreException(EGFPlatformPlugin.getDefault().newStatus(4, NLS.bind((String)CorePlatformMessages.Bundle_AnalysisFailure, (Object)BundleHelper.getBundleId((IPluginModelBase)model)), t));
            }
        }
        finally {
            if (javaProject != null) {
                try {
                    javaProject.close();
                }
                catch (Throwable throwable) {}
            }
        }
        return urls;
    }

    protected static List<IPluginModelBase> getProjects(IPluginModelBase model, List<IClasspathEntry> classpathEntries) throws CoreException {
        UniqueEList models = new UniqueEList();
        if (model == null) {
            return models;
        }
        try {
            for (IClasspathEntry entry : classpathEntries) {
                ModelEntry modelEntry;
                IProject innerProject;
                if (entry.getEntryKind() != 2 || (innerProject = ResourcesPlugin.getWorkspace().getRoot().getProject(entry.getPath().toString())) == null || !innerProject.exists() || !innerProject.isOpen() || (modelEntry = PluginRegistry.findEntry((String)innerProject.getName())) == null || modelEntry.getModel() == null) continue;
                models.add(modelEntry.getModel());
                models.addAll(BundleClassLoaderFactory.getProjects(modelEntry.getModel()));
            }
        }
        catch (Throwable t) {
            throw new CoreException(EGFPlatformPlugin.getDefault().newStatus(4, NLS.bind((String)CorePlatformMessages.Bundle_AnalysisFailure, (Object)BundleHelper.getBundleId((IPluginModelBase)model)), t));
        }
        return models;
    }

    protected static List<URL> getBundlesURLs(IPluginModelBase model, List<IClasspathEntry> classpathEntries, List<IProject> visitedProjects) throws CoreException {
        UniqueEList urls = new UniqueEList();
        if (model == null) {
            return urls;
        }
        IProject project = null;
        if (model.getUnderlyingResource() != null && (project = model.getUnderlyingResource().getProject()) != null && visitedProjects != null && visitedProjects.contains(project)) {
            return urls;
        }
        try {
            urls.addAll(BundleClassLoaderFactory.getBundleURLs(model, classpathEntries));
            for (IPluginModelBase dependentModel : BundleClassLoaderFactory.getProjects(model, classpathEntries)) {
                urls.addAll(BundleClassLoaderFactory.getBundlesURLs(dependentModel, visitedProjects));
            }
            if (visitedProjects != null && project != null) {
                visitedProjects.add(project);
            }
        }
        catch (Throwable t) {
            throw new CoreException(EGFPlatformPlugin.getDefault().newStatus(4, NLS.bind((String)CorePlatformMessages.Bundle_AnalysisFailure, (Object)BundleHelper.getBundleId((IPluginModelBase)model)), t));
        }
        return urls;
    }

    public static IBundleClassLoader getBundleClassLoader(IPluginModelBase model) throws CoreException {
        return BundleClassLoaderFactory.getBundleClassLoader(model, null);
    }

    public static IBundleClassLoader getBundleClassLoader(final IPluginModelBase model, ClassLoader parent) throws CoreException {
        IBundleClassLoader iBundleClassLoader;
        if (model == null) {
            return null;
        }
        long startTime = System.currentTimeMillis();
        UniqueEList visitedProjects = new UniqueEList();
        List<URL> urls = BundleClassLoaderFactory.getBundlesURLs(model, (List<IProject>)visitedProjects);
        UniqueEList visited = visitedProjects;
        long endTime = System.currentTimeMillis();
        try {
            iBundleClassLoader = AccessController.doPrivileged(new PrivilegedAction<IBundleClassLoader>((List)visited, urls, parent){
                private final /* synthetic */ List val$visited;
                private final /* synthetic */ List val$urls;
                private final /* synthetic */ ClassLoader val$parent;
                {
                    this.val$visited = list;
                    this.val$urls = list2;
                    this.val$parent = classLoader;
                }

                @Override
                public IBundleClassLoader run() {
                    return new BundleClassLoader(model, this.val$visited, this.val$urls.toArray(new URL[this.val$urls.size()]), this.val$parent);
                }
            });
        }
        catch (Throwable throwable) {
            if (EGFPlatformPlugin.getDefault().isDebugging()) {
                long time = endTime - startTime;
                EGFPlatformPlugin.getDefault().logInfo(NLS.bind((String)"BundleClassLoaderFactory _ build an {0} in ''{1}'' ms", (Object[])new Object[]{IBundleClassLoader.class.getSimpleName(), time}));
            }
            throw throwable;
        }
        if (EGFPlatformPlugin.getDefault().isDebugging()) {
            long time = endTime - startTime;
            EGFPlatformPlugin.getDefault().logInfo(NLS.bind((String)"BundleClassLoaderFactory _ build an {0} in ''{1}'' ms", (Object[])new Object[]{IBundleClassLoader.class.getSimpleName(), time}));
        }
        return iBundleClassLoader;
    }
}

